/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.variantsandventures.common.client.render.entity;

import com.faboslav.variantsandventures.common.VariantsAndVentures;
import com.faboslav.variantsandventures.common.client.model.GelidEntityModel;
import com.faboslav.variantsandventures.common.client.render.entity.feature.GelidOverlayFeatureRenderer;
import com.faboslav.variantsandventures.common.entity.mob.GelidEntity;
import com.faboslav.variantsandventures.common.init.VariantsAndVenturesModelLayers;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.renderer.entity.AbstractZombieRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;

public class GelidEntityRenderer
extends AbstractZombieRenderer<GelidEntity, GelidEntityModel<GelidEntity>> {
    public static final ResourceLocation TEXTURE = VariantsAndVentures.makeID("textures/entity/gelid/gelid.png");

    public GelidEntityRenderer(EntityRendererProvider.Context context) {
        super(context, new GelidEntityModel(context.bakeLayer(VariantsAndVenturesModelLayers.GELID)), new GelidEntityModel(context.bakeLayer(VariantsAndVenturesModelLayers.GELID_INNER_ARMOR)), new GelidEntityModel(context.bakeLayer(VariantsAndVenturesModelLayers.GELID_OUTER_ARMOR)));
        this.addLayer(new GelidOverlayFeatureRenderer(this, context.getModelSet()));
    }

    public ResourceLocation getTextureLocation(GelidEntity gelid) {
        return TEXTURE;
    }

    protected void scale(GelidEntity gelid, PoseStack matrixStack, float partialTick) {
        matrixStack.scale(1.0625f, 1.0625f, 1.0625f);
        super.scale((LivingEntity)gelid, matrixStack, partialTick);
    }

    protected void setupRotations(GelidEntity gelid, PoseStack matrices, float animationProgress, float bodyYaw, float tickDelta, float scale) {
        super.setupRotations((LivingEntity)gelid, matrices, animationProgress, bodyYaw, tickDelta, scale);
        float h = gelid.getSwimAmount(tickDelta);
        if (h > 0.0f) {
            float angle = Mth.lerp((float)h, (float)gelid.getXRot(), (float)(-10.0f - gelid.getXRot()));
            matrices.mulPose(Axis.XP.rotationDegrees(angle));
        }
    }
}

