/*
 * Decompiled with CFR 0.152.
 */
package com.izofar.takesapillage.common.client.render.entity.renderer;

import com.izofar.takesapillage.common.ItTakesPillage;
import com.izofar.takesapillage.common.client.render.entity.model.ClayGolemModel;
import com.izofar.takesapillage.common.client.render.entity.renderer.layer.ClayGolemCrackinessLayer;
import com.izofar.takesapillage.common.client.render.entity.renderer.layer.ClayGolemFlowerLayer;
import com.izofar.takesapillage.common.entity.ClayGolem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;

public final class ClayGolemRenderer
extends MobRenderer<ClayGolem, ClayGolemModel> {
    private static final ResourceLocation TEXTURE = ItTakesPillage.makeId("textures/entity/clay_golem/clay_golem.png");

    public ClayGolemRenderer(EntityRendererProvider.Context context) {
        super(context, (EntityModel)new ClayGolemModel(ClayGolemModel.createBodyLayer().bakeRoot()), 0.7f);
        this.addLayer(new ClayGolemCrackinessLayer((RenderLayerParent<ClayGolem, ClayGolemModel>)this));
        this.addLayer(new ClayGolemFlowerLayer((RenderLayerParent<ClayGolem, ClayGolemModel>)this));
    }

    protected void setupRotations(ClayGolem clayGolem, PoseStack poseStack, float pitch, float yaw, float roll, float i) {
        super.setupRotations((LivingEntity)clayGolem, poseStack, pitch, yaw, roll, i);
        if ((double)clayGolem.walkAnimation.speed() >= 0.01) {
            float f1 = clayGolem.walkAnimation.position(roll) + 6.0f;
            float f2 = (Math.abs(f1 % 13.0f - 6.5f) - 3.25f) / 3.25f;
            poseStack.mulPose(Axis.ZP.rotationDegrees(6.5f * f2));
        }
    }

    public ResourceLocation getTextureLocation(ClayGolem clayGolem) {
        return TEXTURE;
    }
}

