/*
 * Decompiled with CFR 0.152.
 */
package einstein.subtle_effects.ticking.tickers;

import einstein.subtle_effects.init.ModConfigs;
import einstein.subtle_effects.ticking.tickers.BlockPosTicker;
import einstein.subtle_effects.ticking.tickers.TickerManager;
import einstein.subtle_effects.util.ChestAccessor;
import einstein.subtle_effects.util.MathUtil;
import einstein.subtle_effects.util.Util;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.AbstractChestBlock;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BubbleColumnBlock;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.ChestBlockEntity;
import net.minecraft.world.level.block.entity.ChestLidController;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.ChestType;
import net.minecraft.world.level.block.state.properties.Property;

public class ChestBlockEntityTicker
extends BlockPosTicker {
    private static final int MAX_TICKS_SINCE_LAST_ANIMATION = 100;
    private static final Map<BlockPos, ChestBlockEntityTicker> CHEST_TICKERS = new HashMap<BlockPos, ChestBlockEntityTicker>();
    private int ticksSinceLastAnimation;
    private int animationTicks;
    private float oldOpenness;
    private final ChestLidController lidController;

    public ChestBlockEntityTicker(Level level, BlockPos pos, ChestLidController lidController) {
        super(level, pos);
        this.lidController = lidController;
    }

    public static void trySpawn(Level level, BlockPos pos) {
        if (!ModConfigs.BLOCKS.chestsOpenRandomlyUnderwater && !ModConfigs.BLOCKS.openingChestsSpawnsBubbles) {
            return;
        }
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity == null || CHEST_TICKERS.containsKey(pos)) {
            return;
        }
        if (blockEntity instanceof ChestAccessor) {
            ChestAccessor chestAccessor = (ChestAccessor)blockEntity;
            ChestBlockEntityTicker ticker = new ChestBlockEntityTicker(level, pos, chestAccessor.subtleEffects$getLidController());
            CHEST_TICKERS.put(pos, ticker);
            TickerManager.add(ticker);
        }
    }

    public static void clear() {
        CHEST_TICKERS.values().forEach(ticker -> ticker.lidController.shouldBeOpen(false));
        CHEST_TICKERS.clear();
    }

    @Override
    protected void positionedTick() {
        ChestType type;
        BlockState state = this.level.getBlockState(this.pos);
        if (!(state.getBlock() instanceof AbstractChestBlock)) {
            this.remove();
            return;
        }
        BlockEntity blockEntity = this.level.getBlockEntity(this.pos);
        if (!(blockEntity instanceof ChestBlockEntity)) {
            return;
        }
        ChestType chestType = type = state.hasProperty((Property)ChestBlock.TYPE) ? (ChestType)state.getValue((Property)ChestBlock.TYPE) : ChestType.SINGLE;
        if (type == ChestType.LEFT) {
            return;
        }
        boolean isDoubleChest = type != ChestType.SINGLE;
        Direction connectedDirection = isDoubleChest ? ChestBlock.getConnectedDirection((BlockState)state) : Direction.NORTH;
        BlockPos oppositePos = this.pos.relative(connectedDirection);
        if (ChestBlock.isChestBlockedAt((LevelAccessor)this.level, (BlockPos)this.pos) || isDoubleChest && ChestBlock.isChestBlockedAt((LevelAccessor)this.level, (BlockPos)oppositePos)) {
            this.animationTicks = 0;
            this.ticksSinceLastAnimation = 0;
            return;
        }
        if (ModConfigs.BLOCKS.randomChestOpeningNeedsSoulSand && (ChestBlockEntityTicker.isNotUpwardsBubbleColumn(this.level, this.pos) || isDoubleChest && ChestBlockEntityTicker.isNotUpwardsBubbleColumn(this.level, oppositePos))) {
            return;
        }
        if (!ChestBlockEntityTicker.isUnderwater(this.level, this.pos) || isDoubleChest && !ChestBlockEntityTicker.isUnderwater(this.level, oppositePos)) {
            return;
        }
        RandomSource random = this.level.getRandom();
        float openness = this.lidController.getOpenness(Util.getPartialTicks());
        if (openness > 0.0f && ModConfigs.BLOCKS.openingChestsSpawnsBubbles) {
            boolean isClosing;
            boolean bl = isClosing = (double)openness <= 0.5 && openness < this.oldOpenness;
            if (isClosing || random.nextInt(isDoubleChest ? 2 : 4) == 0) {
                double xOffset = 0.0;
                double zOffset = 0.0;
                double xRandomOffset = 0.3125;
                double zRandomOffset = 0.3125;
                if (isDoubleChest) {
                    xOffset = 0.5 * (double)connectedDirection.getStepX();
                    zOffset = 0.5 * (double)connectedDirection.getStepZ();
                    Direction.Axis axis = connectedDirection.getAxis();
                    if (axis == Direction.Axis.X) {
                        xRandomOffset = 0.8125;
                    } else if (axis == Direction.Axis.Z) {
                        zRandomOffset = 0.8125;
                    }
                }
                double xSpeed = 0.0;
                double zSpeed = 0.0;
                if (isClosing) {
                    Direction facing = (Direction)state.getValue((Property)ChestBlock.FACING);
                    xSpeed = 0.5 * (double)facing.getStepX();
                    zSpeed = 0.5 * (double)facing.getStepZ();
                }
                this.level.addParticle((ParticleOptions)ParticleTypes.BUBBLE_COLUMN_UP, (double)this.pos.getX() + 0.5 + xOffset + MathUtil.nextNonAbsDouble(random, xRandomOffset), (double)this.pos.getY() + 0.625, (double)this.pos.getZ() + 0.5 + zOffset + MathUtil.nextNonAbsDouble(random, zRandomOffset), xSpeed, 0.0, zSpeed);
            }
        }
        this.oldOpenness = openness;
        if (ChestBlockEntityTicker.isDownwardsBubbleColumn(this.level, this.pos) || isDoubleChest && ChestBlockEntityTicker.isDownwardsBubbleColumn(this.level, oppositePos)) {
            return;
        }
        if (this.ticksSinceLastAnimation < 100) {
            ++this.ticksSinceLastAnimation;
            return;
        }
        boolean isEnderChest = state.is(Blocks.ENDER_CHEST);
        if (ModConfigs.BLOCKS.chestsOpenRandomlyUnderwater && random.nextInt(100) == 0 && openness == 0.0f) {
            blockEntity.triggerEvent(1, 1);
            this.playSound(connectedDirection, type, isEnderChest ? SoundEvents.ENDER_CHEST_OPEN : SoundEvents.CHEST_OPEN);
            this.animationTicks = Mth.nextInt((RandomSource)random, (int)50, (int)200);
            return;
        }
        if (this.animationTicks > 0) {
            --this.animationTicks;
            if (this.animationTicks <= 0) {
                blockEntity.triggerEvent(1, 0);
                this.playSound(connectedDirection, type, isEnderChest ? SoundEvents.ENDER_CHEST_CLOSE : SoundEvents.CHEST_CLOSE);
                this.ticksSinceLastAnimation = 0;
            }
        }
    }

    public static boolean isNotUpwardsBubbleColumn(Level level, BlockPos pos) {
        BlockState belowState = level.getBlockState(pos.below());
        return !belowState.is(Blocks.SOUL_SAND) && (!belowState.is(Blocks.BUBBLE_COLUMN) || (Boolean)belowState.getValue((Property)BubbleColumnBlock.DRAG_DOWN) != false);
    }

    public static boolean isDownwardsBubbleColumn(Level level, BlockPos pos) {
        BlockState belowState = level.getBlockState(pos.below());
        return belowState.is(Blocks.MAGMA_BLOCK) || belowState.is(Blocks.BUBBLE_COLUMN) && (Boolean)belowState.getValue((Property)BubbleColumnBlock.DRAG_DOWN) != false;
    }

    @Override
    public void remove() {
        super.remove();
        CHEST_TICKERS.remove(this.pos);
    }

    public static boolean isUnderwater(Level level, BlockPos pos) {
        return level.isWaterAt(pos) && level.getBlockState(pos.above()).is(Blocks.WATER);
    }

    private void playSound(Direction direction, ChestType type, SoundEvent sound) {
        double x = (float)this.pos.getX() + 0.5f;
        double y = (float)this.pos.getY() + 0.5f;
        double z = (float)this.pos.getZ() + 0.5f;
        if (type == ChestType.RIGHT) {
            x += (double)((float)direction.getStepX() * 0.5f);
            z += (double)((float)direction.getStepZ() * 0.5f);
        }
        this.level.playSound((Player)Minecraft.getInstance().player, x, y, z, sound, SoundSource.BLOCKS, 0.5f, this.level.getRandom().nextFloat() * 0.1f + 0.9f);
    }
}

