/*
 * Decompiled with CFR 0.152.
 */
package einstein.subtle_effects.particle;

import com.mojang.blaze3d.vertex.VertexConsumer;
import einstein.subtle_effects.particle.FeatherParticle;
import einstein.subtle_effects.particle.option.SheepFluffParticleOptions;
import einstein.subtle_effects.util.Util;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.util.FastColor;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.animal.Sheep;
import net.minecraft.world.item.DyeColor;

public class SheepFluffParticle
extends FeatherParticle {
    private final int sheepId;
    private final boolean isJeb;
    private final Entity sheep;

    protected SheepFluffParticle(ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed, SpriteSet sprites, SheepFluffParticleOptions options) {
        super(level, x, y, z, xSpeed, ySpeed, zSpeed, sprites);
        this.sheepId = options.sheepId();
        this.isJeb = options.isJeb();
        this.sheep = this.isJeb ? level.getEntity(this.sheepId) : null;
        this.gravity = 0.5f;
        if (!this.isJeb) {
            Util.setColorFromHex((Particle)this, Sheep.getColor((DyeColor)options.color()));
        }
    }

    public void render(VertexConsumer buffer, Camera renderInfo, float partialTicks) {
        if (this.isJeb) {
            int speed = 25;
            int tickCount = this.sheep.tickCount;
            int i = tickCount / speed + this.sheepId;
            int length = DyeColor.values().length;
            float delta = ((float)(tickCount % speed) + partialTicks) / (float)speed;
            int startColor = Sheep.getColor((DyeColor)DyeColor.byId((int)(i % length)));
            int endColor = Sheep.getColor((DyeColor)DyeColor.byId((int)((i + 1) % length)));
            Util.setColorFromHex((Particle)this, FastColor.ARGB32.lerp((float)delta, (int)startColor, (int)endColor));
        }
        super.render(buffer, renderInfo, partialTicks);
    }

    public record Provider(SpriteSet sprites) implements ParticleProvider<SheepFluffParticleOptions>
    {
        public Particle createParticle(SheepFluffParticleOptions options, ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            return new SheepFluffParticle(level, x, y, z, xSpeed, ySpeed, zSpeed, this.sprites, options);
        }
    }
}

