/*
 * Decompiled with CFR 0.152.
 */
package einstein.subtle_effects.particle;

import einstein.subtle_effects.particle.FlatPlaneParticle;
import einstein.subtle_effects.particle.option.GeyserSpoutParticleOptions;
import einstein.subtle_effects.ticking.tickers.geyser.GeyserTicker;
import einstein.subtle_effects.ticking.tickers.geyser.GeyserType;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.SupportType;

public class GeyserSpoutParticle
extends FlatPlaneParticle {
    private static final int FADE_TIME = 60;
    private static final float START_ALPHA = 1.0f;
    private final int geyserLifeTime;
    private final GeyserType type;
    private final BlockPos pos;

    protected GeyserSpoutParticle(ClientLevel level, double x, double y, double z, SpriteSet sprites, GeyserSpoutParticleOptions options) {
        super(level, x, y, z);
        this.pos = BlockPos.containing((double)this.x, (double)this.y, (double)this.z);
        this.geyserLifeTime = options.lifeTime();
        this.type = options.type();
        this.rotation.rotateY((float)(90 * this.random.nextInt(3)) * ((float)Math.PI / 180)).rotateX(1.5707964f);
        this.lifetime = this.geyserLifeTime + 60;
        this.hasPhysics = false;
        this.renderBackFace = false;
        this.alpha = 1.0f;
        this.quadSize = 0.5f;
        this.setSize(1.5f, 0.1f);
        this.pickSprite(sprites);
    }

    public void tick() {
        if (!GeyserTicker.isSpawnableBlock(this.type, (Level)this.level, this.pos.below(), SupportType.RIGID)) {
            this.remove();
            return;
        }
        if (this.age >= this.geyserLifeTime) {
            this.alpha -= 0.016666668f;
        }
        if (this.age++ >= this.lifetime) {
            this.remove();
        }
    }

    public ParticleRenderType getRenderType() {
        return ParticleRenderType.PARTICLE_SHEET_TRANSLUCENT;
    }

    public record Provider(SpriteSet sprites) implements ParticleProvider<GeyserSpoutParticleOptions>
    {
        public Particle createParticle(GeyserSpoutParticleOptions options, ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            return new GeyserSpoutParticle(level, x, y, z, this.sprites, options);
        }
    }
}

