/*
 * Decompiled with CFR 0.152.
 */
package einstein.subtle_effects.mixin.client.entity;

import einstein.subtle_effects.init.ModConfigs;
import einstein.subtle_effects.init.ModParticles;
import einstein.subtle_effects.init.ModSounds;
import einstein.subtle_effects.particle.option.DirectionParticleOptions;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ThrownEgg;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ThrownEgg.class})
public abstract class ThrownEggMixin {
    @Unique
    private final ThrownEgg subtleEffects$me = (ThrownEgg)this;

    @Inject(method={"handleEntityEvent"}, at={@At(value="TAIL")})
    private void handle(byte id, CallbackInfo ci) {
        if (id == 3) {
            List spawnedEntities;
            Level level = this.subtleEffects$me.level();
            RandomSource random = this.subtleEffects$me.getRandom();
            float volume = ((Float)ModConfigs.ITEMS.projectiles.eggSmashSoundVolume.get()).floatValue();
            if (volume > 0.0f) {
                level.playSound((Player)Minecraft.getInstance().player, this.subtleEffects$me.getX(), this.subtleEffects$me.getY(), this.subtleEffects$me.getZ(), ModSounds.EGG_BREAK.get(), SoundSource.PLAYERS, volume, Mth.nextFloat((RandomSource)random, (float)0.7f, (float)1.5f));
            }
            if (ModConfigs.ITEMS.projectiles.eggSplatParticles && (spawnedEntities = level.getEntities((Entity)null, this.subtleEffects$me.getBoundingBox(), entity -> {
                if (entity instanceof AgeableMob) {
                    AgeableMob ageableMob = (AgeableMob)entity;
                    return ageableMob.isBaby();
                }
                return false;
            })).isEmpty()) {
                Vec3 delta = this.subtleEffects$me.getDeltaMovement();
                Vec3 position = this.subtleEffects$me.position();
                BlockHitResult result = level.clip(new ClipContext(position, position.add(delta), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this.subtleEffects$me));
                if (result.getType() != HitResult.Type.MISS) {
                    Direction direction = result.getDirection();
                    BlockPos pos = result.getBlockPos();
                    BlockState state = level.getBlockState(pos);
                    Vec3 location = result.getLocation();
                    if (!state.isAir()) {
                        Direction opposite = direction.getOpposite();
                        Direction.Axis axis = opposite.getAxis();
                        double offset = (double)direction.getAxisDirection().getStep() * Mth.nextDouble((RandomSource)random, (double)0.001, (double)0.002);
                        level.addParticle((ParticleOptions)new DirectionParticleOptions(ModParticles.EGG_SPLAT.get(), opposite), axis == Direction.Axis.X ? (double)Math.round(location.x()) + offset : location.x(), axis == Direction.Axis.Y ? (double)Math.round(location.y()) + offset : location.y(), axis == Direction.Axis.Z ? (double)Math.round(location.z()) + offset : location.z(), 0.0, 0.0, 0.0);
                    }
                }
            }
        }
    }
}

