/*
 * Decompiled with CFR 0.152.
 */
package einstein.subtle_effects.compat;

import com.anthonyhilyard.iceberg.util.Selectors;
import com.anthonyhilyard.itemborders.compat.LegendaryTooltipsHandler;
import com.anthonyhilyard.itemborders.config.ItemBordersConfig;
import com.mojang.datafixers.util.Pair;
import einstein.subtle_effects.compat.CompatHelper;
import einstein.subtle_effects.mixin.client.ItemBordersConfigAccessor;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.TextColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.Level;

public class ItemBordersCompat {
    private static final String ITEM_BORDERS_COLORS_TAG = "itemborders_colors";

    public static TextColor getManualBorderColor(Level level, ItemStack stack) {
        Map<String, Object> manualBorders = ((ItemBordersConfigAccessor)ItemBordersConfig.getInstance()).getManualBorders().get();
        RegistryAccess access = level.registryAccess();
        for (String colorString : manualBorders.keySet()) {
            TextColor color = ItemBordersConfig.getColor((Object)colorString);
            if (color == null) continue;
            Object object = manualBorders.get(colorString);
            if (ItemBordersCompat.matchesStack(access, stack, object)) {
                return color;
            }
            if (!(object instanceof List)) continue;
            List list = (List)object;
            for (Object obj : list) {
                if (!ItemBordersCompat.matchesStack(access, stack, obj)) continue;
                return color;
            }
        }
        return null;
    }

    private static boolean matchesStack(RegistryAccess access, ItemStack stack, Object object) {
        if (object instanceof String) {
            String string = (String)object;
            return Selectors.itemMatches((ItemStack)stack, (String)string, (HolderLookup.Provider)access);
        }
        return false;
    }

    public static List<TextColor> getNBTBorderColor(ItemStack stack) {
        Pair borderColors;
        CompoundTag tag;
        if (stack.has(DataComponents.CUSTOM_DATA) && (tag = ((CustomData)stack.get(DataComponents.CUSTOM_DATA)).copyTag()).contains(ITEM_BORDERS_COLORS_TAG)) {
            CompoundTag colorsTag = tag.getCompound(ITEM_BORDERS_COLORS_TAG);
            ArrayList<TextColor> colors = new ArrayList<TextColor>();
            if (colorsTag.contains("top", 8)) {
                colors.add(ItemBordersConfig.getColor((Object)colorsTag.getString("top")));
            }
            if (colorsTag.contains("bottom", 8)) {
                colors.add(ItemBordersConfig.getColor((Object)colorsTag.getString("bottom")));
            }
            return colors.stream().filter(Objects::nonNull).toList();
        }
        if (CompatHelper.IS_LEGENDARY_TOOLTIPS_LOADED.get().booleanValue() && ((Boolean)ItemBordersConfig.getInstance().legendaryTooltipsSync.get()).booleanValue() && (borderColors = LegendaryTooltipsHandler.getBorderColors((ItemStack)stack)) != null) {
            ArrayList<TextColor> colors = new ArrayList<TextColor>();
            colors.add(TextColor.fromRgb((int)((Integer)((Supplier)borderColors.getFirst()).get())));
            colors.add(TextColor.fromRgb((int)((Integer)((Supplier)borderColors.getSecond()).get())));
            return colors;
        }
        return List.of();
    }
}

