/*
 * Decompiled with CFR 0.152.
 */
package einstein.subtle_effects.compat;

import einstein.subtle_effects.particle.SparkParticle;
import fuzs.dyedflames.init.ModRegistry;
import fuzs.dyedflames.world.level.block.FireType;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import org.jetbrains.annotations.Nullable;

public class DyedFlamesCompat {
    public static ParticleOptions getFlameParticle(Entity entity) {
        Block block = (Block)ModRegistry.LAST_FIRE_SOURCE_ATTACHMENT_TYPE.get((Object)entity);
        if (block != null) {
            if (block == Blocks.FIRE || block == Blocks.LAVA) {
                return ParticleTypes.FLAME;
            }
            if (block == Blocks.SOUL_FIRE) {
                return ParticleTypes.SOUL_FIRE_FLAME;
            }
            Optional fireType = FireType.getFireType((Block)block);
            if (fireType.isPresent()) {
                return ((FireType)fireType.get()).particleType().orElse(null);
            }
        }
        return null;
    }

    @Nullable
    public static List<Integer> getSparkParticle(Entity entity) {
        Block block = (Block)ModRegistry.LAST_FIRE_SOURCE_ATTACHMENT_TYPE.get((Object)entity);
        if (block == Blocks.FIRE) {
            return SparkParticle.DEFAULT_COLORS;
        }
        if (block == Blocks.SOUL_FIRE) {
            return SparkParticle.SOUL_COLORS;
        }
        return null;
    }
}

