/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.fastpaintings;

import net.mehvahdjukaar.fastpaintings.FastPaintings;
import net.mehvahdjukaar.fastpaintings.PaintingBlock;
import net.mehvahdjukaar.moonlight.api.client.model.ExtraModelData;
import net.mehvahdjukaar.moonlight.api.client.model.IExtraModelDataProvider;
import net.mehvahdjukaar.moonlight.api.client.model.ModelDataKey;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.VariantHolder;
import net.minecraft.world.entity.decoration.PaintingVariant;
import net.minecraft.world.entity.decoration.PaintingVariants;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class PaintingBlockEntity
extends BlockEntity
implements IExtraModelDataProvider,
VariantHolder<Holder<PaintingVariant>> {
    public static final ModelDataKey<PaintingVariant> MIMIC_KEY = new ModelDataKey(PaintingVariant.class);
    private Holder<PaintingVariant> variant = PaintingBlockEntity.getDefaultVariant((HolderLookup.RegistryLookup<PaintingVariant>)Utils.hackyGetRegistryAccess().registryOrThrow(Registries.PAINTING_VARIANT).asLookup());
    private boolean placedWithNbt = false;
    boolean hasDroppedItemHack = false;

    public PaintingBlockEntity(BlockPos blockPos, BlockState blockState) {
        super(FastPaintings.PAINTING_TILE.get(), blockPos, blockState);
        Item.BY_BLOCK.put(FastPaintings.PAINTING_BLOCK.get(), Items.PAINTING);
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        ResourceKey resourceKey = ResourceKey.create((ResourceKey)Registries.PAINTING_VARIANT, (ResourceLocation)ResourceLocation.tryParse((String)tag.getString("variant")));
        HolderLookup.RegistryLookup paintingsReg = registries.lookupOrThrow(Registries.PAINTING_VARIANT);
        this.setVariant((Holder<PaintingVariant>)((Holder)paintingsReg.get(resourceKey).orElseGet(() -> PaintingBlockEntity.getDefaultVariant((HolderLookup.RegistryLookup<PaintingVariant>)paintingsReg))));
        this.placedWithNbt = tag.getBoolean("placed_with_nbt");
    }

    @NotNull
    private static Holder.Reference<PaintingVariant> getDefaultVariant(HolderLookup.RegistryLookup<PaintingVariant> reg) {
        return reg.getOrThrow(PaintingVariants.KEBAB);
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        tag.putString("variant", this.getVariant().unwrapKey().orElse(PaintingVariants.KEBAB).location().toString());
        tag.putBoolean("placed_with_nbt", this.placedWithNbt);
    }

    public void setVariant(Holder<PaintingVariant> variant) {
        this.variant = variant;
        this.setChanged();
    }

    public void setPlacedWithNbt(boolean bool) {
        this.placedWithNbt = bool;
    }

    public boolean isPlacedWithNbt() {
        return this.placedWithNbt;
    }

    public Holder<PaintingVariant> getVariant() {
        return this.variant;
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider registries) {
        return this.saveWithoutMetadata(registries);
    }

    public void addExtraModelData(ExtraModelData.Builder builder) {
        builder.with(MIMIC_KEY, (Object)((PaintingVariant)this.getVariant().value()));
    }

    public Vec3 getPaintingDropLocation() {
        int w = ((PaintingVariant)this.getVariant().value()).width();
        int h = ((PaintingVariant)this.getVariant().value()).height();
        BlockPos pos = this.getBlockPos();
        Direction dir = (Direction)this.getBlockState().getValue((Property)PaintingBlock.FACING);
        return switch (dir) {
            case Direction.NORTH -> new Vec3((double)pos.getX() + 0.5, (double)pos.getY() + (double)h / 2.0, (double)pos.getZ() - (double)w / 2.0);
            case Direction.SOUTH -> new Vec3((double)pos.getX() + 0.5, (double)pos.getY() + (double)h / 2.0, (double)(pos.getZ() + w) + 0.5);
            case Direction.WEST -> new Vec3((double)pos.getX() - (double)w / 2.0, (double)pos.getY() + (double)h / 2.0, (double)pos.getZ() + 0.5);
            case Direction.EAST -> new Vec3((double)(pos.getX() + w) + 0.5, (double)pos.getY() + (double)h / 2.0, (double)pos.getZ() + 0.5);
            default -> throw new IllegalStateException("Unexpected value: " + String.valueOf(dir));
        };
    }
}

