/*
 * Decompiled with CFR 0.152.
 */
package com.misterxycb.horsebreedingfix.event;

import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.animal.horse.Horse;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.living.BabyEntitySpawnEvent;

@EventBusSubscriber
public class BabyHorseEvent {
    @SubscribeEvent
    public static void onBabyHorseSpawn(BabyEntitySpawnEvent event) {
        AgeableMob ageableMob = event.getChild();
        if (ageableMob instanceof Horse) {
            Horse child = (Horse)ageableMob;
            Horse parent = (Horse)event.getParentA();
            Horse mate = (Horse)event.getParentB();
            double minHealth = Math.max(parent.getAttributeBaseValue(Attributes.MAX_HEALTH), mate.getAttributeBaseValue(Attributes.MAX_HEALTH));
            double minJumpStrength = Math.max(parent.getAttributeBaseValue(Attributes.JUMP_STRENGTH), mate.getAttributeBaseValue(Attributes.JUMP_STRENGTH));
            double minSpeed = Math.max(parent.getAttributeBaseValue(Attributes.MOVEMENT_SPEED), mate.getAttributeBaseValue(Attributes.MOVEMENT_SPEED));
            if (child.getAttributeBaseValue(Attributes.MAX_HEALTH) < minHealth) {
                double newHealth = Math.min(minHealth + Math.random() * 3.0 * 0.5, 30.0);
                child.getAttribute(Attributes.MAX_HEALTH).setBaseValue(newHealth);
            }
            if (child.getAttributeBaseValue(Attributes.JUMP_STRENGTH) < minJumpStrength) {
                double newJumpStrength = Math.min(minJumpStrength + Math.random() * 3.0 * 0.02, 1.0);
                child.getAttribute(Attributes.JUMP_STRENGTH).setBaseValue(newJumpStrength);
            }
            if (child.getAttributeBaseValue(Attributes.MOVEMENT_SPEED) < minSpeed) {
                double newSpeed = Math.min(minSpeed + Math.random() * 3.0 * 0.01, 0.3375);
                child.getAttribute(Attributes.MOVEMENT_SPEED).setBaseValue(newSpeed);
            }
        }
    }
}

