/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.world.structure;

import com.aetherteam.aether.AetherTags;
import com.aetherteam.aether.world.structure.AetherStructureTypes;
import com.aetherteam.aether.world.structurepiece.GlowstoneRuinedPortalPiece;
import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Optional;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.NoiseColumn;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.RandomState;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;

public class GlowstoneRuinedPortalStructure
extends Structure {
    private static final String[] STRUCTURE_LOCATION_PORTALS = new String[]{"ruined_portal/portal_1", "ruined_portal/portal_2", "ruined_portal/portal_3", "ruined_portal/portal_4", "ruined_portal/portal_5", "ruined_portal/portal_6", "ruined_portal/portal_7", "ruined_portal/portal_8", "ruined_portal/portal_9", "ruined_portal/portal_10"};
    private static final String[] STRUCTURE_LOCATION_GIANT_PORTALS = new String[]{"ruined_portal/giant_portal_1", "ruined_portal/giant_portal_2", "ruined_portal/giant_portal_3"};
    private final List<Setup> setups;
    public static final MapCodec<GlowstoneRuinedPortalStructure> CODEC = RecordCodecBuilder.mapCodec(codec -> codec.group((App)GlowstoneRuinedPortalStructure.settingsCodec((RecordCodecBuilder.Instance)codec), (App)ExtraCodecs.nonEmptyList((Codec)Setup.CODEC.codec().listOf()).fieldOf("setups").forGetter(structure -> structure.setups)).apply((Applicative)codec, GlowstoneRuinedPortalStructure::new));

    public GlowstoneRuinedPortalStructure(Structure.StructureSettings settings, List<Setup> setups) {
        super(settings);
        this.setups = setups;
    }

    protected Optional<Structure.GenerationStub> findGenerationPoint(Structure.GenerationContext context) {
        GlowstoneRuinedPortalPiece.Properties pieceProperties = new GlowstoneRuinedPortalPiece.Properties();
        WorldgenRandom worldGenRandom = context.random();
        ChunkPos chunkPos = context.chunkPos();
        ChunkGenerator chunkGenerator = context.chunkGenerator();
        LevelHeightAccessor levelHeightAccessor = context.heightAccessor();
        RandomState randomState = context.randomState();
        BlockPos blockPosChunk = context.chunkPos().getWorldPosition();
        Setup portalSetup = null;
        if (this.setups.size() > 1) {
            float f = 0.0f;
            for (Setup setup : this.setups) {
                f += setup.weight();
            }
            float f1 = worldGenRandom.nextFloat();
            for (Setup setup2 : this.setups) {
                if (!((f1 -= setup2.weight() / f) < 0.0f)) continue;
                portalSetup = setup2;
                break;
            }
        } else {
            portalSetup = this.setups.getFirst();
        }
        if (portalSetup == null) {
            throw new IllegalStateException();
        }
        Setup setup3 = portalSetup;
        pieceProperties.airPocket = GlowstoneRuinedPortalStructure.sample(worldGenRandom, setup3.airPocketProbability());
        pieceProperties.mossiness = setup3.mossiness();
        pieceProperties.overgrown = setup3.overgrown();
        pieceProperties.vines = setup3.vines();
        pieceProperties.replaceWithHolystone = setup3.replaceWithHolystone();
        ResourceLocation location = worldGenRandom.nextFloat() < 0.05f ? ResourceLocation.fromNamespaceAndPath((String)"aether", (String)STRUCTURE_LOCATION_GIANT_PORTALS[worldGenRandom.nextInt(STRUCTURE_LOCATION_GIANT_PORTALS.length)]) : ResourceLocation.fromNamespaceAndPath((String)"aether", (String)STRUCTURE_LOCATION_PORTALS[worldGenRandom.nextInt(STRUCTURE_LOCATION_PORTALS.length)]);
        StructureTemplate structureTemplate = context.structureTemplateManager().getOrCreate(location);
        Rotation rotation = (Rotation)Util.getRandom((Object[])Rotation.values(), (RandomSource)worldGenRandom);
        Mirror mirror = worldGenRandom.nextFloat() < 0.5f ? Mirror.NONE : Mirror.FRONT_BACK;
        BlockPos blockPos = new BlockPos(structureTemplate.getSize().getX() / 2, 0, structureTemplate.getSize().getZ() / 2);
        BoundingBox boundingbox = structureTemplate.getBoundingBox(blockPosChunk, rotation, blockPos, mirror);
        BlockPos centerPos = boundingbox.getCenter();
        int i = chunkGenerator.getBaseHeight(centerPos.getX(), centerPos.getZ(), GlowstoneRuinedPortalPiece.getHeightMapType(setup3.placement()), levelHeightAccessor, randomState) - 1;
        int j = GlowstoneRuinedPortalStructure.findSuitableY((RandomSource)worldGenRandom, chunkGenerator, setup3.placement(), i, boundingbox.getYSpan(), boundingbox, levelHeightAccessor, randomState);
        BlockPos spawnPos = new BlockPos(blockPosChunk.getX(), j, blockPosChunk.getZ());
        if (GlowstoneRuinedPortalStructure.validCorners(chunkGenerator, levelHeightAccessor, chunkPos, randomState, spawnPos.getY())) {
            return Optional.of(new Structure.GenerationStub(spawnPos, builder -> builder.addPiece((StructurePiece)new GlowstoneRuinedPortalPiece(context.structureTemplateManager(), spawnPos, setup3.placement(), pieceProperties, location, rotation, mirror, blockPos))));
        }
        return Optional.empty();
    }

    private static boolean sample(WorldgenRandom random, float threshold) {
        if (threshold == 0.0f) {
            return false;
        }
        if (threshold == 1.0f) {
            return true;
        }
        return random.nextFloat() < threshold;
    }

    private static int findSuitableY(RandomSource random, ChunkGenerator chunkGenerator, GlowstoneRuinedPortalPiece.VerticalPlacement verticalPlacement, int height, int blockCountY, BoundingBox box, LevelHeightAccessor heightAccessor, RandomState randomState) {
        int l;
        int j = heightAccessor.getMinBuildHeight() + 15;
        int i = verticalPlacement == GlowstoneRuinedPortalPiece.VerticalPlacement.PARTLY_BURIED ? height - blockCountY + Mth.randomBetweenInclusive((RandomSource)random, (int)2, (int)8) : height;
        ImmutableList positions = ImmutableList.of((Object)new BlockPos(box.minX(), 0, box.minZ()), (Object)new BlockPos(box.maxX(), 0, box.minZ()), (Object)new BlockPos(box.minX(), 0, box.maxZ()), (Object)new BlockPos(box.maxX(), 0, box.maxZ()));
        List<NoiseColumn> noiseColumns = positions.stream().map(pos -> chunkGenerator.getBaseColumn(pos.getX(), pos.getZ(), heightAccessor, randomState)).toList();
        Heightmap.Types heightmap$types = verticalPlacement == GlowstoneRuinedPortalPiece.VerticalPlacement.ON_OCEAN_FLOOR ? Heightmap.Types.OCEAN_FLOOR : Heightmap.Types.WORLD_SURFACE;
        for (l = i; l > j; --l) {
            int i1 = 0;
            for (NoiseColumn noiseColumn : noiseColumns) {
                BlockState blockState = noiseColumn.getBlock(l);
                if (!heightmap$types.isOpaque().test(blockState) || ++i1 != 3) continue;
                return l;
            }
        }
        return l;
    }

    private static boolean validCorners(ChunkGenerator generator, LevelHeightAccessor heightAccessor, ChunkPos chunkPos, RandomState random, int spawnY) {
        NoiseColumn[] columns;
        int minX = chunkPos.getMinBlockX() - 1;
        int minZ = chunkPos.getMinBlockZ() - 1;
        int maxX = chunkPos.getMaxBlockX() + 1;
        int maxZ = chunkPos.getMaxBlockZ() + 1;
        for (NoiseColumn column : columns = new NoiseColumn[]{generator.getBaseColumn(minX, minZ, heightAccessor, random), generator.getBaseColumn(minX, maxZ, heightAccessor, random), generator.getBaseColumn(maxX, minZ, heightAccessor, random), generator.getBaseColumn(maxX, maxZ, heightAccessor, random)}) {
            if (column.getBlock(spawnY).isAir() || column.getBlock(spawnY).is(AetherTags.Blocks.NON_RUINED_PORTAL_SPAWNABLE)) continue;
            return true;
        }
        return false;
    }

    public StructureType<?> type() {
        return (StructureType)AetherStructureTypes.RUINED_PORTAL.get();
    }

    public record Setup(GlowstoneRuinedPortalPiece.VerticalPlacement placement, float airPocketProbability, float mossiness, boolean overgrown, boolean vines, boolean replaceWithHolystone, float weight) {
        public static final MapCodec<Setup> CODEC = RecordCodecBuilder.mapCodec(codec -> codec.group((App)GlowstoneRuinedPortalPiece.VerticalPlacement.CODEC.fieldOf("placement").forGetter(Setup::placement), (App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("air_pocket_probability").forGetter(Setup::airPocketProbability), (App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("mossiness").forGetter(Setup::mossiness), (App)Codec.BOOL.fieldOf("overgrown").forGetter(Setup::overgrown), (App)Codec.BOOL.fieldOf("vines").forGetter(Setup::vines), (App)Codec.BOOL.fieldOf("replace_with_holystone").forGetter(Setup::replaceWithHolystone), (App)ExtraCodecs.POSITIVE_FLOAT.fieldOf("weight").forGetter(Setup::weight)).apply((Applicative)codec, Setup::new));
    }
}

