/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.loot.functions;

import com.aetherteam.aether.item.tools.abilities.SkyrootTool;
import com.aetherteam.aether.loot.functions.AetherLootFunctions;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.functions.LootItemConditionalFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;

public class DoubleDrops
extends LootItemConditionalFunction {
    public static final MapCodec<DoubleDrops> CODEC = RecordCodecBuilder.mapCodec(instance -> DoubleDrops.commonFields((RecordCodecBuilder.Instance)instance).apply((Applicative)instance, DoubleDrops::new));

    protected DoubleDrops(List<LootItemCondition> conditions) {
        super(conditions);
    }

    protected ItemStack run(ItemStack stack, LootContext context) {
        Item item;
        ServerLevel level = context.getLevel();
        ItemStack toolStack = (ItemStack)context.getParamOrNull(LootContextParams.TOOL);
        BlockState blockState = (BlockState)context.getParamOrNull(LootContextParams.BLOCK_STATE);
        if (toolStack != null && (item = toolStack.getItem()) instanceof SkyrootTool) {
            SkyrootTool skyrootTool = (SkyrootTool)item;
            return skyrootTool.doubleDrops((Level)level, stack, toolStack, blockState);
        }
        return stack;
    }

    public static LootItemConditionalFunction.Builder<?> builder() {
        return LootItemConditionalFunction.simpleBuilder(DoubleDrops::new);
    }

    public LootItemFunctionType<DoubleDrops> getType() {
        return (LootItemFunctionType)AetherLootFunctions.DOUBLE_DROPS.get();
    }
}

