/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.item.accessories.gloves;

import com.aetherteam.aether.AetherConfig;
import com.aetherteam.aether.inventory.AetherAccessorySlots;
import com.aetherteam.aether.item.accessories.AccessoryItem;
import com.aetherteam.aether.item.accessories.SlotIdentifierHolder;
import io.wispforest.accessories.api.attributes.AccessoryAttributeBuilder;
import io.wispforest.accessories.api.slot.SlotReference;
import io.wispforest.accessories.api.slot.SlotTypeReference;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;

public class GlovesItem
extends AccessoryItem
implements SlotIdentifierHolder {
    public static final ResourceLocation BASE_PUNCH_DAMAGE_ID = ResourceLocation.fromNamespaceAndPath((String)"aether", (String)"base_punch_damage");
    protected final Holder<ArmorMaterial> material;
    protected final double damage;
    protected ResourceLocation GLOVES_TEXTURE;

    public GlovesItem(Holder<ArmorMaterial> material, double punchDamage, String glovesName, Holder<SoundEvent> glovesSound, Item.Properties properties) {
        this(material, punchDamage, ResourceLocation.fromNamespaceAndPath((String)"aether", (String)glovesName), glovesSound, properties);
    }

    public GlovesItem(Holder<ArmorMaterial> material, double punchDamage, ResourceLocation glovesName, Holder<SoundEvent> glovesSound, Item.Properties properties) {
        super(glovesSound, properties);
        this.material = material;
        this.damage = punchDamage;
        this.setRenderTexture(glovesName.getNamespace(), glovesName.getPath());
    }

    public void getDynamicModifiers(ItemStack stack, SlotReference reference, AccessoryAttributeBuilder builder) {
        builder.addStackable(Attributes.ATTACK_DAMAGE, new AttributeModifier(BASE_PUNCH_DAMAGE_ID, this.damage, AttributeModifier.Operation.ADD_VALUE));
    }

    public int getEnchantmentValue() {
        return ((ArmorMaterial)this.material.value()).enchantmentValue();
    }

    public boolean isValidRepairItem(ItemStack item, ItemStack material) {
        return ((Ingredient)((ArmorMaterial)this.material.value()).repairIngredient().get()).test(material) || super.isValidRepairItem(item, material);
    }

    public Holder<ArmorMaterial> getMaterial() {
        return this.material;
    }

    public double getDamage() {
        return this.damage;
    }

    public void setRenderTexture(String modId, String registryName) {
        this.GLOVES_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)modId, (String)("textures/models/accessory/gloves/" + registryName + "_accessory.png"));
    }

    public ResourceLocation getGlovesTexture() {
        return this.GLOVES_TEXTURE;
    }

    @Override
    public SlotTypeReference getIdentifier() {
        return GlovesItem.getStaticIdentifier();
    }

    public static SlotTypeReference getStaticIdentifier() {
        return (Boolean)AetherConfig.COMMON.use_default_accessories_menu.get() != false ? new SlotTypeReference("hand") : AetherAccessorySlots.getGlovesSlotType();
    }
}

