/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.item.accessories.cape;

import com.aetherteam.aether.AetherConfig;
import com.aetherteam.aether.client.AetherSoundEvents;
import com.aetherteam.aether.inventory.AetherAccessorySlots;
import com.aetherteam.aether.item.accessories.AccessoryItem;
import com.aetherteam.aether.item.accessories.SlotIdentifierHolder;
import io.wispforest.accessories.api.slot.SlotTypeReference;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.item.Item;

public class CapeItem
extends AccessoryItem
implements SlotIdentifierHolder {
    protected ResourceLocation CAPE_LOCATION;

    public CapeItem(String capeLocation, Item.Properties properties) {
        this(ResourceLocation.fromNamespaceAndPath((String)"aether", (String)capeLocation), properties);
    }

    public CapeItem(ResourceLocation capeLocation, Item.Properties properties) {
        super((Holder<SoundEvent>)AetherSoundEvents.ITEM_ACCESSORY_EQUIP_CAPE, properties);
        this.setRenderTexture(capeLocation.getNamespace(), capeLocation.getPath());
    }

    public void setRenderTexture(String modId, String registryName) {
        this.CAPE_LOCATION = ResourceLocation.fromNamespaceAndPath((String)modId, (String)("textures/models/accessory/capes/" + registryName + "_accessory.png"));
    }

    public ResourceLocation getCapeTexture() {
        return this.CAPE_LOCATION;
    }

    @Override
    public SlotTypeReference getIdentifier() {
        return CapeItem.getStaticIdentifier();
    }

    public static SlotTypeReference getStaticIdentifier() {
        return (Boolean)AetherConfig.COMMON.use_default_accessories_menu.get() != false ? new SlotTypeReference("cape") : AetherAccessorySlots.getCapeSlotType();
    }
}

