/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.entity.ai.goal;

import com.aetherteam.aether.block.AetherBlocks;
import com.aetherteam.aether.mixin.mixins.common.accessor.BeeAccessor;
import net.minecraft.core.BlockPos;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.animal.Bee;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

public class BeeGrowBerryBushGoal
extends Goal {
    private final Bee bee;

    public BeeGrowBerryBushGoal(Bee bee) {
        this.bee = bee;
    }

    public boolean canUse() {
        return this.canBeeUse() && !this.bee.isAngry();
    }

    public boolean canContinueToUse() {
        return this.canBeeContinueToUse() && !this.bee.isAngry();
    }

    public boolean canBeeUse() {
        BeeAccessor beeAccessor = (BeeAccessor)this.bee;
        if (beeAccessor.callGetCropsGrownSincePollination() >= 10) {
            return false;
        }
        if (this.bee.getRandom().nextFloat() < 0.3f) {
            return false;
        }
        return this.bee.hasNectar() && beeAccessor.callIsHiveValid();
    }

    public boolean canBeeContinueToUse() {
        return this.canBeeUse();
    }

    public void tick() {
        BeeAccessor beeAccessor = (BeeAccessor)this.bee;
        if (this.bee.getRandom().nextInt(this.adjustedTickDelay(30)) == 0) {
            for (int i = 1; i <= 2; ++i) {
                BlockPos blockPos = this.bee.blockPosition().below(i);
                BlockState blockState = this.bee.level().getBlockState(blockPos);
                boolean isStem = false;
                if (!blockState.is(BlockTags.BEE_GROWABLES)) continue;
                if (blockState.is((Block)AetherBlocks.BERRY_BUSH_STEM.get())) {
                    isStem = true;
                }
                if (!isStem) continue;
                this.bee.level().levelEvent(2005, blockPos, 0);
                this.bee.level().setBlockAndUpdate(blockPos, ((Block)AetherBlocks.BERRY_BUSH.get()).defaultBlockState());
                beeAccessor.callIncrementNumCropsGrownSincePollination();
            }
        }
    }
}

