/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.data.resources.registries;

import com.aetherteam.aether.world.processor.BossRoomProcessor;
import com.aetherteam.aether.world.processor.DoubleDropsProcessor;
import com.aetherteam.aether.world.processor.NoReplaceProcessor;
import com.aetherteam.aether.world.processor.SurfaceRuleProcessor;
import com.aetherteam.aether.world.processor.VerticalGradientProcessor;
import com.aetherteam.aether.world.structurepiece.bronzedungeon.BronzeDungeonPiece;
import com.aetherteam.aether.world.structurepiece.golddungeon.GoldDungeonPiece;
import com.aetherteam.aether.world.structurepiece.silverdungeon.SilverDungeonPiece;
import java.util.List;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.levelgen.structure.templatesystem.AxisAlignedLinearPosTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorList;

public class AetherStructureProcessorLists {
    public static final ResourceKey<StructureProcessorList> BRONZE_ROOM = AetherStructureProcessorLists.createKey("bronze_room");
    public static final ResourceKey<StructureProcessorList> BRONZE_TUNNEL = AetherStructureProcessorLists.createKey("bronze_tunnel");
    public static final ResourceKey<StructureProcessorList> BRONZE_BOSS_ROOM = AetherStructureProcessorLists.createKey("bronze_boss_room");
    public static final ResourceKey<StructureProcessorList> SILVER_ROOM = AetherStructureProcessorLists.createKey("silver_room");
    public static final ResourceKey<StructureProcessorList> SILVER_FLOOR = AetherStructureProcessorLists.createKey("silver_floor");
    public static final ResourceKey<StructureProcessorList> SILVER_BOSS_ROOM = AetherStructureProcessorLists.createKey("silver_boss_room");
    public static final ResourceKey<StructureProcessorList> GOLD_ISLAND = AetherStructureProcessorLists.createKey("gold_island");
    public static final ResourceKey<StructureProcessorList> GOLD_TUNNEL = AetherStructureProcessorLists.createKey("gold_tunnel");
    public static final ResourceKey<StructureProcessorList> GOLD_BOSS_ROOM = AetherStructureProcessorLists.createKey("gold_boss_room");
    private static final AxisAlignedLinearPosTest ON_FLOOR = new AxisAlignedLinearPosTest(1.0f, 0.0f, 0, 1, Direction.Axis.Y);

    private static ResourceKey<StructureProcessorList> createKey(String name) {
        return ResourceKey.create((ResourceKey)Registries.PROCESSOR_LIST, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"aether", (String)name));
    }

    public static void bootstrap(BootstrapContext<StructureProcessorList> context) {
        AetherStructureProcessorLists.register(context, BRONZE_ROOM, List.of(BronzeDungeonPiece.BRONZE_DUNGEON_STONE, BronzeDungeonPiece.TRAPPED_CARVED_STONE, BronzeDungeonPiece.AVOID_DUNGEONS, DoubleDropsProcessor.INSTANCE));
        AetherStructureProcessorLists.register(context, BRONZE_TUNNEL, List.of(BronzeDungeonPiece.AVOID_DUNGEONS, BronzeDungeonPiece.BRONZE_DUNGEON_STONE, DoubleDropsProcessor.INSTANCE));
        AetherStructureProcessorLists.register(context, BRONZE_BOSS_ROOM, List.of(BronzeDungeonPiece.LOCKED_SENTRY_STONE, BossRoomProcessor.INSTANCE));
        AetherStructureProcessorLists.register(context, SILVER_ROOM, List.of(SilverDungeonPiece.LOCKED_ANGELIC_STONE, DoubleDropsProcessor.INSTANCE));
        AetherStructureProcessorLists.register(context, SILVER_FLOOR, List.of(SilverDungeonPiece.LOCKED_ANGELIC_STONE, SilverDungeonPiece.TRAPPED_ANGELIC_STONE, DoubleDropsProcessor.INSTANCE));
        AetherStructureProcessorLists.register(context, SILVER_BOSS_ROOM, List.of(DoubleDropsProcessor.INSTANCE, BossRoomProcessor.INSTANCE));
        AetherStructureProcessorLists.register(context, GOLD_ISLAND, List.of(SurfaceRuleProcessor.INSTANCE, VerticalGradientProcessor.INSTANCE, DoubleDropsProcessor.INSTANCE));
        AetherStructureProcessorLists.register(context, GOLD_TUNNEL, List.of(GoldDungeonPiece.MOSSY_HOLYSTONE, NoReplaceProcessor.AIR, DoubleDropsProcessor.INSTANCE));
        AetherStructureProcessorLists.register(context, GOLD_BOSS_ROOM, List.of(GoldDungeonPiece.LOCKED_HELLFIRE_STONE, BossRoomProcessor.INSTANCE));
    }

    private static void register(BootstrapContext<StructureProcessorList> context, ResourceKey<StructureProcessorList> key, List<StructureProcessor> processors) {
        context.register(key, (Object)new StructureProcessorList(processors));
    }
}

