/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.client.gui.screen.inventory;

import com.aetherteam.aether.client.gui.component.inventory.SunAltarSlider;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;

public class SunAltarScreen
extends Screen {
    private static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"aether", (String)"textures/gui/menu/sun_altar.png");
    private final int timeScale;

    public SunAltarScreen(Component title, int timeScale) {
        super(title);
        this.timeScale = timeScale;
    }

    public void init() {
        super.init();
        if (this.getMinecraft().level != null) {
            double sliderValue = (double)(this.getMinecraft().level.getDayTime() % (long)this.timeScale) / (double)this.timeScale;
            this.addRenderableWidget((GuiEventListener)new SunAltarSlider(this.width / 2 - 75, this.height / 2, 150, 20, (Component)Component.translatable((String)"gui.aether.sun_altar.time"), sliderValue, this.timeScale));
        }
    }

    public void renderBackground(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        this.renderTransparentBackground(guiGraphics);
        int xSize = 176;
        int ySize = 79;
        int x = (this.width - xSize) / 2;
        int y = (this.height - ySize) / 2;
        guiGraphics.blit(TEXTURE, x, y, 0, 0, xSize, ySize);
        FormattedCharSequence sequence = this.title.getVisualOrderText();
        guiGraphics.drawString(this.font, this.title, (int)((float)(this.width - this.font.width(sequence)) / 2.0f), y + 20, 0x404040, false);
    }

    public boolean isPauseScreen() {
        return false;
    }
}

