/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.client.event.listeners;

import com.aetherteam.aether.client.event.hooks.GuiHooks;
import com.aetherteam.aether.client.gui.component.inventory.AccessoryButton;
import com.aetherteam.aether.client.gui.screen.inventory.AetherAccessoriesScreen;
import java.util.UUID;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.LerpingBossEvent;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.layouts.GridLayout;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.util.Tuple;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModList;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.client.event.CustomizeGuiOverlayEvent;
import net.neoforged.neoforge.client.event.InputEvent;
import net.neoforged.neoforge.client.event.ScreenEvent;

public class GuiListener {
    public static void listen(IEventBus bus) {
        bus.addListener(GuiListener::onGuiInitialize);
        bus.addListener(GuiListener::onGuiDraw);
        bus.addListener(GuiListener::onClientTick);
        bus.addListener(GuiListener::onKeyPress);
        bus.addListener(GuiListener::onRenderBossBar);
    }

    public static void onGuiInitialize(ScreenEvent.Init.Post event) {
        GridLayout layout;
        Tuple<Integer, Integer> offsets;
        Screen screen = event.getScreen();
        AccessoryButton inventoryAccessoryButton = GuiHooks.setupAccessoryButton(screen, offsets = AetherAccessoriesScreen.getButtonOffset(screen));
        if (inventoryAccessoryButton != null && GuiHooks.isAccessoryButtonEnabled()) {
            event.addListener((GuiEventListener)inventoryAccessoryButton);
        }
        if ((layout = GuiHooks.setupPerksButtons(screen)) != null && !GuiHooks.isAccessoryButtonEnabled()) {
            layout.visitWidgets(arg_0 -> ((ScreenEvent.Init.Post)event).addListener(arg_0));
        }
    }

    public static void onGuiDraw(ScreenEvent.Render.Post event) {
        Screen screen = event.getScreen();
        GuiGraphics guiGraphics = event.getGuiGraphics();
        if (!ModList.get().isLoaded("tipsmod")) {
            GuiHooks.drawTrivia(screen, guiGraphics);
        }
        GuiHooks.drawAetherTravelMessage(screen, guiGraphics);
    }

    public static void onClientTick(ClientTickEvent.Post event) {
        GuiHooks.handlePatreonRefreshRebound();
    }

    public static void onKeyPress(InputEvent.Key event) {
        GuiHooks.openAccessoryMenu();
        GuiHooks.closeContainerMenu(event.getKey(), event.getAction());
    }

    public static void onRenderBossBar(CustomizeGuiOverlayEvent.BossEventProgress event) {
        GuiGraphics guiGraphics = event.getGuiGraphics();
        LerpingBossEvent bossEvent = event.getBossEvent();
        UUID bossUUID = bossEvent.getId();
        if (GuiHooks.isAetherBossBar(bossUUID)) {
            GuiHooks.drawBossHealthBar(guiGraphics, event.getX(), event.getY(), bossEvent);
            event.setIncrement(event.getIncrement() + 13);
        }
    }
}

