/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.world;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Position;
import net.minecraft.core.SectionPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.server.level.ColumnPos;
import net.minecraft.server.level.FullChunkStatus;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.TicketType;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import net.minecraft.world.level.portal.DimensionTransition;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.apache.commons.lang3.mutable.MutableInt;
import org.jetbrains.annotations.Nullable;
import twilightforest.TwilightForestMod;
import twilightforest.block.TFPortalBlock;
import twilightforest.config.TFConfig;
import twilightforest.data.tags.BlockTagGenerator;
import twilightforest.init.TFBlocks;
import twilightforest.init.TFDimension;
import twilightforest.item.MagicMapItem;
import twilightforest.util.Restriction;
import twilightforest.util.landmarks.LandmarkUtil;
import twilightforest.util.landmarks.LegacyLandmarkPlacements;
import twilightforest.world.TeleporterCache;

public class TFTeleporter {
    public static DimensionTransition createTransition(Entity entity, ServerLevel dest, BlockPos pos, boolean forcedEntry) {
        TeleporterCache cache = TeleporterCache.get(dest);
        DimensionTransition transition = TFTeleporter.placeInExistingPortal(cache, dest, entity, pos);
        if (transition == null) {
            TwilightForestMod.LOGGER.debug("Did not find existing portal, making a new one.");
            transition = TFTeleporter.createPosition(dest, entity, pos, cache, forcedEntry);
        }
        if (transition != null) {
            return transition;
        }
        return new DimensionTransition(dest, Vec3.atCenterOf((Vec3i)pos.atY(dest.getSeaLevel())), Vec3.ZERO, entity.getYRot(), entity.getXRot(), DimensionTransition.PLACE_PORTAL_TICKET);
    }

    @Nullable
    protected static DimensionTransition createPosition(ServerLevel dest, Entity entity, BlockPos destPos, TeleporterCache cache, boolean locked) {
        DimensionTransition info = TFTeleporter.moveToSafeCoords(dest, entity, destPos);
        TFTeleporter.makePortal(cache, entity, dest, info.pos(), locked);
        info = TFTeleporter.placeInExistingPortal(cache, dest, entity, BlockPos.containing((Position)info.pos()));
        return info;
    }

    @Nullable
    protected static DimensionTransition placeInExistingPortal(TeleporterCache cache, ServerLevel destDim, Entity entity, BlockPos pos) {
        BlockPos[] portalBorder;
        BlockPos blockpos;
        boolean flag = true;
        ColumnPos columnPos = new ColumnPos(entity.blockPosition().getX(), entity.blockPosition().getZ());
        PortalPosition portalPosition = cache.getPortalPosition(destDim.dimension().location(), columnPos);
        if (portalPosition != null) {
            blockpos = portalPosition.pos;
            portalPosition.lastUpdateTime = destDim.getGameTime();
            flag = false;
            TwilightForestMod.LOGGER.debug("Using cache, validating. {}", (Object)blockpos);
            if (blockpos == null || !destDim.getBlockState(blockpos).is(TFBlocks.TWILIGHT_PORTAL)) {
                TwilightForestMod.LOGGER.debug("Portal Invalid, recreating.");
                blockpos = null;
                cache.removeInvalidPos(destDim.dimension().location(), columnPos);
            }
        } else {
            blockpos = TFTeleporter.getPortalPosition(destDim, pos);
        }
        if (blockpos == null) {
            return null;
        }
        if (flag) {
            TwilightForestMod.LOGGER.debug("Caching Src Portal Blocks to {}", (Object)blockpos);
            HashMap<BlockPos, Boolean> portalBlocks = new HashMap<BlockPos, Boolean>();
            portalBlocks.put(entity.blockPosition(), true);
            TFPortalBlock.recursivelyValidatePortal(entity.level(), entity.blockPosition(), portalBlocks, new MutableInt(0), entity.level().getBlockState(entity.blockPosition()));
            BlockPos finalBlockpos = blockpos;
            portalBlocks.forEach((blockPos, b) -> {
                if (b.booleanValue()) {
                    TwilightForestMod.LOGGER.debug("Caching {}", blockPos);
                    cache.addBlockToCache(destDim.dimension().location(), new ColumnPos(blockPos.getX(), blockPos.getZ()), new PortalPosition(finalBlockpos, destDim.getGameTime()));
                }
            });
            destDim.getChunkSource().addRegionTicket(TicketType.PORTAL, new ChunkPos(blockpos), 3, (Object)new BlockPos(columnPos.x(), blockpos.getY(), columnPos.z()));
        }
        BlockPos borderPos = (portalBorder = TFTeleporter.getBoundaryPositions(destDim, blockpos).toArray(new BlockPos[0])).length > 0 ? portalBorder[destDim.getRandom().nextInt(portalBorder.length)] : blockpos;
        double portalX = (double)borderPos.getX() + 0.5;
        double portalY = (double)borderPos.getY() + 1.0;
        double portalZ = (double)borderPos.getZ() + 0.5;
        return TFTeleporter.makePortalInfo(destDim, entity, portalX, portalY, portalZ);
    }

    @Nullable
    private static BlockPos getPortalPosition(ServerLevel destDim, BlockPos pos) {
        int i = 200;
        double d0 = Double.MAX_VALUE;
        BlockPos result = null;
        for (int i1 = -i; i1 <= i; ++i1) {
            for (int j1 = -i; j1 <= i; ++j1) {
                if (!destDim.getWorldBorder().isWithinBounds(pos.offset(i1, 0, j1))) continue;
                ChunkPos chunkPos = new ChunkPos(pos.offset(i1, 0, j1));
                LevelChunk chunk = destDim.getChunkSource().getChunkNow(chunkPos.x, chunkPos.z);
                if (chunk == null || chunk.getFullStatus() == FullChunkStatus.INACCESSIBLE) continue;
                BlockPos blockpos1 = pos.offset(i1, TFTeleporter.getScanHeight(destDim, pos) - pos.getY(), j1);
                while (blockpos1.getY() >= destDim.getMinBuildHeight()) {
                    BlockPos blockpos2 = blockpos1.below();
                    if (!(d0 >= 0.0 && blockpos1.distSqr((Vec3i)pos) >= d0 || !TFTeleporter.isPortal(chunk.getBlockState(blockpos1)))) {
                        blockpos2 = blockpos1.below();
                        while (TFTeleporter.isPortal(chunk.getBlockState(blockpos2))) {
                            blockpos1 = blockpos2;
                            blockpos2 = blockpos2.below();
                        }
                        float d1 = (float)blockpos1.distSqr((Vec3i)pos);
                        if (d0 < 0.0 || (double)d1 < d0) {
                            d0 = d1;
                            result = blockpos1;
                            i = Mth.ceil((float)Mth.sqrt((float)d1));
                        }
                    }
                    blockpos1 = blockpos2;
                }
            }
        }
        return result;
    }

    private static int getScanHeight(ServerLevel world, BlockPos pos) {
        return TFTeleporter.getScanHeight(world, pos.getX(), pos.getZ());
    }

    private static int getScanHeight(ServerLevel world, int x, int z) {
        int worldHeight = world.getMaxBuildHeight() - 1;
        int chunkHeight = world.getChunk(x >> 4, z >> 4).getHighestSectionPosition() + 15;
        return Math.min(worldHeight, chunkHeight);
    }

    private static boolean isPortal(BlockState state) {
        return state.is(TFBlocks.TWILIGHT_PORTAL);
    }

    private static Set<BlockPos> getBoundaryPositions(ServerLevel world, BlockPos start) {
        HashSet<BlockPos> result = new HashSet<BlockPos>();
        HashSet<BlockPos> checked = new HashSet<BlockPos>();
        checked.add(start);
        TFTeleporter.checkAdjacent(world, start, checked, result);
        return result;
    }

    private static void checkAdjacent(ServerLevel world, BlockPos pos, Set<BlockPos> checked, Set<BlockPos> result) {
        for (Direction facing : Direction.Plane.HORIZONTAL) {
            BlockPos offset = pos.relative(facing);
            if (!checked.add(offset)) continue;
            BlockState checkState = world.getBlockState(offset);
            if (TFTeleporter.isPortal(checkState)) {
                TFTeleporter.checkAdjacent(world, offset, checked, result);
                continue;
            }
            if (!Block.isFaceFull((VoxelShape)checkState.getCollisionShape((BlockGetter)world, offset), (Direction)Direction.UP) || !world.getBlockState(offset.above()).getCollisionShape((BlockGetter)world, offset.above()).isEmpty()) continue;
            result.add(offset);
        }
    }

    protected static boolean isPortalAt(ServerLevel world, BlockPos pos) {
        return TFTeleporter.isPortal(world.getBlockState(pos));
    }

    protected static double getHorizontalScale(ServerLevel destination) {
        ServerLevel tfDim = destination.getServer().getLevel(TFDimension.DIMENSION_KEY);
        double scale = tfDim == null ? 0.125 : tfDim.dimensionType().coordinateScale();
        return destination.dimension().equals(TFDimension.DIMENSION_KEY) ? 1.0 / scale : scale;
    }

    protected static DimensionTransition moveToSafeCoords(ServerLevel level, Entity entity, BlockPos pos) {
        boolean checkProgression = LandmarkUtil.isProgressionEnforced((Level)level);
        if (TFTeleporter.isSafeAround((Level)level, pos, entity, checkProgression)) {
            TwilightForestMod.LOGGER.debug("Portal destination looks safe!");
            return TFTeleporter.makePortalInfo(level, entity, Vec3.atCenterOf((Vec3i)pos));
        }
        TwilightForestMod.LOGGER.debug("Portal destination looks unsafe, rerouting!");
        BlockPos safeCoords = TFTeleporter.findSafeCoords(level, 200, pos, entity, checkProgression);
        if (safeCoords != null) {
            TwilightForestMod.LOGGER.debug("Safely rerouted!");
            return TFTeleporter.makePortalInfo(level, entity, safeCoords.getX(), entity.getY(), safeCoords.getZ());
        }
        TwilightForestMod.LOGGER.info("Did not find a safe portal spot first try, trying again with longer range.");
        safeCoords = TFTeleporter.findSafeCoords(level, 400, pos, entity, checkProgression);
        if (safeCoords != null) {
            TwilightForestMod.LOGGER.info("Safely rerouted to long range portal. Return trip not guaranteed.");
            return TFTeleporter.makePortalInfo(level, entity, safeCoords.getX(), entity.getY(), safeCoords.getZ());
        }
        TwilightForestMod.LOGGER.info("Did not find a safe portal spot second try, trying to move slightly towards the center between key biomes.");
        safeCoords = TFTeleporter.findSafeCoords(level, 400, TFTeleporter.moveTowardsCenter(pos, 0.5f), entity, checkProgression);
        if (safeCoords != null) {
            TwilightForestMod.LOGGER.info("Safely rerouted to slightly centered portal. Return trip not guaranteed.");
            return TFTeleporter.makePortalInfo(level, entity, safeCoords.getX(), entity.getY(), safeCoords.getZ());
        }
        TwilightForestMod.LOGGER.info("Did not find a safe portal spot third try, trying to move further towards the center between key biomes.");
        safeCoords = TFTeleporter.findSafeCoords(level, 400, TFTeleporter.moveTowardsCenter(pos, 0.9f), entity, checkProgression);
        if (safeCoords != null) {
            TwilightForestMod.LOGGER.info("Safely rerouted to very centered portal. Return trip not guaranteed.");
            return TFTeleporter.makePortalInfo(level, entity, safeCoords.getX(), entity.getY(), safeCoords.getZ());
        }
        TwilightForestMod.LOGGER.warn("Still did not find a safe portal spot.");
        return TFTeleporter.makePortalInfo(level, entity, Vec3.atCenterOf((Vec3i)pos));
    }

    private static BlockPos moveTowardsCenter(BlockPos pos, float lerp) {
        ColumnPos centerPos = MagicMapItem.getMagicMapCenter(pos.getX(), pos.getZ());
        float vx = centerPos.x() - pos.getX();
        float vz = centerPos.z() - pos.getZ();
        float nx = (float)pos.getX() + vx * lerp;
        float nz = (float)pos.getZ() + vz * lerp;
        return BlockPos.containing((double)nx, (double)pos.getY(), (double)nz);
    }

    public static boolean isSafeAround(Level world, BlockPos pos, Entity entity, boolean checkProgression) {
        if (!TFTeleporter.isSafe(world, pos, entity, checkProgression)) {
            return false;
        }
        for (Direction facing : Direction.Plane.HORIZONTAL) {
            if (TFTeleporter.isSafe(world, pos.relative(facing, 16), entity, checkProgression)) continue;
            return false;
        }
        return true;
    }

    private static boolean isSafe(Level world, BlockPos pos, Entity entity, boolean checkProgression) {
        return !world.dimension().equals(TFDimension.DIMENSION_KEY) || TFTeleporter.checkPos(world, pos) && (!checkProgression || TFTeleporter.checkBiome(world, pos, entity)) && TFTeleporter.checkStructure(world, pos);
    }

    private static boolean checkPos(Level world, BlockPos pos) {
        return world.getWorldBorder().isWithinBounds(pos);
    }

    private static boolean checkStructure(Level world, BlockPos pos) {
        boolean outsideLandmarkRange;
        boolean bl = outsideLandmarkRange = !LegacyLandmarkPlacements.blockNearLandmarkCenter(pos.getX(), pos.getZ(), 5);
        if (!outsideLandmarkRange) {
            return false;
        }
        Optional<StructureStart> possibleNearLandmark = LandmarkUtil.locateNearestLandmarkStart((LevelAccessor)world, SectionPos.blockToSectionCoord((int)pos.getX()), SectionPos.blockToSectionCoord((int)pos.getZ()));
        return possibleNearLandmark.isEmpty() || possibleNearLandmark.get().getBoundingBox().isInside((Vec3i)pos);
    }

    private static boolean checkBiome(Level world, BlockPos pos, Entity entity) {
        return Restriction.isBiomeSafeFor((Biome)world.getBiome(pos).value(), entity);
    }

    @Nullable
    private static BlockPos findSafeCoords(ServerLevel world, int range, BlockPos pos, Entity entity, boolean checkProgression) {
        int attempts = range / 8;
        for (int x = 0; x < attempts; ++x) {
            for (int z = 0; z < attempts; ++z) {
                BlockPos dPos = new BlockPos(pos.getX() + x * attempts - range / 2, 100, pos.getZ() + z * attempts - range / 2);
                if (!TFTeleporter.isSafeAround((Level)world, dPos, entity, checkProgression)) continue;
                return dPos;
            }
        }
        return null;
    }

    protected static void makePortal(TeleporterCache cache, Entity entity, ServerLevel world, Vec3 pos, boolean locked) {
        ServerLevel serverLevel;
        Level level = entity.level();
        ServerLevel src = level instanceof ServerLevel ? (serverLevel = (ServerLevel)level) : null;
        TFTeleporter.loadSurroundingArea(world, pos);
        BlockPos spot = TFTeleporter.findPortalCoords(world, pos, blockPos -> TFTeleporter.isPortalAt(world, blockPos));
        String name = entity.getName().getString();
        if (spot != null) {
            TwilightForestMod.LOGGER.debug("Found existing portal for {} at {}", (Object)name, (Object)spot);
            TFTeleporter.cacheNewPortalCoords(cache, src, spot, entity.blockPosition());
            return;
        }
        spot = TFTeleporter.findPortalCoords(world, pos, blockpos -> TFTeleporter.isIdealForPortal(world, blockpos));
        if (spot != null) {
            TwilightForestMod.LOGGER.debug("Found ideal portal spot for {} at {}", (Object)name, (Object)spot);
            TFTeleporter.cacheNewPortalCoords(cache, src, TFTeleporter.makePortalAt((Level)world, spot, locked), entity.blockPosition());
            return;
        }
        TwilightForestMod.LOGGER.debug("Did not find ideal portal spot, shooting for okay one for {}", (Object)name);
        spot = TFTeleporter.findPortalCoords(world, pos, blockPos -> TFTeleporter.isOkayForPortal(world, blockPos));
        if (spot != null) {
            TwilightForestMod.LOGGER.debug("Found okay portal spot for {} at {}", (Object)name, (Object)spot);
            TFTeleporter.cacheNewPortalCoords(cache, src, TFTeleporter.makePortalAt((Level)world, spot, locked), entity.blockPosition());
            return;
        }
        TwilightForestMod.LOGGER.debug("Did not even find an okay portal spot, just making a fallback one for {}", (Object)name);
        spot = TFTeleporter.findPortalCoords(world, pos, blockpos -> TFTeleporter.isOkayForFallbackPortal(world, blockpos), true);
        if (spot != null) {
            TwilightForestMod.LOGGER.debug("Found fallback portal spot for {} at {}", (Object)name, (Object)spot);
            TFTeleporter.cacheNewPortalCoords(cache, src, TFTeleporter.makePortalAt((Level)world, spot, locked), entity.blockPosition());
            return;
        }
        TwilightForestMod.LOGGER.debug("Did not even find a fallback portal spot, just making a random one for {}", (Object)name);
        double yFactor = TFTeleporter.getYFactor(world);
        TFTeleporter.cacheNewPortalCoords(cache, src, TFTeleporter.makePortalAt((Level)world, BlockPos.containing((double)(entity.getX() * TFTeleporter.getHorizontalScale(world)), (double)(entity.getY() * yFactor + 2.0), (double)(entity.getZ() * TFTeleporter.getHorizontalScale(world))), locked), entity.blockPosition());
    }

    protected static void loadSurroundingArea(ServerLevel world, Vec3 pos) {
        int x = Mth.floor((double)pos.x()) >> 4;
        int z = Mth.floor((double)pos.y()) >> 4;
        for (int dx = -2; dx <= 2; ++dx) {
            for (int dz = -2; dz <= 2; ++dz) {
                world.getChunk(x + dx, z + dz);
            }
        }
    }

    @Nullable
    protected static BlockPos findPortalCoords(ServerLevel world, Vec3 loc, Predicate<BlockPos> predicate) {
        return TFTeleporter.findPortalCoords(world, loc, predicate, false);
    }

    @Nullable
    protected static BlockPos findPortalCoords(ServerLevel world, Vec3 loc, Predicate<BlockPos> predicate, boolean makePortalInAir) {
        double yFactor = TFTeleporter.getYFactor(world);
        int entityX = Mth.floor((double)loc.x());
        int entityZ = Mth.floor((double)loc.z());
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        double spotWeight = -1.0;
        BlockPos spot = null;
        int range = 16;
        for (int rx = entityX - range; rx <= entityX + range; ++rx) {
            double xWeight = (double)rx + 0.5 - loc.x();
            for (int rz = entityZ - range; rz <= entityZ + range; ++rz) {
                double zWeight = (double)rz + 0.5 - loc.z();
                for (int ry = TFTeleporter.getScanHeight(world, rx, rz); ry >= world.getMinBuildHeight(); --ry) {
                    pos.set(rx, ry, rz);
                    if (!makePortalInAir && !world.isEmptyBlock((BlockPos)pos)) continue;
                    if (makePortalInAir) {
                        while (ry > world.getMinBuildHeight() && world.isEmptyBlock((BlockPos)pos.set(rx, ry - 1, rz)) && predicate.test((BlockPos)pos)) {
                            --ry;
                        }
                        pos.set(rx, ry, rz);
                    } else {
                        while (ry > world.getMinBuildHeight() && world.isEmptyBlock((BlockPos)pos.set(rx, ry - 1, rz))) {
                            --ry;
                        }
                    }
                    double yWeight = (double)ry + 0.5 - loc.y() * yFactor;
                    double rPosWeight = xWeight * xWeight + yWeight * yWeight + zWeight * zWeight;
                    if (!(spotWeight < 0.0) && !(rPosWeight < spotWeight) || !predicate.test((BlockPos)pos)) continue;
                    spotWeight = rPosWeight;
                    spot = pos.immutable();
                }
            }
        }
        return spot;
    }

    protected static double getYFactor(ServerLevel world) {
        return world.dimension().location().equals((Object)Level.OVERWORLD.location()) ? 2.0 : 0.5;
    }

    private static void cacheNewPortalCoords(TeleporterCache cache, @Nullable ServerLevel srcDim, BlockPos pos, BlockPos srcPos) {
        if (srcDim == null) {
            return;
        }
        BlockPos exitPos = TFTeleporter.getPortalPosition(srcDim, srcPos);
        if (exitPos == null) {
            return;
        }
        TwilightForestMod.LOGGER.debug("Caching Dest Portal Blocks to {}", (Object)exitPos);
        cache.addBlockToCache(srcDim.dimension().location(), new ColumnPos(pos.getX(), pos.getZ()), new PortalPosition(exitPos, srcDim.getGameTime()));
        cache.addBlockToCache(srcDim.dimension().location(), new ColumnPos(pos.south().getX(), pos.south().getZ()), new PortalPosition(exitPos, srcDim.getGameTime()));
        cache.addBlockToCache(srcDim.dimension().location(), new ColumnPos(pos.east().getX(), pos.east().getZ()), new PortalPosition(exitPos, srcDim.getGameTime()));
        cache.addBlockToCache(srcDim.dimension().location(), new ColumnPos(pos.south().east().getX(), pos.south().east().getZ()), new PortalPosition(exitPos, srcDim.getGameTime()));
    }

    protected static boolean isIdealForPortal(ServerLevel world, BlockPos pos) {
        for (int potentialZ = 0; potentialZ < 4; ++potentialZ) {
            for (int potentialX = 0; potentialX < 4; ++potentialX) {
                for (int potentialY = 0; potentialY < 6; ++potentialY) {
                    BlockPos tPos = pos.offset(potentialX - 1, potentialY, potentialZ - 1);
                    BlockState state = world.getBlockState(tPos);
                    if (!state.is(BlockTags.FEATURES_CANNOT_REPLACE) && (potentialY != 0 || state.is(BlockTags.DIRT)) && (potentialY < 1 || state.canBeReplaced())) continue;
                    return false;
                }
            }
        }
        return true;
    }

    protected static BlockPos makePortalAt(Level world, BlockPos pos, boolean locked) {
        BlockState grass = Blocks.GRASS_BLOCK.defaultBlockState();
        world.setBlockAndUpdate(pos.west().north(), grass);
        world.setBlockAndUpdate(pos.north(), grass);
        world.setBlockAndUpdate(pos.east().north(), grass);
        world.setBlockAndUpdate(pos.east(2).north(), grass);
        world.setBlockAndUpdate(pos.west(), grass);
        world.setBlockAndUpdate(pos.east(2), grass);
        world.setBlockAndUpdate(pos.west().south(), grass);
        world.setBlockAndUpdate(pos.east(2).south(), grass);
        world.setBlockAndUpdate(pos.west().south(2), grass);
        world.setBlockAndUpdate(pos.south(2), grass);
        world.setBlockAndUpdate(pos.east().south(2), grass);
        world.setBlockAndUpdate(pos.east(2).south(2), grass);
        BlockPos[] positions = new BlockPos[]{pos.below(), pos.east().below(), pos.south().below(), pos.east().south().below()};
        BlockState dirt = Blocks.DIRT.defaultBlockState();
        for (BlockPos blockpos : positions) {
            if (!world.getBlockState(pos).is(BlockTags.FEATURES_CANNOT_REPLACE)) continue;
            world.setBlockAndUpdate(blockpos, dirt);
        }
        BlockState portal = (BlockState)((TFPortalBlock)((Object)TFBlocks.TWILIGHT_PORTAL.get())).defaultBlockState().setValue((Property)TFPortalBlock.DISALLOW_RETURN, (Comparable)Boolean.valueOf(locked || !TFConfig.shouldReturnPortalBeUsable));
        world.setBlock(pos, portal, 2);
        world.setBlock(pos.east(), portal, 2);
        world.setBlock(pos.south(), portal, 2);
        world.setBlock(pos.east().south(), portal, 2);
        for (int dx = -1; dx <= 2; ++dx) {
            for (int dz = -1; dz <= 2; ++dz) {
                for (int dy = 1; dy <= 5; ++dy) {
                    world.removeBlock(pos.offset(dx, dy, dz), false);
                }
            }
        }
        world.setBlock(pos.west().north().above(), TFTeleporter.randNatureBlock(world.getRandom()), 2);
        world.setBlock(pos.north().above(), TFTeleporter.randNatureBlock(world.getRandom()), 2);
        world.setBlock(pos.east().north().above(), TFTeleporter.randNatureBlock(world.getRandom()), 2);
        world.setBlock(pos.east(2).north().above(), TFTeleporter.randNatureBlock(world.getRandom()), 2);
        world.setBlock(pos.west().above(), TFTeleporter.randNatureBlock(world.getRandom()), 2);
        world.setBlock(pos.east(2).above(), TFTeleporter.randNatureBlock(world.getRandom()), 2);
        world.setBlock(pos.west().south().above(), TFTeleporter.randNatureBlock(world.getRandom()), 2);
        world.setBlock(pos.east(2).south().above(), TFTeleporter.randNatureBlock(world.getRandom()), 2);
        world.setBlock(pos.west().south(2).above(), TFTeleporter.randNatureBlock(world.getRandom()), 2);
        world.setBlock(pos.south(2).above(), TFTeleporter.randNatureBlock(world.getRandom()), 2);
        world.setBlock(pos.east().south(2).above(), TFTeleporter.randNatureBlock(world.getRandom()), 2);
        world.setBlock(pos.east(2).south(2).above(), TFTeleporter.randNatureBlock(world.getRandom()), 2);
        return pos;
    }

    private static BlockState randNatureBlock(RandomSource random) {
        Optional<Block> optional = BuiltInRegistries.BLOCK.getTag(BlockTagGenerator.GENERATED_PORTAL_DECO).flatMap(tag -> tag.getRandomElement(random)).map(Holder::value);
        return optional.map(Block::defaultBlockState).orElseGet(() -> ((Block)Blocks.SHORT_GRASS).defaultBlockState());
    }

    protected static boolean isOkayForPortal(ServerLevel world, BlockPos pos) {
        for (int potentialZ = 0; potentialZ < 4; ++potentialZ) {
            for (int potentialX = 0; potentialX < 4; ++potentialX) {
                for (int potentialY = 0; potentialY < 6; ++potentialY) {
                    BlockPos tPos = pos.offset(potentialX - 1, potentialY, potentialZ - 1);
                    BlockState state = world.getBlockState(tPos);
                    if (!state.is(BlockTags.FEATURES_CANNOT_REPLACE) && (potentialY != 0 || state.isSolid() || state.liquid()) && (potentialY < 1 || state.canBeReplaced())) continue;
                    return false;
                }
            }
        }
        return true;
    }

    protected static boolean isOkayForFallbackPortal(ServerLevel world, BlockPos pos) {
        for (int potentialZ = 0; potentialZ < 4; ++potentialZ) {
            for (int potentialX = 0; potentialX < 4; ++potentialX) {
                for (int potentialY = 0; potentialY < 6; ++potentialY) {
                    BlockPos tPos = pos.offset(potentialX - 1, potentialY, potentialZ - 1);
                    BlockState state = world.getBlockState(tPos);
                    if (!state.is(BlockTags.FEATURES_CANNOT_REPLACE) && (potentialY < 1 || state.canBeReplaced())) continue;
                    return false;
                }
            }
        }
        return true;
    }

    protected static DimensionTransition makePortalInfo(ServerLevel level, Entity entity, double x, double y, double z) {
        return TFTeleporter.makePortalInfo(level, entity, new Vec3(x, y, z));
    }

    protected static DimensionTransition makePortalInfo(ServerLevel level, Entity entity, Vec3 pos) {
        return new DimensionTransition(level, pos, Vec3.ZERO, entity.getYRot(), entity.getXRot(), DimensionTransition.PLACE_PORTAL_TICKET);
    }

    static class PortalPosition {
        public final BlockPos pos;
        long lastUpdateTime;

        PortalPosition(BlockPos pos, long time) {
            this.pos = pos;
            this.lastUpdateTime = time;
        }
    }
}

