/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.loot.conditions;

import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Set;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParam;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionType;
import twilightforest.components.entity.GiantPickaxeMiningAttachment;
import twilightforest.init.TFDataAttachments;
import twilightforest.init.TFLoot;

public record GiantPickUsedCondition(LootContext.EntityTarget target) implements LootItemCondition
{
    public static final MapCodec<GiantPickUsedCondition> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)LootContext.EntityTarget.CODEC.fieldOf("entity").forGetter(o -> o.target)).apply((Applicative)instance, GiantPickUsedCondition::new));

    public LootItemConditionType getType() {
        return (LootItemConditionType)TFLoot.GIANT_PICK_USED_CONDITION.get();
    }

    public Set<LootContextParam<?>> getReferencedContextParams() {
        return ImmutableSet.of((Object)this.target.getParam());
    }

    public boolean test(LootContext context) {
        Object object = context.getParamOrNull(this.target.getParam());
        if (object instanceof Player) {
            Player player = (Player)object;
            GiantPickaxeMiningAttachment attachment = (GiantPickaxeMiningAttachment)player.getData(TFDataAttachments.GIANT_PICKAXE_MINING);
            return player.level().getGameTime() == attachment.getMining() && attachment.canMakeGiantBlock();
        }
        return false;
    }

    public static LootItemCondition.Builder builder(LootContext.EntityTarget target) {
        return () -> new GiantPickUsedCondition(target);
    }
}

