/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.entity.projectile;

import java.util.List;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import twilightforest.entity.projectile.TFArrow;
import twilightforest.init.TFEntities;

public class SeekerArrow
extends TFArrow {
    private static final EntityDataAccessor<Integer> TARGET = SynchedEntityData.defineId(SeekerArrow.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final double seekDistance = 5.0;
    private static final double seekFactor = 0.8;
    private static final double seekAngle = 0.5235987755982988;
    private static final double seekThreshold = 0.5;

    public SeekerArrow(EntityType<? extends SeekerArrow> type, Level world) {
        super(type, world);
        this.setBaseDamage(1.0);
    }

    public SeekerArrow(Level world, LivingEntity shooter, ItemStack stack, ItemStack weapon) {
        super((EntityType<? extends TFArrow>)((EntityType)TFEntities.SEEKER_ARROW.get()), world, shooter, stack, weapon);
        this.setBaseDamage(1.0);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(TARGET, (Object)-1);
    }

    public void tick() {
        if (this.isThisArrowFlying()) {
            Entity target;
            if (!this.level().isClientSide()) {
                this.updateTarget();
            }
            if (this.level().isClientSide() && !this.inGround) {
                for (int i = 0; i < 4; ++i) {
                    this.level().addParticle((ParticleOptions)ParticleTypes.WITCH, this.getX() + this.getDeltaMovement().x() * (double)i / 4.0, this.getY() + this.getDeltaMovement().y() * (double)i / 4.0, this.getZ() + this.getDeltaMovement().z() * (double)i / 4.0, -this.getDeltaMovement().x(), -this.getDeltaMovement().y() + 0.2, -this.getDeltaMovement().z());
                }
            }
            if ((target = this.getTarget()) != null) {
                Vec3 targetVec = this.getVectorToTarget(target).scale(0.8);
                Vec3 courseVec = this.getMotionVec();
                double courseLen = courseVec.length();
                double targetLen = targetVec.length();
                double totalLen = Math.sqrt(courseLen * courseLen + targetLen * targetLen);
                double dotProduct = courseVec.dot(targetVec) / (courseLen * targetLen);
                if (dotProduct > 0.5) {
                    Vec3 newMotion = courseVec.scale(courseLen / totalLen).add(targetVec.scale(courseLen / totalLen));
                    this.setDeltaMovement(newMotion.add(0.0, (double)0.045f, 0.0));
                } else if (!this.level().isClientSide()) {
                    this.setTarget(null);
                }
            }
        }
        super.tick();
    }

    private void updateTarget() {
        Entity target = this.getTarget();
        if (target != null && !target.isAlive()) {
            target = null;
            this.setTarget(null);
        }
        if (target == null) {
            AABB positionBB;
            AABB targetBB = positionBB = new AABB(this.getX(), this.getY(), this.getZ(), this.getX(), this.getY(), this.getZ());
            Vec3 courseVec = this.getMotionVec().scale(5.0).yRot(0.5235988f);
            targetBB = targetBB.minmax(positionBB.move(courseVec));
            courseVec = this.getMotionVec().scale(5.0).yRot(-0.5235988f);
            targetBB = targetBB.minmax(positionBB.move(courseVec));
            targetBB = targetBB.inflate(0.0, 2.5, 0.0);
            double closestDot = -1.0;
            LivingEntity closestTarget = null;
            List entityList = this.level().getEntitiesOfClass(LivingEntity.class, targetBB);
            List<LivingEntity> monsters = entityList.stream().filter(l -> l instanceof Monster).toList();
            if (!monsters.isEmpty()) {
                for (LivingEntity monster : monsters) {
                    if (((Monster)monster).getTarget() != this.getOwner()) continue;
                    this.setTarget((Entity)monster);
                    return;
                }
                for (LivingEntity monster : monsters) {
                    if (monster instanceof NeutralMob || !monster.hasLineOfSight((Entity)this)) continue;
                    this.setTarget((Entity)monster);
                    return;
                }
            }
            for (LivingEntity living : entityList) {
                Vec3 targetVec;
                Vec3 motionVec;
                double dot;
                TamableAnimal animal;
                if (!living.hasLineOfSight((Entity)this) || living == this.getOwner() || this.getOwner() != null && living instanceof TamableAnimal && (animal = (TamableAnimal)living).getOwner() == this.getOwner() || !((dot = (motionVec = this.getMotionVec().normalize()).dot(targetVec = this.getVectorToTarget((Entity)living).normalize())) > Math.max(closestDot, 0.5))) continue;
                closestDot = dot;
                closestTarget = living;
            }
            if (closestTarget != null) {
                this.setTarget((Entity)closestTarget);
            }
        }
    }

    private Vec3 getMotionVec() {
        return new Vec3(this.getDeltaMovement().x(), this.getDeltaMovement().y(), this.getDeltaMovement().z());
    }

    private Vec3 getVectorToTarget(Entity target) {
        return new Vec3(target.getX() - this.getX(), target.getY() + (double)target.getEyeHeight() - this.getY(), target.getZ() - this.getZ());
    }

    @Nullable
    private Entity getTarget() {
        return this.level().getEntity(((Integer)this.getEntityData().get(TARGET)).intValue());
    }

    private void setTarget(@Nullable Entity e) {
        this.getEntityData().set(TARGET, (Object)(e == null ? -1 : e.getId()));
    }

    private boolean isThisArrowFlying() {
        return !this.inGround && this.getDeltaMovement().lengthSqr() > 1.0;
    }

    protected void onHitEntity(EntityHitResult result) {
        this.setCritArrow(false);
        super.onHitEntity(result);
    }
}

