/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.block;

import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DirectionalBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import twilightforest.util.entities.EntityUtil;

public class StrongholdShieldBlock
extends DirectionalBlock {
    public static final MapCodec<StrongholdShieldBlock> CODEC = StrongholdShieldBlock.simpleCodec(StrongholdShieldBlock::new);

    public StrongholdShieldBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)FACING, (Comparable)Direction.DOWN));
    }

    protected MapCodec<? extends DirectionalBlock> codec() {
        return CODEC;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING});
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        Direction facing = context.getNearestLookingDirection();
        if (facing.getAxis().equals((Object)Direction.Axis.Y)) {
            facing = facing.getOpposite();
        }
        return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)facing);
    }

    public float getDestroyProgress(BlockState state, Player player, BlockGetter getter, BlockPos pos) {
        BlockHitResult ray = EntityUtil.rayTrace(player, range -> range + 1.0);
        Direction hitFace = ray.getDirection();
        boolean upOrDown = state.getValue((Property)DirectionalBlock.FACING) == Direction.UP || state.getValue((Property)DirectionalBlock.FACING) == Direction.DOWN;
        Direction sideFace = ((Direction)state.getValue((Property)DirectionalBlock.FACING)).getOpposite();
        Direction upFace = (Direction)state.getValue((Property)DirectionalBlock.FACING);
        if (hitFace == (upOrDown ? upFace : sideFace)) {
            return player.getDigSpeed(Blocks.STONE.defaultBlockState(), pos) / 1.5f / 100.0f;
        }
        return super.getDestroyProgress(state, player, getter, pos);
    }

    public boolean canEntityDestroy(BlockState state, BlockGetter getter, BlockPos pos, Entity entity) {
        return false;
    }
}

