/*
 * Decompiled with CFR 0.152.
 */
package com.ilexiconn.llibrary.server.animation;

import com.ilexiconn.llibrary.server.animation.Animation;
import com.ilexiconn.llibrary.server.animation.IAnimatedEntity;
import com.ilexiconn.llibrary.server.event.AnimationEvent;
import com.ilexiconn.llibrary.server.network.AnimationMessage;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.Entity;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.network.PacketDistributor;
import org.apache.commons.lang3.ArrayUtils;

public enum AnimationHandler {
    INSTANCE;


    public <T extends Entity> void sendAnimationMessage(T entity, Animation animation) {
        if (entity.level().isClientSide) {
            return;
        }
        ((IAnimatedEntity)entity).setAnimation(animation);
        PacketDistributor.sendToPlayersTrackingEntityAndSelf(entity, (CustomPacketPayload)new AnimationMessage(entity.getId(), ArrayUtils.indexOf((Object[])((IAnimatedEntity)entity).getAnimations(), (Object)animation)), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public <T extends Entity> void updateAnimations(T entity) {
        if (((IAnimatedEntity)entity).getAnimation() == null) {
            ((IAnimatedEntity)entity).setAnimation(IAnimatedEntity.NO_ANIMATION);
        } else if (((IAnimatedEntity)entity).getAnimation() != IAnimatedEntity.NO_ANIMATION) {
            AnimationEvent.Start<T> event;
            if (((IAnimatedEntity)entity).getAnimationTick() == 0 && !((AnimationEvent.Start)NeoForge.EVENT_BUS.post(event = new AnimationEvent.Start<T>(entity, ((IAnimatedEntity)entity).getAnimation()))).isCanceled()) {
                this.sendAnimationMessage(entity, event.getAnimation());
            }
            if (((IAnimatedEntity)entity).getAnimationTick() < ((IAnimatedEntity)entity).getAnimation().getDuration()) {
                ((IAnimatedEntity)entity).setAnimationTick(((IAnimatedEntity)entity).getAnimationTick() + 1);
                NeoForge.EVENT_BUS.post(new AnimationEvent.Tick<T>(entity, ((IAnimatedEntity)entity).getAnimation(), ((IAnimatedEntity)entity).getAnimationTick()));
            }
            if (((IAnimatedEntity)entity).getAnimationTick() == ((IAnimatedEntity)entity).getAnimation().getDuration()) {
                if (!((IAnimatedEntity)entity).getAnimation().doesLoop()) {
                    ((IAnimatedEntity)entity).setAnimation(IAnimatedEntity.NO_ANIMATION);
                }
                ((IAnimatedEntity)entity).setAnimationTick(0);
            }
        }
    }
}

