/*
 * Decompiled with CFR 0.152.
 */
package com.bobmowzie.mowziesmobs.server.world.feature.structure.processor;

import com.bobmowzie.mowziesmobs.server.world.feature.structure.processor.ProcessorHandler;
import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.WorldGenRegion;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.WallBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.SlabType;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorType;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;

public class RootsProcessor
extends StructureProcessor {
    public static final RootsProcessor INSTANCE = new RootsProcessor();
    public static final MapCodec<RootsProcessor> CODEC = MapCodec.unit(() -> INSTANCE);

    protected StructureProcessorType<?> getType() {
        return (StructureProcessorType)ProcessorHandler.ROOTS_PROCESSOR.value();
    }

    public StructureTemplate.StructureBlockInfo process(LevelReader levelReader, BlockPos jigsawPiecePos, BlockPos jigsawPieceBottomCenterPos, StructureTemplate.StructureBlockInfo blockInfoLocal, StructureTemplate.StructureBlockInfo blockInfoGlobal, StructurePlaceSettings structurePlacementData, StructureTemplate template) {
        WorldGenRegion worldGenRegion;
        if (levelReader instanceof WorldGenRegion && !(worldGenRegion = (WorldGenRegion)levelReader).getCenter().equals((Object)new ChunkPos(blockInfoGlobal.pos()))) {
            return blockInfoGlobal;
        }
        RandomSource random = structurePlacementData.getRandom(blockInfoGlobal.pos());
        if ((double)random.nextFloat() < 0.15) {
            BlockPos pos;
            BlockState aboveState;
            if (blockInfoGlobal.state().is(Blocks.DARK_OAK_PLANKS) || blockInfoGlobal.state().is(Blocks.DARK_OAK_SLAB) && blockInfoGlobal.state().getValue((Property)SlabBlock.TYPE) != SlabType.TOP) {
                BlockPos pos2 = blockInfoGlobal.pos().below();
                BlockState belowState = levelReader.getBlockState(pos2);
                if (belowState.isAir()) {
                    levelReader.getChunk(pos2).setBlockState(pos2, Blocks.HANGING_ROOTS.defaultBlockState(), false);
                }
            } else if (blockInfoGlobal.state().is(Blocks.DARK_OAK_TRAPDOOR) && blockInfoGlobal.state().getValue((Property)TrapDoorBlock.HALF) == Half.TOP && !((Boolean)blockInfoGlobal.state().getValue((Property)TrapDoorBlock.OPEN)).booleanValue() && !(aboveState = levelReader.getBlockState(pos = blockInfoGlobal.pos().above())).isAir() && aboveState.isFaceSturdy((BlockGetter)levelReader, pos, Direction.DOWN) && !(aboveState.getBlock() instanceof WallBlock)) {
                blockInfoGlobal = new StructureTemplate.StructureBlockInfo(blockInfoGlobal.pos(), Blocks.HANGING_ROOTS.defaultBlockState(), blockInfoGlobal.nbt());
            }
        }
        return blockInfoGlobal;
    }
}

