/*
 * Decompiled with CFR 0.152.
 */
package com.bobmowzie.mowziesmobs.server.world.feature.structure;

import com.bobmowzie.mowziesmobs.server.block.BlockHandler;
import com.bobmowzie.mowziesmobs.server.entity.EntityHandler;
import com.bobmowzie.mowziesmobs.server.entity.umvuthana.EntityUmvuthanaMinion;
import com.bobmowzie.mowziesmobs.server.entity.umvuthana.EntityUmvuthi;
import com.bobmowzie.mowziesmobs.server.entity.umvuthana.MaskType;
import com.bobmowzie.mowziesmobs.server.item.ItemHandler;
import com.bobmowzie.mowziesmobs.server.item.ItemUmvuthanaMask;
import com.bobmowzie.mowziesmobs.server.loot.LootTableHandler;
import com.bobmowzie.mowziesmobs.server.world.feature.structure.StructureTypeHandler;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.util.Pair;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.decoration.ItemFrame;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LadderBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.SlabType;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.StructurePieceAccessor;
import net.minecraft.world.level.levelgen.structure.TemplateStructurePiece;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceType;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePiecesBuilder;
import net.minecraft.world.level.levelgen.structure.templatesystem.BlockIgnoreProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import net.minecraft.world.level.material.FluidState;

public class UmvuthanaGrovePieces {
    private static final Set<Block> BLOCKS_NEEDING_POSTPROCESSING = ImmutableSet.builder().add((Object)Blocks.NETHER_BRICK_FENCE).add((Object)Blocks.TORCH).add((Object)Blocks.WALL_TORCH).add((Object)Blocks.OAK_FENCE).add((Object)Blocks.SPRUCE_FENCE).add((Object)Blocks.DARK_OAK_FENCE).add((Object)Blocks.ACACIA_FENCE).add((Object)Blocks.BIRCH_FENCE).add((Object)Blocks.JUNGLE_FENCE).add((Object)Blocks.MANGROVE_FENCE).add((Object)Blocks.LADDER).add((Object)Blocks.SKELETON_SKULL).build();
    public static final ResourceLocation PLATFORM_1 = ResourceLocation.fromNamespaceAndPath((String)"mowziesmobs", (String)"umvuthana/umvuthana_platform_1");
    public static final ResourceLocation PLATFORM_2 = ResourceLocation.fromNamespaceAndPath((String)"mowziesmobs", (String)"umvuthana/umvuthana_platform_2");
    public static final ResourceLocation[] PLATFORMS = new ResourceLocation[]{PLATFORM_1, PLATFORM_2};
    public static final ResourceLocation PLATFORM_EXTEND = ResourceLocation.fromNamespaceAndPath((String)"mowziesmobs", (String)"umvuthana/umvuthana_platform_extend");
    public static final ResourceLocation FIREPIT = ResourceLocation.fromNamespaceAndPath((String)"mowziesmobs", (String)"umvuthana/umvuthana_firepit");
    public static final ResourceLocation FIREPIT_SMALL_1 = ResourceLocation.fromNamespaceAndPath((String)"mowziesmobs", (String)"umvuthana/umvuthana_firepit_small_1");
    public static final ResourceLocation FIREPIT_SMALL_2 = ResourceLocation.fromNamespaceAndPath((String)"mowziesmobs", (String)"umvuthana/umvuthana_firepit_small_2");
    public static final ResourceLocation[] FIREPIT_SMALL = new ResourceLocation[]{FIREPIT_SMALL_1, FIREPIT_SMALL_2};
    public static final ResourceLocation TREE_1 = ResourceLocation.fromNamespaceAndPath((String)"mowziesmobs", (String)"umvuthana/umvuthana_tree_1");
    public static final ResourceLocation TREE_2 = ResourceLocation.fromNamespaceAndPath((String)"mowziesmobs", (String)"umvuthana/umvuthana_tree_2");
    public static final ResourceLocation TREE_3 = ResourceLocation.fromNamespaceAndPath((String)"mowziesmobs", (String)"umvuthana/umvuthana_tree_3");
    public static final ResourceLocation[] TREES = new ResourceLocation[]{TREE_1, TREE_2, TREE_3};
    public static final ResourceLocation SPIKE_1 = ResourceLocation.fromNamespaceAndPath((String)"mowziesmobs", (String)"umvuthana/umvuthana_spike_1");
    public static final ResourceLocation SPIKE_2 = ResourceLocation.fromNamespaceAndPath((String)"mowziesmobs", (String)"umvuthana/umvuthana_spike_2");
    public static final ResourceLocation SPIKE_3 = ResourceLocation.fromNamespaceAndPath((String)"mowziesmobs", (String)"umvuthana/umvuthana_spike_3");
    public static final ResourceLocation SPIKE_4 = ResourceLocation.fromNamespaceAndPath((String)"mowziesmobs", (String)"umvuthana/umvuthana_spike_4");
    public static final ResourceLocation[] SPIKES = new ResourceLocation[]{SPIKE_1, SPIKE_2, SPIKE_3, SPIKE_4};
    public static final ResourceLocation THRONE = ResourceLocation.fromNamespaceAndPath((String)"mowziesmobs", (String)"umvuthana/umvuthi_throne");
    private static final Map<ResourceLocation, BlockPos> OFFSET = ImmutableMap.builder().put((Object)PLATFORM_1, (Object)new BlockPos(-5, 0, -5)).put((Object)PLATFORM_2, (Object)new BlockPos(0, 0, -5)).put((Object)PLATFORM_EXTEND, (Object)new BlockPos(8, 1, -2)).put((Object)FIREPIT, (Object)new BlockPos(-3, -2, -3)).put((Object)FIREPIT_SMALL_1, (Object)new BlockPos(-1, 0, -1)).put((Object)FIREPIT_SMALL_2, (Object)new BlockPos(-1, 0, -1)).put((Object)TREE_1, (Object)new BlockPos(-5, 1, -3)).put((Object)TREE_2, (Object)new BlockPos(-3, 1, -3)).put((Object)TREE_3, (Object)new BlockPos(-3, 1, -3)).put((Object)SPIKE_1, (Object)new BlockPos(-1, 1, 0)).put((Object)SPIKE_2, (Object)new BlockPos(0, 1, 0)).put((Object)SPIKE_3, (Object)new BlockPos(0, 1, 0)).put((Object)SPIKE_4, (Object)new BlockPos(0, 1, 0)).put((Object)THRONE, (Object)new BlockPos(-9, 0, 0)).build();
    private static final Map<ResourceLocation, Pair<BlockPos, BlockPos>> BOUNDS_OFFSET = ImmutableMap.builder().put((Object)PLATFORM_1, (Object)new Pair((Object)new BlockPos(1, 0, 0), (Object)new BlockPos(-3, 0, -3))).put((Object)PLATFORM_2, (Object)new Pair((Object)new BlockPos(0, 0, 0), (Object)new BlockPos(0, 0, -3))).put((Object)PLATFORM_EXTEND, (Object)new Pair((Object)new BlockPos(0, 0, 0), (Object)new BlockPos(0, 0, 0))).put((Object)FIREPIT, (Object)new Pair((Object)new BlockPos(0, 0, 0), (Object)new BlockPos(0, 0, 0))).put((Object)FIREPIT_SMALL_1, (Object)new Pair((Object)new BlockPos(0, 0, 0), (Object)new BlockPos(0, 0, 0))).put((Object)FIREPIT_SMALL_2, (Object)new Pair((Object)new BlockPos(0, 0, 0), (Object)new BlockPos(0, 0, 0))).put((Object)TREE_1, (Object)new Pair((Object)new BlockPos(1, 0, 1), (Object)new BlockPos(-3, 0, -3))).put((Object)TREE_2, (Object)new Pair((Object)new BlockPos(2, 0, 1), (Object)new BlockPos(-1, 0, -3))).put((Object)TREE_3, (Object)new Pair((Object)new BlockPos(2, 0, 2), (Object)new BlockPos(-2, 0, -2))).put((Object)SPIKE_1, (Object)new Pair((Object)new BlockPos(0, 0, 0), (Object)new BlockPos(0, 0, 0))).put((Object)SPIKE_2, (Object)new Pair((Object)new BlockPos(0, 0, 0), (Object)new BlockPos(0, 0, 0))).put((Object)SPIKE_3, (Object)new Pair((Object)new BlockPos(0, 0, 0), (Object)new BlockPos(0, 0, 0))).put((Object)SPIKE_4, (Object)new Pair((Object)new BlockPos(0, 0, 0), (Object)new BlockPos(0, 0, 0))).put((Object)THRONE, (Object)new Pair((Object)new BlockPos(4, 0, 1), (Object)new BlockPos(-4, 0, -3))).build();

    public static StructurePiece addPiece(ResourceLocation resourceLocation, StructureTemplateManager manager, BlockPos pos, Rotation rot, StructurePieceAccessor pieces, WorldgenRandom rand) {
        Piece newPiece = new Piece(manager, resourceLocation, rot, pos);
        pieces.addPiece((StructurePiece)newPiece);
        return newPiece;
    }

    public static StructurePiece addPieceCheckBounds(ResourceLocation resourceLocation, StructureTemplateManager manager, BlockPos pos, Rotation rot, StructurePieceAccessor pieces, WorldgenRandom rand, List<StructurePiece> ignore) {
        Piece newPiece = new Piece(manager, resourceLocation, rot, pos);
        StructurePiece collisionPiece = pieces.findCollisionPiece(newPiece.getCollisionBoundingBox());
        if (collisionPiece != null && !ignore.contains(collisionPiece)) {
            return null;
        }
        pieces.addPiece((StructurePiece)newPiece);
        return newPiece;
    }

    public static StructurePiece addPlatform(StructureTemplateManager manager, BlockPos pos, Rotation rot, StructurePiecesBuilder builder, WorldgenRandom rand) {
        int whichPlatform = rand.nextInt(PLATFORMS.length);
        Piece newPiece = new Piece(manager, PLATFORMS[whichPlatform], rot, pos);
        if (UmvuthanaGrovePieces.findCollisionPiece(builder.pieces, newPiece.getCollisionBoundingBox()) != null) {
            return null;
        }
        builder.addPiece((StructurePiece)newPiece);
        if (whichPlatform == 1) {
            Piece extension = new Piece(manager, PLATFORM_EXTEND, rot, pos);
            if (UmvuthanaGrovePieces.findCollisionPiece(builder.pieces, extension.getCollisionBoundingBox(), (StructurePiece)newPiece) != null) {
                return newPiece;
            }
            builder.addPiece((StructurePiece)extension);
        }
        return newPiece;
    }

    public static StructurePiece addPieceCheckBounds(ResourceLocation resourceLocation, StructureTemplateManager manager, BlockPos pos, Rotation rot, StructurePiecesBuilder pieces, WorldgenRandom rand) {
        return UmvuthanaGrovePieces.addPieceCheckBounds(resourceLocation, manager, pos, rot, (StructurePieceAccessor)pieces, rand, Collections.emptyList());
    }

    @Nullable
    public static StructurePiece findCollisionPiece(List<StructurePiece> pieces, BoundingBox bounds, StructurePiece ignore) {
        for (StructurePiece structurePiece : pieces) {
            if (structurePiece == ignore) continue;
            if (structurePiece instanceof Piece && ((Piece)structurePiece).getCollisionBoundingBox().intersects(bounds)) {
                return structurePiece;
            }
            if (!structurePiece.getBoundingBox().intersects(bounds)) continue;
            return structurePiece;
        }
        return null;
    }

    @Nullable
    public static StructurePiece findCollisionPiece(List<StructurePiece> pieces, BoundingBox bounds) {
        return UmvuthanaGrovePieces.findCollisionPiece(pieces, bounds, null);
    }

    public static class Piece
    extends TemplateStructurePiece {
        protected ResourceLocation resourceLocation;
        public BoundingBox collisionBoundingBox;

        public Piece(StructurePieceType pieceType, StructureTemplateManager manager, ResourceLocation resourceLocationIn, Rotation rotation, BlockPos pos) {
            super(pieceType, 0, manager, resourceLocationIn, resourceLocationIn.toString(), Piece.makeSettings(rotation, resourceLocationIn), Piece.makePosition(resourceLocationIn, pos, rotation));
            this.resourceLocation = resourceLocationIn;
            this.collisionBoundingBox = this.makeCollisionBoundingBox();
            if (this.resourceLocation == THRONE || this.resourceLocation == FIREPIT) {
                this.boundingBox = this.getBoundingBox().moved(0, 1, 0);
            }
        }

        public Piece(StructurePieceType pieceType, StructurePieceSerializationContext context, CompoundTag tagCompound) {
            super(pieceType, tagCompound, context.structureTemplateManager(), resourceLocation -> Piece.makeSettings(Rotation.valueOf((String)tagCompound.getString("Rot")), resourceLocation));
            this.collisionBoundingBox = this.makeCollisionBoundingBox();
            if (this.resourceLocation == THRONE || this.resourceLocation == FIREPIT) {
                this.boundingBox = this.getBoundingBox().moved(0, 1, 0);
            }
        }

        public Piece(StructureTemplateManager manager, ResourceLocation resourceLocationIn, Rotation rotation, BlockPos pos) {
            this((StructurePieceType)StructureTypeHandler.UMVUTHANA_GROVE_PIECE.get(), manager, resourceLocationIn, rotation, pos);
        }

        public Piece(StructurePieceSerializationContext context, CompoundTag tagCompound) {
            this((StructurePieceType)StructureTypeHandler.UMVUTHANA_GROVE_PIECE.get(), context, tagCompound);
        }

        private static StructurePlaceSettings makeSettings(Rotation rotation, ResourceLocation resourceLocation) {
            return new StructurePlaceSettings().setRotation(rotation).setMirror(Mirror.NONE).addProcessor((StructureProcessor)BlockIgnoreProcessor.STRUCTURE_BLOCK);
        }

        private static BlockPos makePosition(ResourceLocation resourceLocation, BlockPos pos, Rotation rotation) {
            return pos.offset((Vec3i)OFFSET.get(resourceLocation).rotate(rotation));
        }

        public BoundingBox makeCollisionBoundingBox() {
            BlockPos boundsMaxOffset;
            StructureTemplate structuretemplate = this.template;
            BlockPos boundsMinOffset = boundsMaxOffset = new BlockPos(0, 0, 0);
            Pair<BlockPos, BlockPos> boundsOffset = BOUNDS_OFFSET.get(this.resourceLocation);
            if (boundsOffset != null) {
                boundsMinOffset = (BlockPos)boundsOffset.getFirst();
                boundsMaxOffset = (BlockPos)boundsOffset.getSecond();
            }
            Vec3i sizeVec = structuretemplate.getSize().offset(-1, -1, -1);
            BlockPos blockpos = StructureTemplate.transform((BlockPos)BlockPos.ZERO.offset((Vec3i)boundsMinOffset), (Mirror)this.placeSettings.getMirror(), (Rotation)this.placeSettings.getRotation(), (BlockPos)this.placeSettings.getRotationPivot());
            BlockPos blockpos1 = StructureTemplate.transform((BlockPos)BlockPos.ZERO.offset(sizeVec).offset((Vec3i)boundsMaxOffset), (Mirror)this.placeSettings.getMirror(), (Rotation)this.placeSettings.getRotation(), (BlockPos)this.placeSettings.getRotationPivot());
            return BoundingBox.fromCorners((Vec3i)blockpos, (Vec3i)blockpos1).move((Vec3i)this.templatePosition);
        }

        public BoundingBox getCollisionBoundingBox() {
            return this.collisionBoundingBox;
        }

        protected void addAdditionalSaveData(StructurePieceSerializationContext context, CompoundTag tagCompound) {
            super.addAdditionalSaveData(context, tagCompound);
            tagCompound.putString("Rot", this.placeSettings.getRotation().name());
        }

        public void postProcess(WorldGenLevel p_192682_, StructureManager p_192683_, ChunkGenerator p_192684_, RandomSource p_192685_, BoundingBox p_192686_, ChunkPos p_192687_, BlockPos p_192688_) {
            super.postProcess(p_192682_, p_192683_, p_192684_, p_192685_, p_192686_, p_192687_, p_192688_);
        }

        protected void handleDataMarker(String function, BlockPos pos, ServerLevelAccessor worldIn, RandomSource rand, BoundingBox sbb) {
            Rotation rotation = this.placeSettings.getRotation();
            if (function.equals("support")) {
                worldIn.setBlock(pos, Blocks.OAK_FENCE.defaultBlockState(), 3);
                this.fillAirLiquidDown((LevelAccessor)worldIn, Blocks.OAK_FENCE.defaultBlockState(), pos.below());
            } else if (function.equals("trunk")) {
                this.fillAirLiquidDownTrunk((LevelAccessor)worldIn, pos, rand);
            } else if (function.equals("leg")) {
                this.fillAirLiquidDown((LevelAccessor)worldIn, Blocks.STRIPPED_MANGROVE_LOG.defaultBlockState(), pos);
            } else if (function.equals("base")) {
                this.fillAirLiquidDownBase((LevelAccessor)worldIn, pos, rand);
            } else if (function.equals("umvuthi")) {
                this.setBlockState((LevelAccessor)worldIn, pos, Blocks.AIR.defaultBlockState());
                EntityUmvuthi barako = new EntityUmvuthi((EntityType<? extends EntityUmvuthi>)((EntityType)EntityHandler.UMVUTHI.get()), (Level)worldIn.getLevel());
                barako.setPos((double)pos.getX() + 0.5, pos.getY(), (double)pos.getZ() + 0.5);
                int i = rotation.rotate(3, 4);
                barako.setDirection(i);
                barako.finalizeSpawn(worldIn, worldIn.getCurrentDifficultyAt(barako.blockPosition()), MobSpawnType.STRUCTURE, null);
                BlockPos offset = new BlockPos(0, 0, -18);
                offset = offset.rotate(rotation);
                BlockPos firePitPos = pos.offset((Vec3i)offset);
                firePitPos = worldIn.getHeightmapPos(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, firePitPos);
                barako.restrictTo(firePitPos, -1);
                worldIn.addFreshEntity((Entity)barako);
            } else if ("chest".equals(function)) {
                Direction facing = Direction.NORTH;
                facing = rotation.rotate(facing);
                this.createChest(worldIn, sbb, rand, pos, LootTableHandler.UMVUTHANA_GROVE_CHEST, (BlockState)Blocks.CHEST.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)facing));
            } else if ("skull".equals(function)) {
                BlockPos groundPos = this.getGroundPos((LevelAccessor)worldIn, pos);
                this.setBlockState((LevelAccessor)worldIn, groundPos.above(), (BlockState)Blocks.SKELETON_SKULL.defaultBlockState().setValue((Property)BlockStateProperties.ROTATION_16, (Comparable)Integer.valueOf(rand.nextInt(16))));
            } else if ("campfire".equals(function)) {
                BlockPos groundPos = this.getGroundPos((LevelAccessor)worldIn, pos);
                this.setBlockState((LevelAccessor)worldIn, groundPos.above(), Blocks.CAMPFIRE.defaultBlockState());
            } else if (function.length() > 5 && "spike".equals(function.substring(0, 5))) {
                String[] split = function.split("_");
                int logCount = 2;
                int fenceCount = 1;
                int barCount = 1;
                int skullCount = 0;
                if (split.length > 1) {
                    logCount = Integer.parseInt(split[1]);
                }
                if (split.length > 2) {
                    fenceCount = Integer.parseInt(split[2]);
                }
                if (split.length > 3) {
                    barCount = Integer.parseInt(split[3]);
                }
                if (split.length > 4) {
                    skullCount = Integer.parseInt(split[4]);
                }
                this.genSpike((LevelAccessor)worldIn, pos, rand, logCount, fenceCount, barCount, skullCount);
            } else if (function.length() > 6 && "stairs".equals(function.substring(0, 6))) {
                String[] split = function.split("_");
                Direction stairDirection = Direction.EAST;
                Direction newDirection = null;
                if (split.length > 1) {
                    newDirection = Direction.byName((String)split[1]);
                }
                if (newDirection != null) {
                    stairDirection = newDirection;
                }
                stairDirection = rotation.rotate(stairDirection);
                this.genStairs((LevelAccessor)worldIn, pos, rand, stairDirection);
            } else if ("chest_under".equals(function)) {
                if ((double)rand.nextFloat() < 0.5) {
                    worldIn.removeBlock(pos, false);
                } else {
                    BlockPos groundPos = this.getGroundPos((LevelAccessor)worldIn, pos);
                    Direction facing = (double)rand.nextFloat() < 0.5 ? Direction.NORTH : Direction.EAST;
                    facing = rotation.rotate(facing);
                    this.createChest(worldIn, sbb, rand, groundPos.above(), LootTableHandler.UMVUTHANA_GROVE_CHEST, (BlockState)Blocks.CHEST.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)facing));
                }
            } else if (function.length() > 4 && "mask".equals(function.substring(0, 4))) {
                worldIn.removeBlock(pos, false);
                String[] split = function.split("_");
                Direction direction = Direction.NORTH;
                if (split.length > 1) {
                    direction = Direction.byName((String)split[1]);
                }
                ItemFrame itemFrame = new ItemFrame((Level)worldIn.getLevel(), pos, rotation.rotate(direction));
                int i = rand.nextInt(MaskType.values().length);
                MaskType type = MaskType.values()[i];
                ItemUmvuthanaMask mask = (ItemUmvuthanaMask)ItemHandler.UMVUTHANA_MASK_FURY.get();
                switch (type) {
                    case BLISS: {
                        mask = (ItemUmvuthanaMask)ItemHandler.UMVUTHANA_MASK_BLISS.get();
                        break;
                    }
                    case FEAR: {
                        mask = (ItemUmvuthanaMask)ItemHandler.UMVUTHANA_MASK_FEAR.get();
                        break;
                    }
                    case FURY: {
                        mask = (ItemUmvuthanaMask)ItemHandler.UMVUTHANA_MASK_FURY.get();
                        break;
                    }
                    case MISERY: {
                        mask = (ItemUmvuthanaMask)ItemHandler.UMVUTHANA_MASK_MISERY.get();
                        break;
                    }
                    case RAGE: {
                        mask = (ItemUmvuthanaMask)ItemHandler.UMVUTHANA_MASK_RAGE.get();
                        break;
                    }
                    case FAITH: {
                        mask = (ItemUmvuthanaMask)ItemHandler.UMVUTHANA_MASK_FAITH.get();
                    }
                }
                ItemStack stack = new ItemStack((ItemLike)mask);
                itemFrame.setItem(stack, false);
                worldIn.addFreshEntity((Entity)itemFrame);
            } else {
                worldIn.removeBlock(pos, false);
            }
        }

        protected void setBlockState(LevelAccessor worldIn, BlockPos pos, BlockState state) {
            FluidState ifluidstate = worldIn.getFluidState(pos);
            if (!ifluidstate.isEmpty()) {
                worldIn.getFluidTicks().willTickThisTick(pos, (Object)ifluidstate.getType());
                if (state.hasProperty((Property)BlockStateProperties.WATERLOGGED)) {
                    state = (BlockState)state.setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(true));
                }
            }
            worldIn.setBlock(pos, state, 2);
            if (BLOCKS_NEEDING_POSTPROCESSING.contains(state.getBlock())) {
                worldIn.getChunk(pos).markPosForPostprocessing(pos);
            }
        }

        public BlockPos getGroundPos(LevelAccessor worldIn, BlockPos startPos) {
            while (!Block.canSupportRigidBlock((BlockGetter)worldIn, (BlockPos)startPos) && startPos.getY() > worldIn.getMinBuildHeight()) {
                startPos = startPos.below();
            }
            return startPos;
        }

        public void fillAirLiquidDown(LevelAccessor worldIn, BlockState state, BlockPos startPos) {
            int i = startPos.getX();
            int k = startPos.getZ();
            for (int j = startPos.getY(); !Block.canSupportRigidBlock((BlockGetter)worldIn, (BlockPos)new BlockPos(i, j, k)) && j > 1; --j) {
                BlockPos pos = new BlockPos(i, j, k);
                this.setBlockState(worldIn, pos, state);
            }
        }

        public void fillAirLiquidDownTrunk(LevelAccessor worldIn, BlockPos startPos, RandomSource rand) {
            int i = startPos.getX();
            int k = startPos.getZ();
            for (int j = startPos.getY(); !Block.canSupportRigidBlock((BlockGetter)worldIn, (BlockPos)new BlockPos(i, j, k)) && j > 1; --j) {
                BlockPos pos = new BlockPos(i, j, k);
                this.setBlockState(worldIn, pos, (double)rand.nextFloat() < 0.2 ? ((Block)BlockHandler.CLAWED_LOG.get()).defaultBlockState() : Blocks.STRIPPED_JUNGLE_WOOD.defaultBlockState());
            }
        }

        public void fillAirLiquidDownBase(LevelAccessor worldIn, BlockPos startPos, RandomSource rand) {
            int i = startPos.getX();
            int k = startPos.getZ();
            for (int j = startPos.getY(); !Block.canSupportRigidBlock((BlockGetter)worldIn, (BlockPos)new BlockPos(i, j, k)) && j > 1; --j) {
                BlockPos pos = new BlockPos(i, j, k);
                this.setBlockState(worldIn, pos, (double)rand.nextFloat() < 0.5 ? Blocks.STRIPPED_MANGROVE_LOG.defaultBlockState() : Blocks.RED_TERRACOTTA.defaultBlockState());
            }
        }

        public void genStairs(LevelAccessor worldIn, BlockPos pos, RandomSource rand, Direction direction) {
            for (int i = 1; i < 5; ++i) {
                if (!Block.canSupportRigidBlock((BlockGetter)worldIn, (BlockPos)pos)) {
                    BlockState state;
                    BlockState blockState = state = (double)rand.nextFloat() > 0.5 ? Blocks.ACACIA_SLAB.defaultBlockState() : Blocks.SMOOTH_RED_SANDSTONE_SLAB.defaultBlockState();
                    if (i % 2 == 1) {
                        state = (BlockState)state.setValue((Property)SlabBlock.TYPE, (Comparable)SlabType.TOP);
                    }
                    this.setBlockState(worldIn, pos, state);
                    pos = pos.relative(direction);
                    if (i % 2 != 0) continue;
                    pos = pos.relative(Direction.DOWN);
                    continue;
                }
                return;
            }
            pos = pos.relative(direction.getOpposite());
            this.fillAirLiquidDown(worldIn, Blocks.STRIPPED_MANGROVE_LOG.defaultBlockState(), pos);
            this.fillAirLiquidDown(worldIn, (BlockState)Blocks.LADDER.defaultBlockState().setValue((Property)LadderBlock.FACING, (Comparable)direction), pos.relative(direction));
        }

        public void genSpike(LevelAccessor worldIn, BlockPos startPos, RandomSource rand, int numLogs, int numFence, int numBars, int numSkulls) {
            int i;
            int groundPos = worldIn.getHeight(Heightmap.Types.OCEAN_FLOOR_WG, startPos.getX(), startPos.getZ());
            BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos(startPos.getX(), groundPos - 1, startPos.getZ());
            for (i = 0; i < numLogs; ++i) {
                this.setBlockState(worldIn, (BlockPos)pos, Blocks.STRIPPED_MANGROVE_LOG.defaultBlockState());
                pos.move(Direction.UP);
            }
            for (i = 0; i < numFence; ++i) {
                this.setBlockState(worldIn, (BlockPos)pos, Blocks.MANGROVE_FENCE.defaultBlockState());
                pos.move(Direction.UP);
            }
            for (i = 0; i < numBars; ++i) {
                this.setBlockState(worldIn, (BlockPos)pos, Blocks.IRON_BARS.defaultBlockState());
                pos.move(Direction.UP);
            }
            if ((double)rand.nextFloat() < 0.1 && numSkulls > 0) {
                this.setBlockState(worldIn, (BlockPos)pos, (BlockState)Blocks.SKELETON_SKULL.defaultBlockState().setValue((Property)BlockStateProperties.ROTATION_16, (Comparable)Integer.valueOf(rand.nextInt(16))));
            }
        }
    }

    public static class FirepitPiece
    extends Piece {
        public FirepitPiece(StructureTemplateManager manager, Rotation rotation, BlockPos pos) {
            super((StructurePieceType)StructureTypeHandler.UMVUTHANA_FIREPIT.get(), manager, FIREPIT, rotation, pos);
        }

        public FirepitPiece(StructurePieceSerializationContext context, CompoundTag tagCompound) {
            super((StructurePieceType)StructureTypeHandler.UMVUTHANA_FIREPIT.get(), context, tagCompound);
        }

        public BlockPos findGround(LevelAccessor worldIn, int x, int z) {
            int i = this.getWorldX(x, z);
            int k = this.getWorldZ(x, z);
            int j = worldIn.getHeight(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, i, k);
            return new BlockPos(i, j, k);
        }

        @Override
        public void postProcess(WorldGenLevel worldIn, StructureManager structureManager, ChunkGenerator chunkGenerator, RandomSource randomIn, BoundingBox p_230383_5_, ChunkPos p_230383_6_, BlockPos p_230383_7_) {
            super.postProcess(worldIn, structureManager, chunkGenerator, randomIn, p_230383_5_, p_230383_6_, p_230383_7_);
            BlockPos centerPos = this.findGround((LevelAccessor)worldIn, 4, 4);
            int numUmvuthana = randomIn.nextInt(5) + 5;
            block0: for (int i = 1; i <= numUmvuthana; ++i) {
                EntityUmvuthanaMinion umvuthana = new EntityUmvuthanaMinion((EntityType<? extends EntityUmvuthanaMinion>)((EntityType)EntityHandler.UMVUTHANA_MINION.get()), (Level)worldIn.getLevel());
                for (int j = 1; j <= 20; ++j) {
                    int distance = randomIn.nextInt(10) + 2;
                    int angle = randomIn.nextInt(360);
                    int x = (int)((double)distance * Math.sin(Math.toRadians(angle))) + 4;
                    int z = (int)((double)distance * Math.cos(Math.toRadians(angle))) + 4;
                    BlockPos bPos = this.findGround((LevelAccessor)worldIn, x, z);
                    umvuthana.setPos(bPos.getX(), bPos.getY(), bPos.getZ());
                    if (bPos.getY() <= 0 || !umvuthana.checkSpawnRules((LevelAccessor)worldIn, MobSpawnType.STRUCTURE) || !worldIn.noCollision(umvuthana.getBoundingBox())) continue;
                    umvuthana.finalizeSpawn((ServerLevelAccessor)worldIn, worldIn.getCurrentDifficultyAt(umvuthana.blockPosition()), MobSpawnType.STRUCTURE, null);
                    umvuthana.restrictTo(centerPos, 25);
                    worldIn.addFreshEntity((Entity)umvuthana);
                    continue block0;
                }
            }
        }
    }
}

