/*
 * Decompiled with CFR 0.152.
 */
package com.bobmowzie.mowziesmobs.server.world.feature.structure;

import com.bobmowzie.mowziesmobs.MMCommon;
import com.bobmowzie.mowziesmobs.server.config.ConfigHandler;
import com.bobmowzie.mowziesmobs.server.world.feature.structure.MowzieStructure;
import com.bobmowzie.mowziesmobs.server.world.feature.structure.StructureTypeHandler;
import com.bobmowzie.mowziesmobs.server.world.feature.structure.jigsaw.MowzieJigsawManager;
import com.mojang.serialization.MapCodec;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import org.apache.logging.log4j.Level;

public class MonasteryStructure
extends MowzieStructure {
    public static final Set<String> MUST_CONNECT_POOLS = Set.of("mowziesmobs:monastery/path_pool", "mowziesmobs:monastery/path_connector_pool");
    public static final Set<String> REPLACE_POOLS = Set.of("mowziesmobs:monastery/path_pool");
    public static final String STRAIGHT_POOL = "mowziesmobs:monastery/dead_end_connect_pool";
    public static final MapCodec<MonasteryStructure> CODEC = MonasteryStructure.simpleCodec(MonasteryStructure::new);

    public MonasteryStructure(Structure.StructureSettings settings) {
        super(settings, ConfigHandler.COMMON.MOBS.SCULPTOR.generationConfig, StructureTypeHandler.SCULPTOR_BIOMES, true, true, true);
    }

    @Override
    public GenerationStep.Decoration step() {
        return GenerationStep.Decoration.UNDERGROUND_DECORATION;
    }

    public static Optional<Structure.GenerationStub> createPiecesGenerator(Predicate<Structure.GenerationContext> canGeneratePredicate, Structure.GenerationContext context) {
        if (!canGeneratePredicate.test(context)) {
            return Optional.empty();
        }
        Structure.GenerationContext newContext = new Structure.GenerationContext(context.registryAccess(), context.chunkGenerator(), context.biomeSource(), context.randomState(), context.structureTemplateManager(), context.random(), context.seed(), context.chunkPos(), context.heightAccessor(), context.validBiome());
        BlockPos blockpos = context.chunkPos().getMiddleBlockPosition(0);
        Optional<Structure.GenerationStub> structurePiecesGenerator = MowzieJigsawManager.addPieces(newContext, (Holder<StructureTemplatePool>)Holder.direct((Object)((StructureTemplatePool)context.registryAccess().registryOrThrow(Registries.TEMPLATE_POOL).get(ResourceLocation.fromNamespaceAndPath((String)"mowziesmobs", (String)"monastery/start_pool")))), blockpos, false, true, 140, "mowziesmobs:monastery/path", "mowziesmobs:monastery/interior", MUST_CONNECT_POOLS, REPLACE_POOLS, STRAIGHT_POOL, 23);
        if (structurePiecesGenerator.isPresent()) {
            MMCommon.LOGGER.log(Level.DEBUG, "Monastery at " + String.valueOf(blockpos));
        }
        return structurePiecesGenerator;
    }

    @Override
    public Optional<Structure.GenerationStub> findGenerationPoint(Structure.GenerationContext context) {
        return MonasteryStructure.createPiecesGenerator(t -> this.checkLocation((Structure.GenerationContext)t), context);
    }

    public StructureType<?> type() {
        return (StructureType)StructureTypeHandler.MONASTERY.get();
    }
}

