/*
 * Decompiled with CFR 0.152.
 */
package com.bobmowzie.mowziesmobs.server.message;

import com.bobmowzie.mowziesmobs.MMCommon;
import com.bobmowzie.mowziesmobs.server.block.BlockGrottol;
import io.netty.buffer.ByteBuf;
import net.minecraft.core.BlockPos;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.jetbrains.annotations.NotNull;

public record MessageBlackPinkInYourArea(int entityId) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<MessageBlackPinkInYourArea> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"mowziesmobs", (String)"message_black_pink_in_your_area"));
    public static final StreamCodec<ByteBuf, MessageBlackPinkInYourArea> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.INT, MessageBlackPinkInYourArea::entityId, MessageBlackPinkInYourArea::new);

    public static MessageBlackPinkInYourArea fromMinecraft(AbstractMinecart minecart) {
        return new MessageBlackPinkInYourArea(minecart.getId());
    }

    public static void handleClient(MessageBlackPinkInYourArea packet, IPayloadContext context) {
        context.enqueueWork(() -> {
            Entity patt0$temp;
            Level level = MMCommon.PROXY.getClientLevel();
            if (level != null && (patt0$temp = level.getEntity(packet.entityId())) instanceof AbstractMinecart) {
                AbstractMinecart minecart = (AbstractMinecart)patt0$temp;
                MMCommon.PROXY.playBlackPinkSound(minecart);
                BlockState state = (BlockState)Blocks.STONE.defaultBlockState().setValue(BlockGrottol.VARIANT, (Comparable)((Object)BlockGrottol.Variant.BLACK_PINK));
                BlockPos pos = minecart.blockPosition();
                float scale = 0.75f;
                double x = minecart.getX();
                double y = minecart.getY() + 0.375 + 0.5 + (double)((float)(minecart.getDefaultDisplayOffset() - 8) / 16.0f * 0.75f);
                double z = minecart.getZ();
                SoundType sound = state.getBlock().getSoundType(state, (LevelReader)level, pos, (Entity)minecart);
                level.playLocalSound(x, y, z, sound.getBreakSound(), minecart.getSoundSource(), (sound.getVolume() + 1.0f) / 2.0f, sound.getPitch() * 0.8f, false);
                MMCommon.PROXY.minecartParticles(level, minecart, 0.75f, x, y, z, state, pos);
            }
        });
    }

    @NotNull
    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

