/*
 * Decompiled with CFR 0.152.
 */
package com.bobmowzie.mowziesmobs.server.loot;

import com.bobmowzie.mowziesmobs.server.entity.grottol.EntityGrottol;
import com.bobmowzie.mowziesmobs.server.loot.LootTableHandler;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.functions.LootItemConditionalFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import org.jetbrains.annotations.NotNull;

public class LootFunctionGrottolDeathType
extends LootItemConditionalFunction {
    public static final MapCodec<LootFunctionGrottolDeathType> CODEC = RecordCodecBuilder.mapCodec(instance -> LootFunctionGrottolDeathType.commonFields((RecordCodecBuilder.Instance)instance).apply((Applicative)instance, LootFunctionGrottolDeathType::new));

    protected LootFunctionGrottolDeathType(List<LootItemCondition> predicates) {
        super(predicates);
    }

    @NotNull
    protected ItemStack run(@NotNull ItemStack stack, LootContext context) {
        Object object = context.getParamOrNull(LootContextParams.THIS_ENTITY);
        if (object instanceof EntityGrottol) {
            EntityGrottol grottol = (EntityGrottol)object;
            EntityGrottol.EnumDeathType deathType = grottol.getDeathType();
            if (deathType == EntityGrottol.EnumDeathType.NORMAL) {
                stack.setCount(0);
            } else if (deathType == EntityGrottol.EnumDeathType.FORTUNE_PICKAXE) {
                stack.setCount(stack.getCount() + 1);
            }
        }
        return stack;
    }

    @NotNull
    public LootItemFunctionType<LootFunctionGrottolDeathType> getType() {
        return (LootItemFunctionType)LootTableHandler.GROTTOL_DEATH_TYPE.get();
    }
}

