/*
 * Decompiled with CFR 0.152.
 */
package com.bobmowzie.mowziesmobs.server.item;

import com.bobmowzie.mowziesmobs.server.ability.AbilityHandler;
import com.bobmowzie.mowziesmobs.server.capability.DataHandler;
import com.bobmowzie.mowziesmobs.server.capability.PlayerData;
import com.bobmowzie.mowziesmobs.server.config.ConfigHandler;
import com.bobmowzie.mowziesmobs.server.item.ItemHandler;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;

public class ItemWroughtAxe
extends AxeItem {
    public ItemWroughtAxe(Item.Properties properties) {
        super((Tier)Tiers.IRON, properties);
    }

    public boolean isValidRepairItem(ItemStack itemStack, ItemStack itemStackMaterial) {
        return (Boolean)ConfigHandler.COMMON.TOOLS_AND_ABILITIES.AXE_OF_A_THOUSAND_METALS.breakable.get() != false && super.isValidRepairItem(itemStack, itemStackMaterial);
    }

    public boolean isEnchantable(ItemStack p_77616_1_) {
        return true;
    }

    public boolean onLeftClickEntity(ItemStack stack, Player player, Entity entity) {
        if (entity instanceof Player) {
            PlayerData data = DataHandler.getData(entity, DataHandler.PLAYER_DATA);
            return !data.getAxeCanAttack() && data.getUntilAxeSwing() > 0;
        }
        return false;
    }

    public boolean onEntitySwing(ItemStack stack, LivingEntity entity, InteractionHand hand) {
        if (entity instanceof Player) {
            return DataHandler.getData((Entity)entity, DataHandler.PLAYER_DATA).getUntilAxeSwing() > 0;
        }
        return false;
    }

    public boolean hurtEnemy(ItemStack heldItemStack, LivingEntity entityHit, LivingEntity attacker) {
        if (((Boolean)ConfigHandler.COMMON.TOOLS_AND_ABILITIES.AXE_OF_A_THOUSAND_METALS.breakable.get()).booleanValue()) {
            heldItemStack.hurtAndBreak(2, attacker, LivingEntity.getSlotForHand((InteractionHand)InteractionHand.MAIN_HAND));
        }
        if (!entityHit.level().isClientSide) {
            entityHit.playSound(SoundEvents.ANVIL_LAND, 0.3f, 0.5f);
        }
        return true;
    }

    public InteractionResultHolder<ItemStack> use(Level world, Player player, InteractionHand hand) {
        if (hand == InteractionHand.MAIN_HAND && player.getAttackStrengthScale(0.5f) == 1.0f) {
            PlayerData data = DataHandler.getData((Entity)player, DataHandler.PLAYER_DATA);
            if (data.getUntilAxeSwing() <= 0) {
                boolean verticalAttack;
                boolean bl = verticalAttack = player.isShiftKeyDown() && player.onGround();
                if (verticalAttack) {
                    AbilityHandler.INSTANCE.sendAbilityMessage(player, AbilityHandler.WROUGHT_AXE_SLAM_ABILITY);
                } else {
                    AbilityHandler.INSTANCE.sendAbilityMessage(player, AbilityHandler.WROUGHT_AXE_SWING_ABILITY);
                }
                data.setVerticalSwing(verticalAttack);
                data.setUntilAxeSwing(30);
                player.startUsingItem(hand);
                if (((Boolean)ConfigHandler.COMMON.TOOLS_AND_ABILITIES.AXE_OF_A_THOUSAND_METALS.breakable.get()).booleanValue() && !player.getAbilities().instabuild) {
                    player.getItemInHand(hand).hurtAndBreak(2, (LivingEntity)player, LivingEntity.getSlotForHand((InteractionHand)hand));
                }
            }
            return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)player.getItemInHand(hand));
        }
        return super.use(world, player, hand);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flagIn) {
        super.appendHoverText(stack, context, tooltip, flagIn);
        tooltip.add((Component)Component.translatable((String)(this.getDescriptionId() + ".text.0")).setStyle(ItemHandler.TOOLTIP_STYLE));
        tooltip.add((Component)Component.translatable((String)(this.getDescriptionId() + ".text.1")).setStyle(ItemHandler.TOOLTIP_STYLE));
        tooltip.add((Component)Component.translatable((String)(this.getDescriptionId() + ".text.2")).setStyle(ItemHandler.TOOLTIP_STYLE));
    }
}

