/*
 * Decompiled with CFR 0.152.
 */
package com.bobmowzie.mowziesmobs.server.entity.umvuthana;

import com.bobmowzie.mowziesmobs.client.particle.ParticleHandler;
import com.bobmowzie.mowziesmobs.client.particle.util.AdvancedParticleBase;
import com.bobmowzie.mowziesmobs.client.particle.util.ParticleComponent;
import com.bobmowzie.mowziesmobs.server.ability.AbilityHandler;
import com.bobmowzie.mowziesmobs.server.capability.DataHandler;
import com.bobmowzie.mowziesmobs.server.capability.PlayerData;
import com.bobmowzie.mowziesmobs.server.entity.MowzieEntity;
import com.bobmowzie.mowziesmobs.server.entity.umvuthana.EntityUmvuthanaFollower;
import com.bobmowzie.mowziesmobs.server.item.ItemHandler;
import com.bobmowzie.mowziesmobs.server.item.ItemUmvuthanaMask;
import com.bobmowzie.mowziesmobs.server.sound.MMSounds;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class EntityUmvuthanaFollowerToPlayer
extends EntityUmvuthanaFollower<Player> {
    private static final EntityDataAccessor<ItemStack> MASK_STORED = SynchedEntityData.defineId(EntityUmvuthanaFollowerToPlayer.class, (EntityDataSerializer)EntityDataSerializers.ITEM_STACK);
    public Vec3[] feetPos;

    public EntityUmvuthanaFollowerToPlayer(EntityType<? extends EntityUmvuthanaFollowerToPlayer> type, Level world) {
        this(type, world, (Player)null);
    }

    public EntityUmvuthanaFollowerToPlayer(EntityType<? extends EntityUmvuthanaFollowerToPlayer> type, Level world, Player leader) {
        super(type, world, Player.class, leader);
        this.xpReward = 0;
        if (world.isClientSide) {
            this.feetPos = new Vec3[]{new Vec3(0.0, 0.0, 0.0)};
        }
    }

    @Override
    protected void defineSynchedData(@NotNull SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(MASK_STORED, (Object)new ItemStack((ItemLike)ItemHandler.UMVUTHANA_MASK_FURY.get(), 1));
    }

    @Override
    protected SoundEvent getAmbientSound() {
        if ((double)this.random.nextFloat() < 0.5) {
            return null;
        }
        return super.getAmbientSound();
    }

    @Override
    public void tick() {
        if (this.tickCount > 30 && (this.getLeader() == null || ((Player)this.getLeader()).getHealth() <= 0.0f)) {
            this.deactivate();
        }
        super.tick();
        if (this.level().isClientSide && this.feetPos != null && this.feetPos.length > 0 && this.active) {
            this.feetPos[0] = this.position().add(0.0, (double)0.05f, 0.0);
            if (this.tickCount % 10 == 0) {
                AdvancedParticleBase.spawnParticle(this.level(), ParticleHandler.RING2, this.feetPos[0].x(), this.feetPos[0].y(), this.feetPos[0].z(), 0.0, 0.0, 0.0, false, 0.0, 1.5707963267948966, 0.0, 0.0, 1.5, 1.0, 0.8745098114013672, 0.25882354378700256, 1.0, 1.0, 15.0, true, false, new ParticleComponent[]{new ParticleComponent.PinLocation(this.feetPos), new ParticleComponent.PropertyControl(ParticleComponent.PropertyControl.EnumParticleProperty.ALPHA, ParticleComponent.KeyTrack.startAndEnd(1.0f, 0.0f), false), new ParticleComponent.PropertyControl(ParticleComponent.PropertyControl.EnumParticleProperty.SCALE, ParticleComponent.KeyTrack.startAndEnd(1.0f, 10.0f), false)});
            }
        }
    }

    protected InteractionResult mobInteract(Player playerIn, InteractionHand hand) {
        if (playerIn == this.leader) {
            this.deactivate();
        }
        return super.mobInteract(playerIn, hand);
    }

    private void deactivate() {
        if (this.getActive() && this.getActiveAbilityType() != DEACTIVATE_ABILITY) {
            AbilityHandler.INSTANCE.sendAbilityMessage(this, DEACTIVATE_ABILITY);
            this.playSound((SoundEvent)MMSounds.ENTITY_UMVUTHANA_RETRACT.get(), 1.0f, 1.0f);
        }
    }

    public static AttributeSupplier.Builder createAttributes() {
        return MowzieEntity.createAttributes().add(Attributes.ATTACK_DAMAGE, 7.0).add(Attributes.MAX_HEALTH, 20.0);
    }

    @Override
    protected int getGroupCircleTick() {
        PlayerData data = this.getPlayerData();
        if (data == null) {
            return 0;
        }
        return data.getTribeCircleTick();
    }

    @Override
    protected int getPackSize() {
        PlayerData data = this.getPlayerData();
        if (data == null) {
            return 0;
        }
        return data.getPackSize();
    }

    @Override
    protected void addAsPackMember() {
        PlayerData data = this.getPlayerData();
        if (data == null) {
            return;
        }
        data.addPackMember(this);
    }

    @Override
    protected void removeAsPackMember() {
        PlayerData data = this.getPlayerData();
        if (data == null) {
            return;
        }
        data.removePackMember(this);
    }

    @Nullable
    private PlayerData getPlayerData() {
        if (this.leader instanceof Player) {
            return DataHandler.getData((Entity)this.leader, DataHandler.PLAYER_DATA);
        }
        return null;
    }

    @Override
    public boolean isUmvuthiDevoted() {
        return false;
    }

    @Override
    @NotNull
    protected ResourceKey<LootTable> getDefaultLootTable() {
        return BuiltInLootTables.EMPTY;
    }

    public boolean isTeleportFriendlyBlock(int x, int z, int y, int xOffset, int zOffset) {
        BlockPos blockpos = new BlockPos(x + xOffset, y - 1, z + zOffset);
        BlockState iblockstate = this.level().getBlockState(blockpos);
        return iblockstate.isValidSpawn((BlockGetter)this.level(), blockpos, this.getType()) && this.level().isEmptyBlock(blockpos.above()) && this.level().isEmptyBlock(blockpos.above(2));
    }

    public ItemStack getStoredMask() {
        return (ItemStack)this.getEntityData().get(MASK_STORED);
    }

    public void setStoredMask(ItemStack mask) {
        this.getEntityData().set(MASK_STORED, (Object)mask);
        this.setItemSlot(EquipmentSlot.HEAD, mask);
    }

    @Override
    protected ItemStack getDeactivatedMask(ItemUmvuthanaMask mask) {
        return this.getStoredMask();
    }

    @Override
    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        CompoundTag compoundnbt = compound.getCompound("storedMask");
        this.setStoredMask(ItemStack.parse((HolderLookup.Provider)this.registryAccess(), (Tag)compoundnbt).orElse(ItemStack.EMPTY));
    }

    @Override
    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        if (!this.getStoredMask().isEmpty()) {
            compound.put("storedMask", this.getStoredMask().save((HolderLookup.Provider)this.registryAccess(), (Tag)new CompoundTag()));
        }
    }
}

