/*
 * Decompiled with CFR 0.152.
 */
package com.bobmowzie.mowziesmobs.server.entity.umvuthana;

import com.bobmowzie.mowziesmobs.MMCommon;
import com.bobmowzie.mowziesmobs.client.model.tools.geckolib.MowzieAnimationController;
import com.bobmowzie.mowziesmobs.client.particle.ParticleDecal;
import com.bobmowzie.mowziesmobs.client.particle.ParticleHandler;
import com.bobmowzie.mowziesmobs.client.particle.ParticleRibbon;
import com.bobmowzie.mowziesmobs.client.particle.util.AdvancedParticleBase;
import com.bobmowzie.mowziesmobs.client.particle.util.ParticleComponent;
import com.bobmowzie.mowziesmobs.client.particle.util.RibbonComponent;
import com.bobmowzie.mowziesmobs.server.ability.Ability;
import com.bobmowzie.mowziesmobs.server.ability.AbilityHandler;
import com.bobmowzie.mowziesmobs.server.ability.AbilitySection;
import com.bobmowzie.mowziesmobs.server.ability.AbilityType;
import com.bobmowzie.mowziesmobs.server.ability.abilities.mob.BlockAbility;
import com.bobmowzie.mowziesmobs.server.ability.abilities.mob.DieAbility;
import com.bobmowzie.mowziesmobs.server.ability.abilities.mob.HurtAbility;
import com.bobmowzie.mowziesmobs.server.ability.abilities.mob.MeleeAttackAbility;
import com.bobmowzie.mowziesmobs.server.ability.abilities.player.SimpleAnimationAbility;
import com.bobmowzie.mowziesmobs.server.ai.EntityAIAvoidEntity;
import com.bobmowzie.mowziesmobs.server.ai.UseAbilityAI;
import com.bobmowzie.mowziesmobs.server.config.ConfigHandler;
import com.bobmowzie.mowziesmobs.server.entity.MowzieEntity;
import com.bobmowzie.mowziesmobs.server.entity.MowzieGeckoEntity;
import com.bobmowzie.mowziesmobs.server.entity.effects.EntitySunstrike;
import com.bobmowzie.mowziesmobs.server.entity.umvuthana.EntityUmvuthanaCrane;
import com.bobmowzie.mowziesmobs.server.entity.umvuthana.EntityUmvuthanaCraneToPlayer;
import com.bobmowzie.mowziesmobs.server.entity.umvuthana.EntityUmvuthanaRaptor;
import com.bobmowzie.mowziesmobs.server.entity.umvuthana.EntityUmvuthi;
import com.bobmowzie.mowziesmobs.server.entity.umvuthana.MaskType;
import com.bobmowzie.mowziesmobs.server.item.ItemHandler;
import com.bobmowzie.mowziesmobs.server.item.ItemUmvuthanaMask;
import com.bobmowzie.mowziesmobs.server.item.UmvuthanaMask;
import com.bobmowzie.mowziesmobs.server.loot.LootTableHandler;
import com.bobmowzie.mowziesmobs.server.potion.EffectHandler;
import com.bobmowzie.mowziesmobs.server.sound.MMSounds;
import java.util.EnumSet;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.BodyRotationControl;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.AbstractSkeleton;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.monster.Zoglin;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.monster.ZombifiedPiglin;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.registries.DeferredHolder;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.Animation;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationProcessor;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;

public abstract class EntityUmvuthana
extends MowzieGeckoEntity {
    public static final AbilityType<EntityUmvuthana, DieAbility<EntityUmvuthana>> DIE_ABILITY = new AbilityType<EntityUmvuthana, DieAbility>("umvuthana_die", (type, entity) -> new DieAbility<EntityUmvuthana>(type, entity, RawAnimation.begin().thenPlay("die"), 70){

        @Override
        public void tickUsing() {
            super.tickUsing();
            if (this.getTicksInUse() == 1) {
                ((EntityUmvuthana)this.getUser()).playSound((SoundEvent)MMSounds.ENTITY_UMVUTHANA_HURT.get(), ((EntityUmvuthana)this.getUser()).getSoundVolume(), ((EntityUmvuthana)this.getUser()).getVoicePitch());
            }
            if (this.getTicksInUse() == 15) {
                ((EntityUmvuthana)this.getUser()).playSound((SoundEvent)MMSounds.ENTITY_UMVUTHANA_RETRACT.get(), ((EntityUmvuthana)this.getUser()).getSoundVolume(), 1.0f);
            }
        }
    });
    public static final AbilityType<EntityUmvuthana, UmvuthanaHurtAbility> HURT_ABILITY = new AbilityType<EntityUmvuthana, UmvuthanaHurtAbility>("umvuthana_hurt", UmvuthanaHurtAbility::new);
    public static final AbilityType<EntityUmvuthana, UmvuthanaAttackAbility> ATTACK_ABILITY = new AbilityType<EntityUmvuthana, UmvuthanaAttackAbility>("umvuthana_attack", UmvuthanaAttackAbility::new);
    public static final AbilityType<EntityUmvuthana, SimpleAnimationAbility<EntityUmvuthana>> ALERT_ABILITY = new AbilityType<EntityUmvuthana, SimpleAnimationAbility>("umvuthana_alert", (type, entity) -> new SimpleAnimationAbility<EntityUmvuthana>(type, entity, RawAnimation.begin().thenPlay("alert"), 15, true){
        int soundFrame;

        @Override
        public void start() {
            super.start();
            this.soundFrame = this.rand.nextInt(7);
        }

        @Override
        public void tickUsing() {
            super.tickUsing();
            if (this.soundFrame == this.getTicksInUse()) {
                ((EntityUmvuthana)this.getUser()).playSound((SoundEvent)MMSounds.ENTITY_UMVUTHANA_ALERT.get(), ((EntityUmvuthana)this.getUser()).getSoundVolume(), ((EntityUmvuthana)this.getUser()).getVoicePitch());
            }
            if (((EntityUmvuthana)this.getUser()).getTarget() != null) {
                ((EntityUmvuthana)this.getUser()).lookAt((Entity)((EntityUmvuthana)this.getUser()).getTarget(), 30.0f, 30.0f);
                ((EntityUmvuthana)this.getUser()).getLookControl().setLookAt((Entity)((EntityUmvuthana)this.getUser()).getTarget(), 30.0f, 30.0f);
            }
        }

        @Override
        public void end() {
            super.end();
            if ((double)this.rand.nextFloat() < 0.2) {
                ((EntityUmvuthana)this.getUser()).sendAbilityMessage(ROAR_ABILITY);
            }
        }
    });
    public static final AbilityType<EntityUmvuthana, SimpleAnimationAbility<EntityUmvuthana>> ROAR_ABILITY = new AbilityType<EntityUmvuthana, SimpleAnimationAbility>("umvuthana_roar", (type, entity) -> new SimpleAnimationAbility<EntityUmvuthana>(type, entity, RawAnimation.begin().thenPlay("roar"), 35, true){

        @Override
        public void tickUsing() {
            super.tickUsing();
            if (this.getTicksInUse() == 2) {
                ((EntityUmvuthana)this.getUser()).playSound((SoundEvent)MMSounds.ENTITY_UMVUTHANA_ROAR.get(), ((EntityUmvuthana)this.getUser()).getSoundVolume() + 0.5f, ((EntityUmvuthana)this.getUser()).getVoicePitch());
            }
        }
    });
    public static final AbilityType<EntityUmvuthana, SimpleAnimationAbility<EntityUmvuthana>> ACTIVATE_ABILITY = new AbilityType<EntityUmvuthana, SimpleAnimationAbility>("umvuthana_activate", (type, entity) -> new SimpleAnimationAbility<EntityUmvuthana>(type, entity, RawAnimation.begin().thenPlay("emerge"), 21){

        @Override
        public void tickUsing() {
            super.tickUsing();
            if (this.getTicksInUse() == 5) {
                ((EntityUmvuthana)this.getUser()).playSound((SoundEvent)MMSounds.ENTITY_UMVUTHANA_EMERGE.get(), 1.0f, 1.0f);
            }
            if (this.getTicksInUse() == 10) {
                ((EntityUmvuthana)this.getUser()).active = true;
            }
        }
    });
    public static final AbilityType<EntityUmvuthana, SimpleAnimationAbility<EntityUmvuthana>> DEACTIVATE_ABILITY = new AbilityType<EntityUmvuthana, SimpleAnimationAbility>("umvuthana_deactivate", (type, entity) -> new SimpleAnimationAbility<EntityUmvuthana>(type, entity, RawAnimation.begin().thenPlay("retract"), 11){

        @Override
        public void end() {
            ItemEntity itemEntity;
            super.end();
            ((EntityUmvuthana)this.getUser()).discard();
            ItemUmvuthanaMask mask = EntityUmvuthana.getMaskFromType(((EntityUmvuthana)this.getUser()).getMaskType());
            if (!((EntityUmvuthana)this.getUser()).level().isClientSide && (itemEntity = ((EntityUmvuthana)this.getUser()).spawnAtLocation(((EntityUmvuthana)this.getUser()).getDeactivatedMask(mask), 1.5f)) != null) {
                ItemStack item = itemEntity.getItem();
                item.setDamageValue((int)Math.ceil((1.0f - ((EntityUmvuthana)this.getUser()).getHealthRatio()) * (float)item.getMaxDamage()));
                item.set(DataComponents.CUSTOM_NAME, (Object)((EntityUmvuthana)this.getUser()).getCustomName());
            }
        }
    });
    public static final AbilityType<EntityUmvuthana, BlockAbility<EntityUmvuthana>> BLOCK_ABILITY = new AbilityType<EntityUmvuthana, BlockAbility>("umvuthana_block", (type, entity) -> new BlockAbility<EntityUmvuthana>(type, (EntityUmvuthana)entity, RawAnimation.begin().thenPlay("block"), 10));
    public static final AbilityType<EntityUmvuthana, UmvuthanaBlockCounterAbility> BLOCK_COUNTER_ABILITY = new AbilityType<EntityUmvuthana, UmvuthanaBlockCounterAbility>("umvuthana_block_counter", UmvuthanaBlockCounterAbility::new);
    public static final AbilityType<EntityUmvuthana, UmvuthanaTeleportAbility> TELEPORT_ABILITY = new AbilityType<EntityUmvuthana, UmvuthanaTeleportAbility>("umvuthana_teleport", UmvuthanaTeleportAbility::new);
    public static final AbilityType<EntityUmvuthana, UmvuthanaHealAbility> HEAL_ABILITY = new AbilityType<EntityUmvuthana, UmvuthanaHealAbility>("umvuthana_heal", UmvuthanaHealAbility::new);
    private static final EntityDataAccessor<Boolean> DANCING = SynchedEntityData.defineId(EntityUmvuthana.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Integer> MASK = SynchedEntityData.defineId(EntityUmvuthana.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Integer> WEAPON = SynchedEntityData.defineId(EntityUmvuthana.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Boolean> ACTIVE = SynchedEntityData.defineId(EntityUmvuthana.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Float> HEALPOSX = SynchedEntityData.defineId(EntityUmvuthana.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Float> HEALPOSY = SynchedEntityData.defineId(EntityUmvuthana.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Float> HEALPOSZ = SynchedEntityData.defineId(EntityUmvuthana.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private boolean circleDirection = true;
    protected int circleTick = 0;
    protected boolean attacking = false;
    private int ticksWithoutTarget;
    public int timeUntilDeath = -1;
    private int blockCount = 0;
    public Vec3[] staffPos;
    public Vec3[] headPos;
    public Vec3[] barakoPos;
    public Vec3[] myPos;
    protected Vec3 teleportDestination;
    private static final byte FOOTSTEP_ID = 69;
    private int footstepCounter = 0;
    int maskTimingOffset = this.random.nextInt(0, 150);
    protected AnimationController<MowzieGeckoEntity> maskController = new MowzieAnimationController<EntityUmvuthana>(this, "mask_controller", 1, this::predicateMask, this.maskTimingOffset);
    protected MowzieAnimationController<MowzieGeckoEntity> walkRunController = new MowzieAnimationController<EntityUmvuthana>(this, "walk_run_controller", 4, this::predicateWalkRun, 0.0);
    private float prevMaskRot = 0.0f;
    private boolean rattling = false;
    private static RawAnimation MASK_TWITCH_ANIM = RawAnimation.begin().thenLoop("mask_twitch");
    private static RawAnimation RUN_SWITCH_ANIM = RawAnimation.begin().thenLoop("run_switch");
    private static RawAnimation WALK_SWITCH_ANIM = RawAnimation.begin().thenLoop("walk_switch");
    private static final RawAnimation WALK_AGGRESSIVE_ANIM = RawAnimation.begin().thenLoop("walk_aggressive");
    private static final RawAnimation IDLE_AGGRESSIVE_ANIM = RawAnimation.begin().thenLoop("idle_aggressive");
    private static final RawAnimation WALK_NEUTRAL_ANIM = RawAnimation.begin().thenLoop("walk_neutral");
    private static final RawAnimation IDLE_NEUTRAL_ANIM = RawAnimation.begin().thenLoop("idle_neutral");
    private static final RawAnimation TUMBLE_ANIM = RawAnimation.begin().thenLoop("tumble");
    private static final RawAnimation INACTIVE_ANIM = RawAnimation.begin().thenLoop("inactive");

    public EntityUmvuthana(EntityType<? extends EntityUmvuthana> type, Level world) {
        super(type, world);
        this.setMask(MaskType.from(Mth.nextInt((RandomSource)this.random, (int)1, (int)4)));
        this.circleTick += this.random.nextInt(200);
        this.frame += this.random.nextInt(50);
        this.xpReward = 6;
        this.active = false;
        if (world.isClientSide) {
            this.staffPos = new Vec3[]{new Vec3(0.0, 0.0, 0.0)};
            this.barakoPos = new Vec3[]{new Vec3(0.0, 0.0, 0.0)};
            this.myPos = new Vec3[]{new Vec3(0.0, 0.0, 0.0)};
            this.headPos = new Vec3[]{new Vec3(0.0, 0.0, 0.0)};
        }
    }

    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(0, new UseAbilityAI<EntityUmvuthana>(this, ACTIVATE_ABILITY));
        this.goalSelector.addGoal(0, new UseAbilityAI<EntityUmvuthana>(this, DEACTIVATE_ABILITY));
        this.goalSelector.addGoal(1, new UseAbilityAI<EntityUmvuthana>(this, DIE_ABILITY));
        this.goalSelector.addGoal(2, new UseAbilityAI<EntityUmvuthana>(this, HURT_ABILITY, false));
        this.goalSelector.addGoal(3, new EntityAIAvoidEntity<EntitySunstrike>(this, EntitySunstrike.class, EntitySunstrike::isStriking, 3.0f, 0.7f));
        this.goalSelector.addGoal(2, new UseAbilityAI<EntityUmvuthana>(this, ATTACK_ABILITY));
        this.goalSelector.addGoal(2, new UseAbilityAI<EntityUmvuthana>(this, ALERT_ABILITY));
        this.goalSelector.addGoal(2, new UseAbilityAI<EntityUmvuthana>(this, ROAR_ABILITY));
        this.goalSelector.addGoal(2, new UseAbilityAI<EntityUmvuthana>(this, BLOCK_ABILITY));
        this.goalSelector.addGoal(2, new UseAbilityAI<EntityUmvuthana>(this, BLOCK_COUNTER_ABILITY));
        this.goalSelector.addGoal(2, new UseAbilityAI<EntityUmvuthana>(this, TELEPORT_ABILITY));
        this.goalSelector.addGoal(2, new UseAbilityAI<EntityUmvuthana>(this, HEAL_ABILITY, false));
        this.goalSelector.addGoal(7, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 0.4));
        this.goalSelector.addGoal(8, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.goalSelector.addGoal(8, (Goal)new LookAtPlayerGoal((Mob)this, EntityUmvuthana.class, 8.0f));
        this.goalSelector.addGoal(8, (Goal)new LookAtPlayerGoal((Mob)this, EntityUmvuthi.class, 8.0f));
        this.goalSelector.addGoal(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.goalSelector.addGoal(5, (Goal)new CircleAttackGoal(this, 6.5f));
        this.registerTargetGoals();
    }

    protected void registerTargetGoals() {
    }

    protected void registerHuntingTargetGoals() {
        this.targetSelector.addGoal(5, (Goal)new NearestAttackableTargetGoal((Mob)this, Animal.class, 200, true, false, target -> {
            float volume = target.getBbWidth() * target.getBbWidth() * target.getBbHeight();
            return (target.getAttribute(Attributes.ATTACK_DAMAGE) == null || target.getAttributeValue(Attributes.ATTACK_DAMAGE) < 3.0) && (double)volume > 0.1 && volume < 6.0f;
        }));
        this.targetSelector.addGoal(5, (Goal)new NearestAttackableTargetGoal((Mob)this, Zombie.class, 0, true, false, e -> !(e instanceof ZombifiedPiglin)));
        this.targetSelector.addGoal(5, (Goal)new NearestAttackableTargetGoal((Mob)this, AbstractSkeleton.class, 0, true, false, null));
        this.targetSelector.addGoal(5, (Goal)new NearestAttackableTargetGoal((Mob)this, Zoglin.class, 0, true, false, null));
        this.targetSelector.addGoal(6, (Goal)new AvoidEntityGoal((PathfinderMob)this, Creeper.class, 6.0f, 1.0, 1.2));
        this.targetSelector.addGoal(4, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, 0, true, true, target -> {
            if (target instanceof Player) {
                if (this.level().getDifficulty() == Difficulty.PEACEFUL) {
                    return false;
                }
                ItemStack headArmorStack = (ItemStack)((Player)target).getInventory().armor.get(3);
                return !(headArmorStack.getItem() instanceof UmvuthanaMask);
            }
            return true;
        }));
    }

    @Override
    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        super.registerControllers(controllers);
        controllers.add(this.maskController);
        controllers.add(this.walkRunController);
    }

    protected <E extends GeoEntity> PlayState predicateMask(AnimationState<E> event) {
        if (this.isAlive() && this.active && this.getActiveAbilityType() != HEAL_ABILITY) {
            event.getController().setAnimation(MASK_TWITCH_ANIM);
            return PlayState.CONTINUE;
        }
        return PlayState.STOP;
    }

    protected <E extends GeoEntity> PlayState predicateWalkRun(AnimationState<E> event) {
        float threshold = 0.9f;
        AnimationProcessor.QueuedAnimation currentAnim = event.getController().getCurrentAnimation();
        if (currentAnim != null && currentAnim.animation().name().equals("run_switch")) {
            threshold = 0.7f;
        }
        if (event.getLimbSwingAmount() > threshold && !this.isStrafing()) {
            event.getController().setAnimation(RUN_SWITCH_ANIM);
        } else {
            event.getController().setAnimation(WALK_SWITCH_ANIM);
        }
        return PlayState.CONTINUE;
    }

    @Override
    protected <E extends GeoEntity> void loopingAnimations(AnimationState<E> event) {
        if (this.active) {
            if (this.isAggressive()) {
                event.getController().transitionLength(4);
                if (event.isMoving()) {
                    event.getController().setAnimation(WALK_AGGRESSIVE_ANIM);
                } else {
                    event.getController().setAnimation(IDLE_AGGRESSIVE_ANIM);
                }
            } else {
                event.getController().transitionLength(4);
                if (event.isMoving()) {
                    event.getController().setAnimation(WALK_NEUTRAL_ANIM);
                } else {
                    event.getController().setAnimation(IDLE_NEUTRAL_ANIM);
                }
            }
        } else {
            event.getController().transitionLength(0);
            if (!(this.onGround() || this.isInLava() || this.isInWater())) {
                event.getController().setAnimation(TUMBLE_ANIM);
            } else {
                event.getController().setAnimation(INACTIVE_ANIM);
            }
        }
    }

    protected BodyRotationControl createBodyControl() {
        return super.createBodyControl();
    }

    @Override
    public AbilityType getDeathAbility() {
        return DIE_ABILITY;
    }

    @Override
    public AbilityType getHurtAbility() {
        return HURT_ABILITY;
    }

    @Override
    public boolean shouldPlayHurtAnimation(DamageSource source, float damage) {
        return super.shouldPlayHurtAnimation(source, damage);
    }

    protected SoundEvent getAmbientSound() {
        if (this.getActiveAbilityType() == DEACTIVATE_ABILITY) {
            return null;
        }
        int i = Mth.nextInt((RandomSource)this.random, (int)0, (int)MMSounds.ENTITY_UMVUTHANA_IDLE.size());
        if (i < MMSounds.ENTITY_UMVUTHANA_IDLE.size()) {
            return (SoundEvent)((DeferredHolder)MMSounds.ENTITY_UMVUTHANA_IDLE.get(i)).get();
        }
        return null;
    }

    protected SoundEvent getHurtSound(DamageSource source) {
        return this.active ? (SoundEvent)MMSounds.ENTITY_UMVUTHANA_HURT.get() : null;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return MowzieEntity.createAttributes().add(Attributes.ATTACK_DAMAGE, 3.0).add(Attributes.MAX_HEALTH, 8.0).add(Attributes.STEP_HEIGHT, 1.0);
    }

    public SpawnGroupData finalizeSpawn(ServerLevelAccessor world, DifficultyInstance difficulty, MobSpawnType reason, SpawnGroupData livingData) {
        if (this.canHoldVaryingWeapons()) {
            this.setWeapon(this.random.nextInt(3) == 0 ? 1 : 0);
        }
        if (!(reason != MobSpawnType.COMMAND || this instanceof EntityUmvuthanaRaptor || this instanceof EntityUmvuthanaCrane || this instanceof EntityUmvuthanaCraneToPlayer)) {
            this.setMask(MaskType.from(Mth.nextInt((RandomSource)this.random, (int)1, (int)4)));
        }
        return super.finalizeSpawn(world, difficulty, reason, livingData);
    }

    protected boolean canHoldVaryingWeapons() {
        return true;
    }

    protected Vec3 updateCirclingPosition(float radius, float speed) {
        LivingEntity target = this.getTarget();
        if (target != null) {
            if (this.random.nextInt(200) == 0) {
                boolean bl = this.circleDirection = !this.circleDirection;
            }
            this.circleTick = this.circleDirection ? ++this.circleTick : --this.circleTick;
            return this.circleEntityPosition((Entity)target, radius, speed, true, this.circleTick, 0.0f);
        }
        return null;
    }

    @Override
    public void tick() {
        super.tick();
        if (this.level().isClientSide() && this.deathTime < 20 && this.active && (this.getActiveAbilityType() != TELEPORT_ABILITY || this.getActiveAbility().getCurrentSection().sectionType == AbilitySection.AbilitySectionType.RECOVERY)) {
            if (this.tickCount % 10 == 1) {
                AdvancedParticleBase.spawnParticle(this.level(), ParticleHandler.GLOW, this.getX(), this.getY(), this.getZ(), 0.0, 0.0, 0.0, true, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 1.0, 0.3, 0.4, 1.0, 9.0, true, false, new ParticleComponent[]{new ParticleComponent.PinLocation(this.headPos), new ParticleComponent.PropertyControl(ParticleComponent.PropertyControl.EnumParticleProperty.SCALE, ParticleComponent.KeyTrack.oscillate(9.0f, 10.0f, 12), false)});
            }
            if (this.headPos != null && this.headPos.length > 0 && this.headPos[0] != null && this.random.nextFloat() < 0.3f) {
                int amount = this.random.nextInt(2) + 1;
                while (amount-- > 0) {
                    float theta = this.random.nextFloat() * ((float)Math.PI * 2);
                    float r = this.random.nextFloat() * 0.4f;
                    float x = r * Mth.cos((float)theta);
                    float z = r * Mth.sin((float)theta);
                    this.level().addParticle((ParticleOptions)ParticleTypes.SMOKE, this.headPos[0].x() + (double)x, this.headPos[0].y() + 0.1, this.headPos[0].z() + (double)z, 0.0, 0.0, 0.0);
                }
            }
        }
        if (this.getTarget() != null && (this.getTarget().isRemoved() || this.getTarget().isDeadOrDying())) {
            this.setTarget(null);
        }
        if (this.getActiveAbilityType() != BLOCK_ABILITY && this.blockCount > 0 && this.tickCount % 10 == 0) {
            --this.blockCount;
        }
        if (!this.level().isClientSide && this.active && !this.getActive()) {
            this.setActive(true);
        }
        this.active = this.getActive();
        if (!this.active) {
            this.getNavigation().stop();
            this.setYRot(this.yRotO);
            this.yBodyRot = this.getYRot();
            if ((this.onGround() || this.isInWater() || this.isInLava()) && this.getActiveAbility() == null) {
                this.sendAbilityMessage(ACTIVATE_ABILITY);
            }
            return;
        }
        if (this.getActiveAbilityType() != null && this.getActiveAbilityType() != HURT_ABILITY) {
            this.getNavigation().stop();
            this.yHeadRot = this.yBodyRot = this.getYRot();
        }
        if (this.getTarget() != null && this.ticksWithoutTarget > 3) {
            this.sendAbilityMessage(ALERT_ABILITY);
        }
        this.ticksWithoutTarget = this.getTarget() == null ? ++this.ticksWithoutTarget : 0;
        if (this.timeUntilDeath > 0) {
            --this.timeUntilDeath;
        } else if (this.timeUntilDeath == 0) {
            this.hurt(this.damageSources().indirectMagic((Entity)this, null), this.getHealth() + 1.0f);
        }
    }

    public void updateRattleSound(float maskRot) {
        if (!this.rattling) {
            if ((double)Math.abs(maskRot - this.prevMaskRot) > 0.06) {
                this.level().playLocalSound(this.getX(), this.getY(), this.getZ(), (SoundEvent)MMSounds.ENTITY_UMVUTHANA_RATTLE.get(), SoundSource.HOSTILE, 0.03f, this.getVoicePitch(), false);
            }
        } else if ((double)Math.abs(maskRot - this.prevMaskRot) < 1.0E-8) {
            this.rattling = false;
        }
        this.prevMaskRot = maskRot;
    }

    protected float nextStep() {
        if (this.onGround()) {
            this.level().broadcastEntityEvent((Entity)this, (byte)69);
        }
        return super.nextStep();
    }

    @Override
    public void handleEntityEvent(byte id) {
        if (id == 69 && ((Boolean)ConfigHandler.CLIENT.umvuthanaFootprints.get()).booleanValue()) {
            ++this.footstepCounter;
            double rotation = Math.toRadians(this.yBodyRot + 180.0f);
            Vec3 offset = new Vec3(0.0, 0.0, this.footstepCounter % 2 == 0 ? 0.3 : -0.3).yRot((float)(-rotation) + 90.0f);
            ParticleDecal.spawnDecal(this.level(), ParticleHandler.STRIX_FOOTPRINT, this.getX() + offset.x(), this.getY() + 0.01, this.getZ() + offset.z(), 0.0, 0.0, 0.0, rotation, 1.0, 1.0, 0.95, 0.1, 1.0, 1.0, 200.0, true, 8, 32, new ParticleComponent[]{new ParticleComponent.PropertyControl(ParticleComponent.PropertyControl.EnumParticleProperty.RED, new ParticleComponent.KeyTrack(new float[]{0.995f, 0.05f}, new float[]{0.0f, 0.3f}), false), new ParticleComponent.PropertyControl(ParticleComponent.PropertyControl.EnumParticleProperty.GREEN, new ParticleComponent.KeyTrack(new float[]{0.95f, 0.05f}, new float[]{0.0f, 0.3f}), false), new ParticleComponent.PropertyControl(ParticleComponent.PropertyControl.EnumParticleProperty.BLUE, new ParticleComponent.KeyTrack(new float[]{0.1f, 0.05f}, new float[]{0.0f, 0.3f}), false), new ParticleComponent.PropertyControl(ParticleComponent.PropertyControl.EnumParticleProperty.ALPHA, new ParticleComponent.KeyTrack(new float[]{1.0f, 0.8f}, new float[]{0.0f, 0.3f}), false), new ParticleComponent(){

                @Override
                public void postUpdate(AdvancedParticleBase particle) {
                    super.postUpdate(particle);
                    if (particle.getAge() < 80.0f && EntityUmvuthana.this.random.nextFloat() < 0.3f) {
                        int amount = 1;
                        while (amount-- > 0) {
                            float theta = EntityUmvuthana.this.random.nextFloat() * ((float)Math.PI * 2);
                            float r = EntityUmvuthana.this.random.nextFloat() * 0.2f;
                            float x = r * Mth.cos((float)theta);
                            float z = r * Mth.sin((float)theta);
                            EntityUmvuthana.this.level().addParticle((ParticleOptions)ParticleTypes.SMOKE, particle.getPosX() + (double)x, particle.getPosY() + 0.05, particle.getPosZ() + (double)z, 0.0, 0.0, 0.0);
                        }
                    }
                }
            }});
        } else {
            super.handleEntityEvent(id);
        }
    }

    public static ItemUmvuthanaMask getMaskFromType(MaskType maskType) {
        ItemUmvuthanaMask mask = (ItemUmvuthanaMask)ItemHandler.UMVUTHANA_MASK_FURY.get();
        switch (maskType) {
            case BLISS: {
                mask = (ItemUmvuthanaMask)ItemHandler.UMVUTHANA_MASK_BLISS.get();
                break;
            }
            case FEAR: {
                mask = (ItemUmvuthanaMask)ItemHandler.UMVUTHANA_MASK_FEAR.get();
                break;
            }
            case FURY: {
                mask = (ItemUmvuthanaMask)ItemHandler.UMVUTHANA_MASK_FURY.get();
                break;
            }
            case MISERY: {
                mask = (ItemUmvuthanaMask)ItemHandler.UMVUTHANA_MASK_MISERY.get();
                break;
            }
            case RAGE: {
                mask = (ItemUmvuthanaMask)ItemHandler.UMVUTHANA_MASK_RAGE.get();
                break;
            }
            case FAITH: {
                mask = (ItemUmvuthanaMask)ItemHandler.UMVUTHANA_MASK_FAITH.get();
            }
        }
        return mask;
    }

    protected ItemStack getDeactivatedMask(ItemUmvuthanaMask mask) {
        return new ItemStack((ItemLike)mask);
    }

    protected SoundEvent getDeathSound() {
        this.playSound((SoundEvent)MMSounds.ENTITY_UMVUTHANA_DIE.get(), 1.0f, 0.95f + this.random.nextFloat() * 0.1f);
        return null;
    }

    @Override
    protected void defineSynchedData(@NotNull SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DANCING, (Object)false);
        builder.define(MASK, (Object)0);
        builder.define(WEAPON, (Object)0);
        builder.define(ACTIVE, (Object)true);
        builder.define(HEALPOSX, (Object)Float.valueOf(0.0f));
        builder.define(HEALPOSY, (Object)Float.valueOf(0.0f));
        builder.define(HEALPOSZ, (Object)Float.valueOf(0.0f));
    }

    public boolean getDancing() {
        return (Boolean)this.getEntityData().get(DANCING);
    }

    public void setDancing(boolean dancing) {
        this.getEntityData().set(DANCING, (Object)dancing);
    }

    public MaskType getMaskType() {
        return MaskType.from((Integer)this.getEntityData().get(MASK));
    }

    public void setMask(MaskType type) {
        this.getEntityData().set(MASK, (Object)type.ordinal());
        this.setItemSlot(EquipmentSlot.HEAD, EntityUmvuthana.getMaskFromType(type).getDefaultInstance());
        this.setDropChance(EquipmentSlot.HEAD, 0.0f);
    }

    public int getWeapon() {
        return (Integer)this.getEntityData().get(WEAPON);
    }

    public void setWeapon(int type) {
        this.getEntityData().set(WEAPON, (Object)type);
    }

    public boolean getActive() {
        return (Boolean)this.getEntityData().get(ACTIVE);
    }

    public void setActive(boolean active) {
        this.getEntityData().set(ACTIVE, (Object)active);
    }

    public Vec3 getHealPos() {
        return new Vec3((double)((Float)this.getEntityData().get(HEALPOSX)).floatValue(), (double)((Float)this.getEntityData().get(HEALPOSY)).floatValue(), (double)((Float)this.getEntityData().get(HEALPOSZ)).floatValue());
    }

    public void setHealPos(Vec3 vec) {
        this.getEntityData().set(HEALPOSX, (Object)Float.valueOf((float)vec.x));
        this.getEntityData().set(HEALPOSY, (Object)Float.valueOf((float)vec.y));
        this.getEntityData().set(HEALPOSZ, (Object)Float.valueOf((float)vec.z));
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putInt("mask", this.getMaskType().ordinal());
        compound.putInt("weapon", this.getWeapon());
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        this.setMask(MaskType.from(compound.getInt("mask")));
        this.setWeapon(compound.getInt("weapon"));
    }

    @Override
    public boolean hurt(DamageSource source, float damage) {
        if (this.getActiveAbilityType() == DEACTIVATE_ABILITY) {
            return false;
        }
        Entity entity = source.getEntity();
        if (source == this.damageSources().hotFloor()) {
            return false;
        }
        boolean angleFlag = true;
        if (entity != null) {
            float entityRelativeAngle;
            int arc = 220;
            Vec3 entityPos = entity.position();
            float entityHitAngle = (float)((Math.atan2(entityPos.z() - this.getZ(), entityPos.x() - this.getX()) * 57.29577951308232 - 90.0) % 360.0);
            float entityAttackingAngle = this.yBodyRot % 360.0f;
            if (entityHitAngle < 0.0f) {
                entityHitAngle += 360.0f;
            }
            if (entityAttackingAngle < 0.0f) {
                entityAttackingAngle += 360.0f;
            }
            boolean bl = angleFlag = (double)(entityRelativeAngle = entityHitAngle - entityAttackingAngle) <= (double)arc / 2.0 && (double)entityRelativeAngle >= (double)(-arc) / 2.0 || (double)entityRelativeAngle >= 360.0 - (double)arc / 2.0 || (double)entityRelativeAngle <= (double)(-arc) + 45.0;
        }
        if (angleFlag && this.getMaskType().canBlock && entity instanceof LivingEntity && (this.getActiveAbility() == null || this.getActiveAbilityType() == HURT_ABILITY || this.getActiveAbilityType() == BLOCK_ABILITY) && !source.is(DamageTypeTags.BYPASSES_ARMOR)) {
            this.blockingEntity = (LivingEntity)entity;
            this.playSound((SoundEvent)MMSounds.ENTITY_WROUGHT_UNDAMAGED.get(), 0.4f, 2.0f);
            if (this.blockingEntity == this.getTarget() && (double)this.random.nextFloat() < Mth.clamp((double)((double)this.blockCount / 5.0), (double)0.0, (double)1.0) && this.distanceTo((Entity)this.blockingEntity) < 4.0f) {
                AbilityHandler.INSTANCE.sendAbilityMessage(this, BLOCK_COUNTER_ABILITY);
                this.blockCount = 0;
            } else {
                AbilityHandler.INSTANCE.sendAbilityMessage(this, BLOCK_ABILITY);
                ++this.blockCount;
            }
            return false;
        }
        return super.hurt(source, damage);
    }

    @NotNull
    protected ResourceKey<LootTable> getDefaultLootTable() {
        return switch (this.getMaskType()) {
            default -> throw new MatchException(null, null);
            case MaskType.BLISS -> LootTableHandler.UMVUTHANA_BLISS;
            case MaskType.FEAR -> LootTableHandler.UMVUTHANA_FEAR;
            case MaskType.FURY -> LootTableHandler.UMVUTHANA_FURY;
            case MaskType.MISERY -> LootTableHandler.UMVUTHANA_MISERY;
            case MaskType.RAGE -> LootTableHandler.UMVUTHANA_RAGE;
            case MaskType.FAITH -> LootTableHandler.UMVUTHANA_FAITH;
        };
    }

    public boolean isPickable() {
        return this.active;
    }

    public boolean causeFallDamage(float distance, float damageMultipler, DamageSource source) {
        if (this.active) {
            return super.causeFallDamage(distance, damageMultipler, source);
        }
        return false;
    }

    @Override
    protected ConfigHandler.CombatConfig getCombatConfig() {
        return ConfigHandler.COMMON.MOBS.UMVUTHANA.combatConfig;
    }

    public boolean isUmvuthiDevoted() {
        return true;
    }

    public int randomizeWeapon() {
        return this.random.nextInt(3) == 0 ? 1 : 0;
    }

    public boolean canHeal(LivingEntity entity) {
        return false;
    }

    protected void sunBlockTarget() {
    }

    @Override
    public AbilityType<?, ?>[] getAbilities() {
        return new AbilityType[]{DIE_ABILITY, HURT_ABILITY, ATTACK_ABILITY, ALERT_ABILITY, ROAR_ABILITY, ACTIVATE_ABILITY, DEACTIVATE_ABILITY, BLOCK_ABILITY, BLOCK_COUNTER_ABILITY, TELEPORT_ABILITY, HEAL_ABILITY};
    }

    protected static class CircleAttackGoal
    extends Goal {
        private final EntityUmvuthana mob;
        private final float attackRadius;
        private int strafingLeftRightMul;
        private int strafingFrontBackMul;
        private boolean chasing = false;
        protected boolean attacking = false;
        private int timeSinceAttack = 0;

        public CircleAttackGoal(EntityUmvuthana mob, float attackRadius) {
            this.mob = mob;
            this.attackRadius = attackRadius;
            this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean canUse() {
            return this.mob.getTarget() != null;
        }

        public boolean canContinueToUse() {
            return this.canUse() || !this.mob.getNavigation().isDone();
        }

        public void start() {
            super.start();
            this.mob.setAggressive(true);
            this.timeSinceAttack = this.mob.random.nextInt(80);
        }

        public void stop() {
            super.stop();
            this.mob.setAggressive(false);
            this.mob.setStrafing(false);
            this.mob.getMoveControl().strafe(0.0f, 0.0f);
            this.attacking = false;
        }

        public boolean requiresUpdateEveryTick() {
            return true;
        }

        public void tick() {
            LivingEntity target = this.mob.getTarget();
            if (target != null) {
                if (this.timeSinceAttack < 80) {
                    ++this.timeSinceAttack;
                }
                double distToTarget = this.mob.distanceTo((Entity)target);
                float frontBackDistBuffer = 2.0f;
                float leftRightDistBuffer = 1.5f;
                if (this.chasing && distToTarget <= (double)this.attackRadius) {
                    this.chasing = false;
                }
                if (!this.chasing && distToTarget >= (double)(this.attackRadius + frontBackDistBuffer)) {
                    this.chasing = true;
                }
                if (this.chasing) {
                    this.mob.getNavigation().moveTo((Entity)target, 0.6);
                    this.mob.getLookControl().setLookAt((Entity)target, 30.0f, 30.0f);
                    this.mob.setStrafing(false);
                    this.mob.getMoveControl().strafe(0.0f, 0.0f);
                } else {
                    if (!this.attacking && this.mob.getActiveAbility() == null) {
                        this.mob.getNavigation().stop();
                        float strafeSpeed = 0.5f;
                        Vec3 circlePos = this.mob.updateCirclingPosition(this.attackRadius, strafeSpeed - 0.2f);
                        double distToCirclePos = this.mob.position().distanceTo(circlePos);
                        if (distToCirclePos <= (double)leftRightDistBuffer) {
                            this.mob.setStrafing(true);
                            this.strafingFrontBackMul = distToTarget > (double)this.attackRadius + 0.5 ? 1 : (distToTarget < (double)this.attackRadius - 0.5 ? -1 : 0);
                            Vec3 toTarget = target.position().subtract(this.mob.position()).multiply(1.0, 0.0, 1.0).normalize();
                            Vec3 toCirclePos = circlePos.subtract(this.mob.position()).multiply(1.0, 0.0, 1.0).normalize();
                            Vec3 cross = toTarget.cross(toCirclePos);
                            this.strafingLeftRightMul = cross.y > 0.0 ? 1 : (cross.y < 0.0 ? -1 : 0);
                            float distScale = (float)Math.min(Math.pow(distToCirclePos * 1.0 / (double)leftRightDistBuffer, 0.7), 1.0);
                            this.mob.getMoveControl().strafe((float)this.strafingFrontBackMul * strafeSpeed, (float)this.strafingLeftRightMul * strafeSpeed * distScale);
                            this.mob.lookAt((Entity)target, 30.0f, 30.0f);
                            if ((double)this.mob.random.nextFloat() < 0.002) {
                                this.mob.sendAbilityMessage(ROAR_ABILITY);
                            }
                        } else {
                            this.mob.setStrafing(false);
                            this.mob.getMoveControl().strafe(0.0f, 0.0f);
                            this.mob.getNavigation().moveTo(circlePos.x, circlePos.y, circlePos.z, 0.53);
                            this.mob.getLookControl().setLookAt((Entity)target, 30.0f, 30.0f);
                        }
                    } else {
                        this.mob.getMoveControl().strafe(0.0f, 0.0f);
                        this.mob.setStrafing(false);
                    }
                    if (this.mob.random.nextInt(80) == 0 && this.timeSinceAttack >= 80 && this.mob.getSensing().hasLineOfSight((Entity)target)) {
                        this.attacking = true;
                    }
                    if (this.attacking && this.mob.getActiveAbility() == null) {
                        this.mob.getNavigation().moveTo((Entity)target, 0.5);
                        if (distToTarget <= 3.75 && this.mob.getSensing().hasLineOfSight((Entity)target)) {
                            this.attacking = false;
                            this.timeSinceAttack = 0;
                            AbilityHandler.INSTANCE.sendAbilityMessage(this.mob, ATTACK_ABILITY);
                        }
                    }
                }
            }
        }
    }

    private static class UmvuthanaHealAbility
    extends Ability<EntityUmvuthana> {
        private static final RawAnimation HEAL_START_ANIM = RawAnimation.begin().thenPlay("heal_start");
        private static final RawAnimation HEAL_LOOP_ANIM = RawAnimation.begin().thenLoop("heal_loop");
        private static final RawAnimation HEAL_END_ANIM = RawAnimation.begin().thenPlay("heal_end");

        public UmvuthanaHealAbility(AbilityType<EntityUmvuthana, ? extends Ability> abilityType, EntityUmvuthana user) {
            super(abilityType, user, new AbilitySection[]{new AbilitySection.AbilitySectionDuration(AbilitySection.AbilitySectionType.STARTUP, 6), new AbilitySection.AbilitySectionInfinite(AbilitySection.AbilitySectionType.ACTIVE), new AbilitySection.AbilitySectionDuration(AbilitySection.AbilitySectionType.RECOVERY, 16)});
        }

        @Override
        protected void beginSection(AbilitySection section) {
            if (section.sectionType == AbilitySection.AbilitySectionType.STARTUP) {
                this.playAnimation(HEAL_START_ANIM);
            } else if (section.sectionType != AbilitySection.AbilitySectionType.ACTIVE) {
                this.playAnimation(HEAL_END_ANIM);
            }
        }

        @Override
        public void tickUsing() {
            super.tickUsing();
            if (((EntityUmvuthana)this.getUser()).getTarget() != null) {
                ((EntityUmvuthana)this.getUser()).getLookControl().setLookAt((Entity)((EntityUmvuthana)this.getUser()).getTarget(), (float)((EntityUmvuthana)this.getUser()).getMaxHeadYRot(), (float)((EntityUmvuthana)this.getUser()).getMaxHeadXRot());
                ((EntityUmvuthana)this.getUser()).lookAt((Entity)((EntityUmvuthana)this.getUser()).getTarget(), ((EntityUmvuthana)this.getUser()).getMaxHeadYRot(), ((EntityUmvuthana)this.getUser()).getMaxHeadXRot());
            }
            if (this.getTicksInUse() == 6) {
                ((EntityUmvuthana)this.getUser()).playSound((SoundEvent)((DeferredHolder)MMSounds.ENTITY_UMVUTHANA_HEAL_START.get(this.rand.nextInt(3))).get(), 4.0f, 1.0f);
                MMCommon.PROXY.playSunblockSound((LivingEntity)this.getUser());
            }
            if (this.getTicksInUse() >= 6) {
                EffectHandler.addOrCombineEffect(this.getUser(), (Holder<MobEffect>)MobEffects.GLOWING, 5, 0, false, false);
            }
            if (((EntityUmvuthana)this.getUser()).level().isClientSide && this.getTicksInUse() == 5 && ((EntityUmvuthana)this.getUser()).headPos != null && ((EntityUmvuthana)this.getUser()).headPos.length >= 1) {
                ((EntityUmvuthana)this.getUser()).headPos[0] = ((EntityUmvuthana)this.getUser()).position().add(0.0, (double)((EntityUmvuthana)this.getUser()).getEyeHeight(), 0.0);
            }
            if (this.getTicksInUse() == 12) {
                this.playAnimation(HEAL_LOOP_ANIM);
            }
            if (this.getCurrentSection().sectionType == AbilitySection.AbilitySectionType.ACTIVE) {
                this.spawnHealParticles();
                ((EntityUmvuthana)this.getUser()).sunBlockTarget();
                if (!this.getLevel().isClientSide() && ((EntityUmvuthana)this.getUser()).getTarget() == null) {
                    AbilityHandler.INSTANCE.sendJumpToSectionMessage((EntityUmvuthana)this.getUser(), this.getAbilityType(), 2);
                }
            }
        }

        public void spawnHealParticles() {
            if (((EntityUmvuthana)this.getUser()).getTarget() != null) {
                ((EntityUmvuthana)this.getUser()).setHealPos(((EntityUmvuthana)this.getUser()).getTarget().position().add(new Vec3(0.0, (double)(((EntityUmvuthana)this.getUser()).getTarget().getBbHeight() / 2.0f), 0.0)));
            }
            if (((EntityUmvuthana)this.getUser()).level().isClientSide && ((EntityUmvuthana)this.getUser()).barakoPos != null) {
                ((EntityUmvuthana)this.getUser()).barakoPos[0] = ((EntityUmvuthana)this.getUser()).getHealPos();
                if (((EntityUmvuthana)this.getUser()).headPos != null && ((EntityUmvuthana)this.getUser()).headPos[0] != null) {
                    double dist = Math.max(((EntityUmvuthana)this.getUser()).barakoPos[0].distanceTo(((EntityUmvuthana)this.getUser()).headPos[0]), 0.01);
                    double radius = 0.5;
                    double yaw = (double)(this.rand.nextFloat() * 2.0f) * Math.PI;
                    double pitch = (double)(this.rand.nextFloat() * 2.0f) * Math.PI;
                    double ox = radius * Math.sin(yaw) * Math.sin(pitch);
                    double oy = radius * Math.cos(pitch);
                    double oz = radius * Math.cos(yaw) * Math.sin(pitch);
                    if (this.getTicksInUse() % 5 == 0) {
                        AdvancedParticleBase.spawnParticle(((EntityUmvuthana)this.getUser()).level(), ParticleHandler.ARROW_HEAD, ((EntityUmvuthana)this.getUser()).headPos[0].x(), ((EntityUmvuthana)this.getUser()).headPos[0].y(), ((EntityUmvuthana)this.getUser()).headPos[0].z(), 0.0, 0.0, 0.0, false, 0.0, 0.0, 0.0, 0.0, 3.5, 0.95, 0.9, 0.35, 0.75, 1.0, Math.min(2.0 * dist, 60.0), true, false, new ParticleComponent[]{new ParticleComponent.Attractor(((EntityUmvuthana)this.getUser()).barakoPos, 0.5f, 0.2f, ParticleComponent.Attractor.EnumAttractorBehavior.LINEAR), new RibbonComponent((Holder<ParticleType<?>>)ParticleHandler.RIBBON_FLAT, 10, 0.0, 0.0, 0.0, 0.12f, 0.95, 0.9, 0.35, 0.75, true, true, new ParticleComponent[]{new RibbonComponent.PropertyOverLength(RibbonComponent.PropertyOverLength.EnumRibbonProperty.SCALE, ParticleComponent.KeyTrack.startAndEnd(1.0f, 0.0f))}), new ParticleComponent.PropertyControl(ParticleComponent.PropertyControl.EnumParticleProperty.POS_X, new ParticleComponent.Oscillator(0.0f, (float)ox, (float)(1.0 * dist), 2.5f), true), new ParticleComponent.PropertyControl(ParticleComponent.PropertyControl.EnumParticleProperty.POS_Y, new ParticleComponent.Oscillator(0.0f, (float)oy, (float)(1.0 * dist), 2.5f), true), new ParticleComponent.PropertyControl(ParticleComponent.PropertyControl.EnumParticleProperty.POS_Z, new ParticleComponent.Oscillator(0.0f, (float)oz, (float)(1.0 * dist), 2.5f), true), new ParticleComponent.FaceMotion(), new ParticleComponent.PropertyControl(ParticleComponent.PropertyControl.EnumParticleProperty.ALPHA, new ParticleComponent.KeyTrack(new float[]{0.0f, 0.0f, 1.0f}, new float[]{0.0f, 0.05f, 0.06f}), false)});
                    }
                    if (this.getTicksInUse() % 5 == 0) {
                        AdvancedParticleBase.spawnParticle(((EntityUmvuthana)this.getUser()).level(), ParticleHandler.RING2, ((EntityUmvuthana)this.getUser()).headPos[0].x(), ((EntityUmvuthana)this.getUser()).headPos[0].y(), ((EntityUmvuthana)this.getUser()).headPos[0].z(), 0.0, 0.0, 0.0, true, 0.0, 0.0, 0.0, 0.0, 1.5, 1.0, 0.8745098114013672, 0.25882354378700256, 1.0, 1.0, 15.0, true, false, new ParticleComponent[]{new ParticleComponent.PropertyControl(ParticleComponent.PropertyControl.EnumParticleProperty.ALPHA, ParticleComponent.KeyTrack.startAndEnd(1.0f, 0.0f), false), new ParticleComponent.PropertyControl(ParticleComponent.PropertyControl.EnumParticleProperty.SCALE, ParticleComponent.KeyTrack.startAndEnd(1.0f, 10.0f), false)});
                    }
                    int spawnFreq = 5;
                    if (this.getTicksInUse() % spawnFreq == 0) {
                        ParticleRibbon.spawnRibbon(((EntityUmvuthana)this.getUser()).level(), ParticleHandler.RIBBON_SQUIGGLE, (int)(0.5 * dist), ((EntityUmvuthana)this.getUser()).headPos[0].x(), ((EntityUmvuthana)this.getUser()).headPos[0].y(), ((EntityUmvuthana)this.getUser()).headPos[0].z(), 0.0, 0.0, 0.0, true, 0.0, 0.0, 0.0, 0.5, 0.95, 0.9, 0.35, 0.75, 1.0, spawnFreq, true, new ParticleComponent[]{new RibbonComponent.BeamPinning(((EntityUmvuthana)this.getUser()).headPos, ((EntityUmvuthana)this.getUser()).barakoPos), new RibbonComponent.PanTexture(0.0f, 1.0f)});
                    }
                }
            }
        }

        @Override
        public boolean damageInterrupts() {
            return false;
        }
    }

    private static class UmvuthanaTeleportAbility
    extends Ability<EntityUmvuthana> {
        private Vec3 teleportStart;
        private static int ACTIVE_DURATION = 7;
        private static final RawAnimation TELEPORT_START_ANIM = RawAnimation.begin().then("teleport_start", Animation.LoopType.PLAY_ONCE);
        private static final RawAnimation TELEPORT_LOOP_ANIM = RawAnimation.begin().thenLoop("teleport_loop");
        private static final RawAnimation TELEPORT_END_ANIM = RawAnimation.begin().then("teleport_end", Animation.LoopType.PLAY_ONCE);

        public UmvuthanaTeleportAbility(AbilityType<EntityUmvuthana, ? extends Ability> abilityType, EntityUmvuthana user) {
            super(abilityType, user, new AbilitySection[]{new AbilitySection.AbilitySectionDuration(AbilitySection.AbilitySectionType.STARTUP, 7), new AbilitySection.AbilitySectionDuration(AbilitySection.AbilitySectionType.ACTIVE, ACTIVE_DURATION), new AbilitySection.AbilitySectionDuration(AbilitySection.AbilitySectionType.RECOVERY, 13)});
        }

        @Override
        protected void beginSection(AbilitySection section) {
            super.beginSection(section);
            if (section.sectionType == AbilitySection.AbilitySectionType.STARTUP) {
                this.playAnimation(TELEPORT_START_ANIM);
            }
            if (section.sectionType == AbilitySection.AbilitySectionType.ACTIVE) {
                this.teleportStart = ((EntityUmvuthana)this.getUser()).position();
                this.playAnimation(TELEPORT_LOOP_ANIM);
            }
            if (section.sectionType == AbilitySection.AbilitySectionType.RECOVERY) {
                this.playAnimation(TELEPORT_END_ANIM);
            }
        }

        @Override
        protected void endSection(AbilitySection section) {
            super.endSection(section);
            if (section.sectionType == AbilitySection.AbilitySectionType.ACTIVE && ((EntityUmvuthana)this.getUser()).teleportDestination != null) {
                ((EntityUmvuthana)this.getUser()).teleportTo(((EntityUmvuthana)this.getUser()).teleportDestination.x(), ((EntityUmvuthana)this.getUser()).teleportDestination.y(), ((EntityUmvuthana)this.getUser()).teleportDestination.z());
                ((EntityUmvuthana)this.getUser()).setDeltaMovement(0.0, 0.0, 0.0);
                ((EntityUmvuthana)this.getUser()).getNavigation().stop();
            }
        }

        @Override
        public void tickUsing() {
            super.tickUsing();
            if (this.getTicksInUse() == 2) {
                ((EntityUmvuthana)this.getUser()).playSound((SoundEvent)((DeferredHolder)MMSounds.ENTITY_UMVUTHANA_TELEPORT.get(this.rand.nextInt(3))).get(), 3.0f, 1.0f);
            }
            if (this.getTicksInUse() == 16) {
                ((EntityUmvuthana)this.getUser()).playSound((SoundEvent)((DeferredHolder)MMSounds.ENTITY_UMVUTHANA_TELEPORT.get(this.rand.nextInt(3))).get(), 3.0f, 1.2f);
            }
            if (this.getCurrentSection().sectionType == AbilitySection.AbilitySectionType.ACTIVE && this.teleportStart != null && ((EntityUmvuthana)this.getUser()).teleportDestination != null) {
                float t = (float)this.getTicksInSection() / (float)ACTIVE_DURATION;
                t = (float)(0.5 - 0.5 * Math.cos((double)t * Math.PI));
                Vec3 newPos = this.teleportStart.add(((EntityUmvuthana)this.getUser()).teleportDestination.subtract(this.teleportStart).scale((double)t));
                ((EntityUmvuthana)this.getUser()).teleportTo(newPos.x(), newPos.y(), newPos.z());
                ((EntityUmvuthana)this.getUser()).getNavigation().stop();
            }
            if (((EntityUmvuthana)this.getUser()).getTarget() != null) {
                ((EntityUmvuthana)this.getUser()).getLookControl().setLookAt((Entity)((EntityUmvuthana)this.getUser()).getTarget(), 30.0f, 30.0f);
            }
            if (((EntityUmvuthana)this.getUser()).level().isClientSide) {
                ((EntityUmvuthana)this.getUser()).myPos[0] = ((EntityUmvuthana)this.getUser()).position().add(0.0, (double)1.2f, 0.0);
                if (this.getTicksInUse() == 5) {
                    ParticleComponent.KeyTrack keyTrack1 = ParticleComponent.KeyTrack.oscillate(0.0f, 2.0f, 24);
                    ParticleComponent.KeyTrack keyTrack2 = new ParticleComponent.KeyTrack(new float[]{0.0f, 18.0f, 18.0f, 0.0f}, new float[]{0.0f, 0.2f, 0.8f, 1.0f});
                    AdvancedParticleBase.spawnParticle(((EntityUmvuthana)this.getUser()).level(), ParticleHandler.SUN, ((EntityUmvuthana)this.getUser()).getX(), ((EntityUmvuthana)this.getUser()).getY(), ((EntityUmvuthana)this.getUser()).getZ(), 0.0, 0.0, 0.0, true, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 1.0, 1.0, 1.0, 1.0, 15.0, true, false, new ParticleComponent[]{new ParticleComponent.PinLocation(((EntityUmvuthana)this.getUser()).myPos), new ParticleComponent.PropertyControl(ParticleComponent.PropertyControl.EnumParticleProperty.SCALE, keyTrack2, false), new ParticleComponent.PropertyControl(ParticleComponent.PropertyControl.EnumParticleProperty.SCALE, keyTrack1, true), new RibbonComponent((Holder<ParticleType<?>>)ParticleHandler.RIBBON_FLAT, 10, 0.0, 0.0, 0.0, 0.12f, 0.95, 0.9, 0.35, 0.75, true, true, new ParticleComponent[]{new RibbonComponent.PropertyOverLength(RibbonComponent.PropertyOverLength.EnumRibbonProperty.SCALE, ParticleComponent.KeyTrack.startAndEnd(1.0f, 0.0f))})});
                }
                ((EntityUmvuthana)this.getUser()).myPos[0] = ((EntityUmvuthana)this.getUser()).position().add(0.0, (double)1.2f, 0.0);
                if (this.getTicksInUse() == 4 || this.getTicksInUse() == 18) {
                    int num = 5;
                    for (int i = 0; i < num * num; ++i) {
                        Vec3 v = new Vec3((0.3 + 0.15 * (double)this.rand.nextFloat()) * 0.8, 0.0, 0.0);
                        float increment = (float)Math.PI * 2 / (float)num;
                        v = v.yRot(increment * this.rand.nextFloat() + increment * ((float)i / (float)num));
                        v = v.zRot(increment * this.rand.nextFloat() + increment * (float)(i % num));
                        AdvancedParticleBase.spawnParticle(((EntityUmvuthana)this.getUser()).level(), ParticleHandler.PIXEL, ((EntityUmvuthana)this.getUser()).myPos[0].x(), ((EntityUmvuthana)this.getUser()).myPos[0].y(), ((EntityUmvuthana)this.getUser()).myPos[0].z(), v.x(), v.y(), v.z(), true, 0.0, 0.0, 0.0, 0.0, 4.0, 0.98, 0.94, 0.39, 1.0, 0.8, 6.0f + this.rand.nextFloat() * 4.0f, true, false, new ParticleComponent[]{new ParticleComponent.PropertyControl(ParticleComponent.PropertyControl.EnumParticleProperty.SCALE, new ParticleComponent.KeyTrack(new float[]{4.0f, 0.0f}, new float[]{0.8f, 1.0f}), false)});
                    }
                }
            }
        }

        @Override
        public boolean canCancelActiveAbility() {
            return ((EntityUmvuthana)this.getUser()).getActiveAbility() instanceof UmvuthanaHealAbility;
        }
    }

    private static class UmvuthanaHurtAbility
    extends HurtAbility<EntityUmvuthana> {
        private static final RawAnimation HURT_RIGHT_AGGRESSIVE_ANIM = RawAnimation.begin().thenPlay("hurt_right_aggressive");
        private static final RawAnimation HURT_LEFT_AGGRESSIVE_ANIM = RawAnimation.begin().thenPlay("hurt_left_aggressive");
        private static final RawAnimation HURT_RIGHT_NEUTRAL_ANIM = RawAnimation.begin().thenPlay("hurt_right_neutral");
        private static final RawAnimation HURT_LEFT_NEUTRAL_ANIM = RawAnimation.begin().thenPlay("hurt_left_neutral");

        public UmvuthanaHurtAbility(AbilityType<EntityUmvuthana, UmvuthanaHurtAbility> abilityType, EntityUmvuthana user) {
            super(abilityType, user, RawAnimation.begin(), 12);
        }

        @Override
        public RawAnimation getAnimation() {
            if (((EntityUmvuthana)this.getUser()).isAggressive()) {
                if (((EntityUmvuthana)this.getUser()).random.nextBoolean()) {
                    return HURT_RIGHT_AGGRESSIVE_ANIM;
                }
                return HURT_LEFT_AGGRESSIVE_ANIM;
            }
            if (((EntityUmvuthana)this.getUser()).random.nextBoolean()) {
                return HURT_RIGHT_NEUTRAL_ANIM;
            }
            return HURT_LEFT_NEUTRAL_ANIM;
        }
    }

    private static class UmvuthanaBlockCounterAbility
    extends MeleeAttackAbility<EntityUmvuthana> {
        public UmvuthanaBlockCounterAbility(AbilityType<EntityUmvuthana, UmvuthanaBlockCounterAbility> abilityType, EntityUmvuthana user) {
            super(abilityType, user, new RawAnimation[]{RawAnimation.begin().thenPlay("block_counter")}, null, null, 3.0f, 2.2f, 1.2f, 7, 11, false);
        }

        @Override
        public void start() {
            super.start();
            ((EntityUmvuthana)this.getUser()).setInvulnerable(true);
        }

        @Override
        public void end() {
            super.end();
            ((EntityUmvuthana)this.getUser()).setInvulnerable(false);
        }

        @Override
        public void tickUsing() {
            super.tickUsing();
            if (this.getTicksInUse() == 5) {
                float distToTarget = 1.0f;
                if (((EntityUmvuthana)this.getUser()).getTarget() != null) {
                    distToTarget = Mth.clamp((float)(((EntityUmvuthana)this.getUser()).distanceTo((Entity)((EntityUmvuthana)this.getUser()).getTarget()) / 2.0f - 1.0f), (float)0.0f, (float)1.0f);
                }
                ((EntityUmvuthana)this.getUser()).setDeltaMovement(((EntityUmvuthana)this.getUser()).getDeltaMovement().add(((EntityUmvuthana)this.getUser()).getForward().normalize().scale(1.6 * (double)distToTarget)));
            }
            if (this.getTicksInUse() == 0) {
                ((EntityUmvuthana)this.getUser()).playSound((SoundEvent)MMSounds.ENTITY_UMVUTHANA_ATTACK_BIG.get(), 1.0f, this.rand.nextFloat(0.9f, 1.1f));
            }
        }

        @Override
        public boolean canCancelActiveAbility() {
            return super.canCancelActiveAbility() || ((EntityUmvuthana)this.getUser()).getActiveAbility() instanceof BlockAbility || ((EntityUmvuthana)this.getUser()).getActiveAbility() instanceof HurtAbility;
        }
    }

    private static class UmvuthanaAttackAbility
    extends MeleeAttackAbility<EntityUmvuthana> {
        public UmvuthanaAttackAbility(AbilityType<EntityUmvuthana, ? extends MeleeAttackAbility<EntityUmvuthana>> abilityType, EntityUmvuthana user) {
            super(abilityType, user, new RawAnimation[]{RawAnimation.begin().thenPlay("attack_slash_left"), RawAnimation.begin().thenPlay("attack_slash_right")}, null, null, 1.0f, 3.0f, 1.0f, 13, 9, true);
        }

        @Override
        public void tickUsing() {
            super.tickUsing();
            if (this.getTicksInUse() == 5) {
                ((EntityUmvuthana)this.getUser()).setDeltaMovement(((EntityUmvuthana)this.getUser()).getDeltaMovement().add(((EntityUmvuthana)this.getUser()).getForward().normalize().scale(0.5)));
            }
            if (this.getTicksInUse() == 1) {
                int i = this.rand.nextInt(MMSounds.ENTITY_UMVUTHANA_ATTACK.size());
                ((EntityUmvuthana)this.getUser()).playSound((SoundEvent)((DeferredHolder)MMSounds.ENTITY_UMVUTHANA_ATTACK.get(i)).get(), 1.0f, this.rand.nextFloat(0.9f, 1.1f));
            }
        }
    }
}

