/*
 * Decompiled with CFR 0.152.
 */
package com.bobmowzie.mowziesmobs.server.entity.effects.geomancy;

import com.bobmowzie.mowziesmobs.client.particle.ParticleHandler;
import com.bobmowzie.mowziesmobs.client.particle.util.AdvancedParticleBase;
import com.bobmowzie.mowziesmobs.client.particle.util.ParticleComponent;
import com.bobmowzie.mowziesmobs.server.entity.effects.EntityCameraShake;
import com.bobmowzie.mowziesmobs.server.entity.effects.geomancy.EntityGeomancyBase;
import com.bobmowzie.mowziesmobs.server.entity.sculptor.EntitySculptor;
import com.bobmowzie.mowziesmobs.server.sound.MMSounds;
import java.util.HashMap;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public abstract class EntityBoulderBase
extends EntityGeomancyBase {
    public BlockState storedBlock;
    public float animationOffset = 0.0f;
    public EntityGeomancyBase.GeomancyTier boulderSize = EntityGeomancyBase.GeomancyTier.SMALL;
    protected int finishedRisingTick = 4;
    public int risingTick = 0;
    private static final EntityDataAccessor<Integer> RISING_TICK = SynchedEntityData.defineId(EntityBoulderBase.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Boolean> ACTIVE = SynchedEntityData.defineId(EntityBoulderBase.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public static final HashMap<EntityGeomancyBase.GeomancyTier, EntityDimensions> SIZE_MAP = new HashMap();

    public EntityBoulderBase(EntityType<? extends EntityBoulderBase> type, Level world) {
        super(type, world);
        this.animationOffset = this.random.nextFloat() * 8.0f;
        this.setTier(EntityGeomancyBase.GeomancyTier.SMALL);
        this.setBoundingBox(this.makeBoundingBox());
    }

    public EntityBoulderBase(EntityType<? extends EntityBoulderBase> type, Level world, LivingEntity caster, BlockState blockState, BlockPos pos, EntityGeomancyBase.GeomancyTier tier) {
        super(type, world, caster, blockState, pos);
        this.animationOffset = this.random.nextFloat() * 8.0f;
        this.setTier(tier);
        this.setSizeParams();
        this.setBoundingBox(this.makeBoundingBox());
    }

    @Override
    public boolean canBeCollidedWith() {
        return this.isActive();
    }

    public boolean checkCanSpawn() {
        if (!this.level().getEntitiesOfClass(EntityBoulderBase.class, this.getBoundingBox().deflate(0.01)).isEmpty()) {
            return false;
        }
        return this.level().noCollision((Entity)this, this.getBoundingBox().deflate(0.01));
    }

    public void setSizeParams() {
        EntityGeomancyBase.GeomancyTier size = this.getTier();
        if (size == EntityGeomancyBase.GeomancyTier.MEDIUM) {
            this.finishedRisingTick = 8;
        } else if (size == EntityGeomancyBase.GeomancyTier.LARGE) {
            this.finishedRisingTick = 12;
        } else if (size == EntityGeomancyBase.GeomancyTier.HUGE) {
            this.finishedRisingTick = 90;
        }
    }

    @NotNull
    protected AABB makeBoundingBox() {
        EntityDimensions dim;
        this.dimensions = dim = SIZE_MAP.get((Object)this.getTier());
        return dim.makeBoundingBox(this.position());
    }

    public void activate() {
        this.getEntityData().set(ACTIVE, (Object)true);
    }

    public boolean isActive() {
        return (Boolean)this.getEntityData().get(ACTIVE);
    }

    public boolean isFinishedRising() {
        return this.risingTick >= this.finishedRisingTick;
    }

    protected void doPopupEntities() {
        List popUpEntities = this.level().getEntities((Entity)this, this.getBoundingBox());
        for (Entity entity : popUpEntities) {
            if (!entity.isPickable() || entity instanceof EntityBoulderBase || this.getCaster() instanceof EntitySculptor && this.getCaster() == entity) continue;
            if (this.boulderSize != EntityGeomancyBase.GeomancyTier.HUGE) {
                entity.move(MoverType.SHULKER_BOX, new Vec3(0.0, 2.0 * Math.pow(2.0, (double)(-this.risingTick) * (0.6 - 0.1 * (double)this.boulderSize.ordinal())), 0.0));
                continue;
            }
            entity.move(MoverType.SHULKER_BOX, new Vec3(0.0, (double)0.6f, 0.0));
        }
    }

    @Override
    public void tick() {
        int dripNumber;
        if (this.firstTick) {
            this.setSizeParams();
            this.boulderSize = this.getTier();
            this.risingTick = this.getRisingTickData();
        }
        if (this.storedBlock == null) {
            this.storedBlock = this.getBlock();
        }
        super.tick();
        this.setBoundingBox(this.makeBoundingBox());
        this.move(MoverType.SELF, this.getDeltaMovement());
        if (this.boulderSize == EntityGeomancyBase.GeomancyTier.HUGE && this.risingTick < this.finishedRisingTick) {
            float f = this.getBbWidth() / 2.0f;
            AABB aabb = new AABB(this.getX() - (double)f, this.getY() - 0.5, this.getZ() - (double)f, this.getX() + (double)f, this.getY() + (double)Math.min((float)this.risingTick / (float)this.finishedRisingTick * 3.5f, 3.5f), this.getZ() + (double)f);
            this.setBoundingBox(aabb);
        }
        if (this.isActive() && this.risingTick < this.finishedRisingTick + 2) {
            this.doPopupEntities();
        }
        if (this.risingTick == 1) {
            int i = 0;
            while ((float)i < 20.0f * this.getBbWidth()) {
                Vec3 particlePos = new Vec3((double)this.random.nextFloat() * 1.3 * (double)this.getBbWidth(), 0.0, 0.0);
                particlePos = particlePos.yRot((float)((double)(this.random.nextFloat() * 2.0f) * Math.PI));
                this.level().addParticle((ParticleOptions)new BlockParticleOption(ParticleTypes.BLOCK, this.storedBlock), this.getX() + particlePos.x, this.getY() - 1.0, this.getZ() + particlePos.z, particlePos.x, 2.0, particlePos.z);
                ++i;
            }
            if (this.boulderSize == EntityGeomancyBase.GeomancyTier.SMALL) {
                this.playSound((SoundEvent)MMSounds.EFFECT_GEOMANCY_SMALL_CRASH.get(), 1.5f, 1.3f);
                this.playSound((SoundEvent)MMSounds.EFFECT_GEOMANCY_MAGIC_SMALL.get(), 1.5f, 1.0f);
            } else if (this.boulderSize == EntityGeomancyBase.GeomancyTier.MEDIUM) {
                this.playSound((SoundEvent)MMSounds.EFFECT_GEOMANCY_HIT_MEDIUM_2.get(), 1.5f, 1.5f);
                this.playSound((SoundEvent)MMSounds.EFFECT_GEOMANCY_MAGIC_SMALL.get(), 1.5f, 0.8f);
            } else if (this.boulderSize == EntityGeomancyBase.GeomancyTier.LARGE) {
                this.playSound((SoundEvent)MMSounds.EFFECT_GEOMANCY_HIT_MEDIUM_1.get(), 1.5f, 0.9f);
                this.playSound((SoundEvent)MMSounds.EFFECT_GEOMANCY_MAGIC_BIG.get(), 1.5f, 1.5f);
                EntityCameraShake.cameraShake(this.level(), this.position(), 10.0f, 0.05f, 0, 20);
            } else if (this.boulderSize == EntityGeomancyBase.GeomancyTier.HUGE) {
                this.playSound((SoundEvent)MMSounds.EFFECT_GEOMANCY_MAGIC_BIG.get(), 2.0f, 0.5f);
                this.playSound((SoundEvent)MMSounds.EFFECT_GEOMANCY_RUMBLE_1.get(), 2.0f, 0.8f);
                EntityCameraShake.cameraShake(this.level(), this.position(), 15.0f, 0.05f, 50, 30);
            }
            if (this.level().isClientSide) {
                AdvancedParticleBase.spawnAlwaysVisibleParticle(this.level(), ParticleHandler.RING2, 64.0, this.getX(), this.getY() - (double)0.9f, this.getZ(), 0.0, 0.0, 0.0, false, 0.0, 1.5707963267948966, 0.0, 0.0, 3.5, 0.83f, 1.0, 0.39f, 1.0, 1.0, (int)(5.0f + 2.0f * this.getBbWidth()), true, true, new ParticleComponent[]{new ParticleComponent.PropertyControl(ParticleComponent.PropertyControl.EnumParticleProperty.ALPHA, ParticleComponent.KeyTrack.startAndEnd(1.0f, 0.0f), false), new ParticleComponent.PropertyControl(ParticleComponent.PropertyControl.EnumParticleProperty.SCALE, ParticleComponent.KeyTrack.startAndEnd(0.0f, (1.0f + 0.5f * this.getBbWidth()) * 10.0f), false)});
            }
        }
        if (this.risingTick == 30 && this.boulderSize == EntityGeomancyBase.GeomancyTier.HUGE) {
            this.playSound((SoundEvent)MMSounds.EFFECT_GEOMANCY_RUMBLE_2.get(), 2.0f, 0.7f);
        }
        int dripTick = this.risingTick - 2;
        if (this.boulderSize == EntityGeomancyBase.GeomancyTier.HUGE) {
            dripTick -= 20;
        }
        if ((dripNumber = (int)((double)(this.getBbWidth() * 6.0f) * Math.pow(1.03 + 0.04 / (double)this.getBbWidth(), -dripTick))) >= 1 && dripTick > 0) {
            dripNumber = (int)((float)dripNumber * this.random.nextFloat());
            for (int i = 0; i < dripNumber; ++i) {
                Vec3 particlePos = new Vec3((double)this.random.nextFloat() * 0.6 * (double)this.getBbWidth(), 0.0, 0.0);
                particlePos = particlePos.yRot((float)((double)(this.random.nextFloat() * 2.0f) * Math.PI));
                float offsetY = this.boulderSize == EntityGeomancyBase.GeomancyTier.HUGE && this.risingTick < this.finishedRisingTick ? this.random.nextFloat() * (this.getBbHeight() - 1.0f) - this.getBbHeight() * (float)(this.finishedRisingTick - this.risingTick) / (float)this.finishedRisingTick : this.random.nextFloat() * (this.getBbHeight() - 1.0f);
                this.level().addParticle((ParticleOptions)new BlockParticleOption(ParticleTypes.BLOCK, this.storedBlock), this.getX() + particlePos.x, this.getY() + (double)offsetY, this.getZ() + particlePos.z, 0.0, -1.0, 0.0);
            }
        }
        if (this.isActive()) {
            ++this.risingTick;
        }
    }

    @Override
    public void explode() {
        if (this.isActive()) {
            super.explode();
        } else {
            this.discard();
        }
    }

    public void remove(Entity.RemovalReason p_146834_) {
        super.remove(p_146834_);
        LivingEntity livingEntity = this.getCaster();
        if (livingEntity instanceof EntitySculptor) {
            EntitySculptor sculptor = (EntitySculptor)livingEntity;
            sculptor.boulders.remove(this);
        }
    }

    public int getRisingTickData() {
        return (Integer)this.getEntityData().get(RISING_TICK);
    }

    public void setRisingTickData(int risingTick) {
        this.getEntityData().set(RISING_TICK, (Object)risingTick);
    }

    @Override
    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putInt("risingTick", this.risingTick);
    }

    @Override
    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        this.setRisingTickData(compound.getInt("risingTick"));
    }

    @Override
    protected void defineSynchedData(// Could not load outer class - annotation placement on inner may be incorrect
    @NotNull SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(RISING_TICK, (Object)0);
        builder.define(ACTIVE, (Object)false);
    }

    static {
        SIZE_MAP.put(EntityGeomancyBase.GeomancyTier.NONE, EntityDimensions.scalable((float)1.0f, (float)1.0f));
        SIZE_MAP.put(EntityGeomancyBase.GeomancyTier.SMALL, EntityDimensions.scalable((float)1.0f, (float)1.0f));
        SIZE_MAP.put(EntityGeomancyBase.GeomancyTier.MEDIUM, EntityDimensions.scalable((float)2.0f, (float)1.5f));
        SIZE_MAP.put(EntityGeomancyBase.GeomancyTier.LARGE, EntityDimensions.scalable((float)3.0f, (float)2.5f));
        SIZE_MAP.put(EntityGeomancyBase.GeomancyTier.HUGE, EntityDimensions.scalable((float)4.0f, (float)3.5f));
    }
}

