/*
 * Decompiled with CFR 0.152.
 */
package com.bobmowzie.mowziesmobs.server.entity.effects;

import com.bobmowzie.mowziesmobs.MMCommon;
import com.bobmowzie.mowziesmobs.client.particle.ParticleCloud;
import com.bobmowzie.mowziesmobs.client.particle.ParticleRing;
import com.bobmowzie.mowziesmobs.client.particle.ParticleSnowFlake;
import com.bobmowzie.mowziesmobs.server.ability.AbilityHandler;
import com.bobmowzie.mowziesmobs.server.capability.AbilityData;
import com.bobmowzie.mowziesmobs.server.capability.DataHandler;
import com.bobmowzie.mowziesmobs.server.config.ConfigHandler;
import com.bobmowzie.mowziesmobs.server.entity.effects.EntityBlockSwapper;
import com.bobmowzie.mowziesmobs.server.entity.effects.EntityMagicEffect;
import com.bobmowzie.mowziesmobs.server.entity.frostmaw.EntityFrostmaw;
import com.bobmowzie.mowziesmobs.server.sound.MMSounds;
import java.util.List;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.boss.enderdragon.EnderDragon;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;

public class EntityIceBreath
extends EntityMagicEffect {
    private static final int RANGE = 10;
    private static final int ARC = 45;
    private static final int DAMAGE_PER_HIT = 1;

    public EntityIceBreath(EntityType<? extends EntityIceBreath> type, Level world) {
        super(type, world);
    }

    public EntityIceBreath(EntityType<? extends EntityIceBreath> type, Level world, LivingEntity caster) {
        super(type, world, caster);
    }

    @Override
    public void tick() {
        LivingEntity livingEntity;
        super.tick();
        if (this.tickCount == 1 && this.level().isClientSide) {
            MMCommon.PROXY.playIceBreathSound(this);
        }
        if (this.tickCount > 1 && this.getCaster() == null) {
            this.discard();
        }
        if (this.getCaster() != null && !this.getCaster().isAlive()) {
            this.discard();
        }
        if (this.tickCount == 1) {
            this.playSound((SoundEvent)MMSounds.ENTITY_FROSTMAW_ICEBREATH_START.get(), 1.0f, 0.6f);
        }
        if ((livingEntity = this.getCaster()) instanceof Player) {
            Player player = (Player)livingEntity;
            this.absMoveTo(player.getX(), player.getEyeY() - 0.5, player.getZ(), player.getYRot(), player.getXRot());
            AbilityData abilityData = DataHandler.getData((Entity)player, DataHandler.ABILITY_DATA);
            if (!abilityData.getAbilityFromType(AbilityHandler.ICE_BREATH_ABILITY).isUsing()) {
                this.discard();
            }
        }
        float yaw = (float)Math.toRadians(-this.getYRot());
        float pitch = (float)Math.toRadians(-this.getXRot());
        float spread = 0.25f;
        float speed = 0.56f;
        float xComp = (float)(Math.sin(yaw) * Math.cos(pitch));
        float yComp = (float)Math.sin(pitch);
        float zComp = (float)(Math.cos(yaw) * Math.cos(pitch));
        if (this.level().isClientSide) {
            double zSpeed;
            double ySpeed;
            double xSpeed;
            int i;
            boolean overrideLimiter;
            Camera camera = Minecraft.getInstance().gameRenderer.getMainCamera();
            boolean bl = overrideLimiter = camera.getPosition().distanceToSqr(this.getX(), this.getY(), this.getZ()) < 4096.0;
            if (this.tickCount % 8 == 0) {
                this.level().addAlwaysVisibleParticle((ParticleOptions)new ParticleRing.Data(yaw, -pitch, 40.0f, 1.0f, 1.0f, 1.0f, 1.0f, (int)(110.0f * spread), false, ParticleRing.EnumRingBehavior.GROW), overrideLimiter, this.getX(), this.getY(), this.getZ(), (double)(0.5f * xComp), (double)(0.5f * yComp), (double)(0.5f * zComp));
            }
            for (i = 0; i < 6; ++i) {
                xSpeed = speed * 1.0f * xComp;
                ySpeed = speed * 1.0f * yComp;
                zSpeed = speed * 1.0f * zComp;
                this.level().addParticle((ParticleOptions)new ParticleSnowFlake.Data(37.0f, true), this.getX(), this.getY(), this.getZ(), xSpeed, ySpeed, zSpeed);
            }
            for (i = 0; i < 5; ++i) {
                xSpeed = (double)(speed * xComp) + (double)spread * 0.7 * (double)(this.random.nextFloat() * 2.0f - 1.0f) * Math.sqrt(1.0f - xComp * xComp);
                ySpeed = (double)(speed * yComp) + (double)spread * 0.7 * (double)(this.random.nextFloat() * 2.0f - 1.0f) * Math.sqrt(1.0f - yComp * yComp);
                zSpeed = (double)(speed * zComp) + (double)spread * 0.7 * (double)(this.random.nextFloat() * 2.0f - 1.0f) * Math.sqrt(1.0f - zComp * zComp);
                float value = this.random.nextFloat() * 0.15f;
                this.level().addAlwaysVisibleParticle((ParticleOptions)new ParticleCloud.Data(0.75f + value, 0.75f + value, 1.0f, 10.0f + this.random.nextFloat() * 20.0f, 40, ParticleCloud.EnumCloudBehavior.GROW, 1.0f), overrideLimiter, this.getX(), this.getY(), this.getZ(), xSpeed, ySpeed, zSpeed);
            }
        }
        if (this.tickCount > 10) {
            this.hitEntities();
        }
        if (this.tickCount > 10) {
            this.freezeBlocks();
        }
        if (this.tickCount > 65 && !(this.getCaster() instanceof Player)) {
            this.discard();
        }
    }

    public void hitEntities() {
        List<Entity> entitiesHit = this.getEntityLivingBaseNearby(10.0, 10.0, 10.0, 10.0);
        float damage = 1.0f;
        if (this.getCaster() instanceof EntityFrostmaw) {
            damage = (float)((double)damage * (Double)ConfigHandler.COMMON.MOBS.FROSTMAW.combatConfig.attackMultiplier.get());
        }
        if (this.getCaster() instanceof Player) {
            damage = (float)((double)damage * (Double)ConfigHandler.COMMON.TOOLS_AND_ABILITIES.ICE_CRYSTAL.attackMultiplier.get());
        }
        for (Entity entityHit : entitiesHit) {
            boolean frostmawCloseCheck;
            if (entityHit instanceof ItemEntity || entityHit == this.getCaster() || entityHit instanceof ItemEntity || entityHit.getType().is(EntityTypeTags.FREEZE_IMMUNE_ENTITY_TYPES) || entityHit instanceof EnderDragon) continue;
            float entityHitYaw = (float)((Math.atan2(entityHit.getZ() - this.getZ(), entityHit.getX() - this.getX()) * 57.29577951308232 - 90.0) % 360.0);
            float entityAttackingYaw = this.getYRot() % 360.0f;
            if (entityHitYaw < 0.0f) {
                entityHitYaw += 360.0f;
            }
            if (entityAttackingYaw < 0.0f) {
                entityAttackingYaw += 360.0f;
            }
            float entityRelativeYaw = entityHitYaw - entityAttackingYaw;
            float xzDistance = (float)Math.sqrt((entityHit.getZ() - this.getZ()) * (entityHit.getZ() - this.getZ()) + (entityHit.getX() - this.getX()) * (entityHit.getX() - this.getX()));
            double hitY = entityHit.getY() + (double)entityHit.getBbHeight() / 2.0;
            float entityHitPitch = (float)(Math.atan2(hitY - this.getY(), xzDistance) * 57.29577951308232 % 360.0);
            float entityAttackingPitch = -this.getXRot() % 360.0f;
            if (entityHitPitch < 0.0f) {
                entityHitPitch += 360.0f;
            }
            if (entityAttackingPitch < 0.0f) {
                entityAttackingPitch += 360.0f;
            }
            float entityRelativePitch = entityHitPitch - entityAttackingPitch;
            float entityHitDistance = (float)Math.sqrt((entityHit.getZ() - this.getZ()) * (entityHit.getZ() - this.getZ()) + (entityHit.getX() - this.getX()) * (entityHit.getX() - this.getX()) + (hitY - this.getY()) * (hitY - this.getY()));
            boolean inRange = entityHitDistance <= 10.0f;
            boolean yawCheck = entityRelativeYaw <= 22.5f && entityRelativeYaw >= -22.5f || entityRelativeYaw >= 337.5f || entityRelativeYaw <= -337.5f;
            boolean pitchCheck = entityRelativePitch <= 22.5f && entityRelativePitch >= -22.5f || entityRelativePitch >= 337.5f || entityRelativePitch <= -337.5f;
            boolean bl = frostmawCloseCheck = this.getCaster() instanceof EntityFrostmaw && entityHitDistance <= 2.0f;
            if ((!inRange || !yawCheck || !pitchCheck) && !frostmawCloseCheck || !this.raytraceCheckEntity(entityHit) || !entityHit.hurt(this.damageSources().freeze(), damage) || !(entityHit instanceof LivingEntity)) continue;
            entityHit.setDeltaMovement(entityHit.getDeltaMovement().multiply(0.25, 1.0, 0.25));
            DataHandler.getData(entityHit, DataHandler.FROZEN_DATA).addFreezeProgress((LivingEntity)entityHit, 0.23f);
        }
    }

    public void freezeBlocks() {
        int checkDist = 10;
        for (int i = (int)this.getX() - checkDist; i < (int)this.getX() + checkDist; ++i) {
            for (int j = (int)this.getY() - checkDist; j < (int)this.getY() + checkDist; ++j) {
                for (int k = (int)this.getZ() - checkDist; k < (int)this.getZ() + checkDist; ++k) {
                    boolean pitchCheck;
                    BlockPos pos = new BlockPos(i, j, k);
                    BlockState blockState = this.level().getBlockState(pos);
                    BlockState blockStateAbove = this.level().getBlockState(pos.above());
                    if (blockState.getBlock() != Blocks.WATER || blockStateAbove.getBlock() != Blocks.AIR) continue;
                    float blockHitYaw = (float)((Math.atan2((double)pos.getZ() - this.getZ(), (double)pos.getX() - this.getX()) * 57.29577951308232 - 90.0) % 360.0);
                    float entityAttackingYaw = this.getYRot() % 360.0f;
                    if (blockHitYaw < 0.0f) {
                        blockHitYaw += 360.0f;
                    }
                    if (entityAttackingYaw < 0.0f) {
                        entityAttackingYaw += 360.0f;
                    }
                    float blockRelativeYaw = blockHitYaw - entityAttackingYaw;
                    float xzDistance = (float)Math.sqrt(((double)pos.getZ() - this.getZ()) * ((double)pos.getZ() - this.getZ()) + ((double)pos.getX() - this.getX()) * ((double)pos.getX() - this.getX()));
                    float blockHitPitch = (float)(Math.atan2((double)pos.getY() - this.getY(), xzDistance) * 57.29577951308232 % 360.0);
                    float entityAttackingPitch = -this.getXRot() % 360.0f;
                    if (blockHitPitch < 0.0f) {
                        blockHitPitch += 360.0f;
                    }
                    if (entityAttackingPitch < 0.0f) {
                        entityAttackingPitch += 360.0f;
                    }
                    float blockRelativePitch = blockHitPitch - entityAttackingPitch;
                    float blockHitDistance = (float)Math.sqrt(((double)pos.getZ() - this.getZ()) * ((double)pos.getZ() - this.getZ()) + ((double)pos.getX() - this.getX()) * ((double)pos.getX() - this.getX()) + ((double)pos.getY() - this.getY()) * ((double)pos.getY() - this.getY()));
                    boolean inRange = blockHitDistance <= 10.0f;
                    boolean yawCheck = blockRelativeYaw <= 22.5f && blockRelativeYaw >= -22.5f || blockRelativeYaw >= 337.5f || blockRelativeYaw <= -337.5f;
                    boolean bl = pitchCheck = blockRelativePitch <= 22.5f && blockRelativePitch >= -22.5f || blockRelativePitch >= 337.5f || blockRelativePitch <= -337.5f;
                    if (!inRange || !yawCheck || !pitchCheck) continue;
                    EntityBlockSwapper.swapBlock(this.level(), pos, Blocks.ICE.defaultBlockState(), 140, false, false);
                }
            }
        }
    }

    public List<Entity> getEntityLivingBaseNearby(double distanceX, double distanceY, double distanceZ, double radius) {
        return this.getEntitiesNearby(Entity.class, distanceX, distanceY, distanceZ, radius);
    }

    public <T extends Entity> List<T> getEntitiesNearby(Class<T> entityClass, double dX, double dY, double dZ, double r) {
        return this.level().getEntitiesOfClass(entityClass, this.getBoundingBox().inflate(dX, dY, dZ), e -> e != this && (double)this.distanceTo((Entity)e) <= r + (double)(e.getBbWidth() / 2.0f) && e.getY() <= this.getY() + dY);
    }
}

