/*
 * Decompiled with CFR 0.152.
 */
package com.bobmowzie.mowziesmobs.server.entity.effects;

import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

public class EntityFallingBlock
extends Entity {
    public static float GRAVITY = 0.1f;
    public double prevMotionX;
    public double prevMotionY;
    public double prevMotionZ;
    private static final EntityDataAccessor<BlockState> BLOCK_STATE = SynchedEntityData.defineId(EntityFallingBlock.class, (EntityDataSerializer)EntityDataSerializers.BLOCK_STATE);
    private static final EntityDataAccessor<Integer> DURATION = SynchedEntityData.defineId(EntityFallingBlock.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Integer> TICKS_EXISTED = SynchedEntityData.defineId(EntityFallingBlock.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<String> MODE = SynchedEntityData.defineId(EntityFallingBlock.class, (EntityDataSerializer)EntityDataSerializers.STRING);
    private static final EntityDataAccessor<Float> ANIM_V_Y = SynchedEntityData.defineId(EntityFallingBlock.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    public float animY = 0.0f;
    public float prevAnimY = 0.0f;

    public EntityFallingBlock(EntityType<?> entityTypeIn, Level worldIn) {
        super(entityTypeIn, worldIn);
        this.setBlock(Blocks.DIRT.defaultBlockState());
        this.setDuration(70);
    }

    public EntityFallingBlock(EntityType<?> entityTypeIn, Level worldIn, int duration, BlockState blockState) {
        super(entityTypeIn, worldIn);
        this.setBlock(blockState);
        this.setDuration(duration);
    }

    public EntityFallingBlock(EntityType<?> entityTypeIn, Level worldIn, BlockState blockState, float vy) {
        super(entityTypeIn, worldIn);
        this.setBlock(blockState);
        this.setMode(EnumFallingBlockMode.POPUP_ANIM);
        this.setAnimVY(vy);
    }

    public void onAddedToLevel() {
        if (this.getDeltaMovement().x() > 0.0 || this.getDeltaMovement().z() > 0.0) {
            this.setYRot((float)(57.29577951308232 * Math.atan2(this.getDeltaMovement().x(), this.getDeltaMovement().z())));
        }
        this.setXRot(this.getXRot() + this.random.nextFloat() * 360.0f);
        super.onAddedToLevel();
    }

    public void tick() {
        if (this.getMode() == EnumFallingBlockMode.POPUP_ANIM) {
            this.setDeltaMovement(0.0, 0.0, 0.0);
        }
        this.prevMotionX = this.getDeltaMovement().x;
        this.prevMotionY = this.getDeltaMovement().y;
        this.prevMotionZ = this.getDeltaMovement().z;
        super.tick();
        if (this.getMode() == EnumFallingBlockMode.MOBILE) {
            this.setDeltaMovement(this.getDeltaMovement().subtract(0.0, (double)GRAVITY, 0.0));
            if (this.onGround()) {
                this.setDeltaMovement(this.getDeltaMovement().scale(0.7));
            } else {
                this.setXRot(this.getXRot() + 15.0f);
            }
            this.move(MoverType.SELF, this.getDeltaMovement());
            if (this.tickCount > this.getDuration()) {
                this.discard();
            }
        } else {
            float animVY = this.getAnimVY();
            this.prevAnimY = this.animY;
            this.animY += animVY;
            this.setAnimVY(animVY - GRAVITY);
            if ((double)this.animY < -0.5) {
                this.discard();
            }
        }
    }

    protected void defineSynchedData(@NotNull SynchedEntityData.Builder builder) {
        builder.define(BLOCK_STATE, (Object)Blocks.DIRT.defaultBlockState());
        builder.define(DURATION, (Object)70);
        builder.define(TICKS_EXISTED, (Object)0);
        builder.define(MODE, (Object)EnumFallingBlockMode.MOBILE.toString());
        builder.define(ANIM_V_Y, (Object)Float.valueOf(1.0f));
    }

    protected void readAdditionalSaveData(CompoundTag compound) {
        Tag blockStateCompound = compound.get("block");
        if (blockStateCompound != null) {
            BlockState blockState = NbtUtils.readBlockState((HolderGetter)this.level().holderLookup(Registries.BLOCK), (CompoundTag)((CompoundTag)blockStateCompound));
            this.setBlock(blockState);
        }
        this.setDuration(compound.getInt("duration"));
        this.tickCount = compound.getInt("ticksExisted");
        this.getEntityData().set(MODE, (Object)compound.getString("mode"));
        this.setAnimVY(compound.getFloat("vy"));
    }

    protected void addAdditionalSaveData(CompoundTag compound) {
        BlockState blockState = this.getBlock();
        if (blockState != null) {
            compound.put("block", (Tag)NbtUtils.writeBlockState((BlockState)blockState));
        }
        compound.putInt("duration", this.getDuration());
        compound.putInt("ticksExisted", this.tickCount);
        compound.putString("mode", (String)this.getEntityData().get(MODE));
        compound.putFloat("vy", ((Float)this.getEntityData().get(ANIM_V_Y)).floatValue());
    }

    public BlockState getBlock() {
        return (BlockState)this.getEntityData().get(BLOCK_STATE);
    }

    public void setBlock(BlockState block) {
        this.getEntityData().set(BLOCK_STATE, (Object)block);
    }

    public int getDuration() {
        return (Integer)this.getEntityData().get(DURATION);
    }

    public void setDuration(int duration) {
        this.getEntityData().set(DURATION, (Object)duration);
    }

    public int getTicksExisted() {
        return (Integer)this.getEntityData().get(TICKS_EXISTED);
    }

    public void setTicksExisted(int ticksExisted) {
        this.getEntityData().set(TICKS_EXISTED, (Object)ticksExisted);
    }

    public EnumFallingBlockMode getMode() {
        String mode = (String)this.getEntityData().get(MODE);
        if (mode.isEmpty()) {
            return EnumFallingBlockMode.MOBILE;
        }
        return EnumFallingBlockMode.valueOf((String)this.getEntityData().get(MODE));
    }

    private void setMode(EnumFallingBlockMode mode) {
        this.getEntityData().set(MODE, (Object)mode.toString());
    }

    public float getAnimVY() {
        return ((Float)this.getEntityData().get(ANIM_V_Y)).floatValue();
    }

    private void setAnimVY(float vy) {
        this.getEntityData().set(ANIM_V_Y, (Object)Float.valueOf(vy));
    }

    public static enum EnumFallingBlockMode {
        MOBILE,
        POPUP_ANIM;

    }
}

