/*
 * Decompiled with CFR 0.152.
 */
package com.bobmowzie.mowziesmobs.server.ai.animation;

import com.bobmowzie.mowziesmobs.server.ai.animation.AnimationAttackAI;
import com.bobmowzie.mowziesmobs.server.entity.effects.EntityCameraShake;
import com.bobmowzie.mowziesmobs.server.entity.wroughtnaut.EntityWroughtnaut;
import com.bobmowzie.mowziesmobs.server.sound.MMSounds;
import com.ilexiconn.llibrary.server.animation.Animation;
import java.util.List;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;

public class AnimationFWNVerticalAttackAI
extends AnimationAttackAI<EntityWroughtnaut> {
    private final float arc;

    public AnimationFWNVerticalAttackAI(EntityWroughtnaut entity, Animation animation, SoundEvent sound, float applyKnockback, float range, float arc) {
        super(entity, animation, sound, null, applyKnockback, range, 0.0f, 0);
        this.arc = arc;
    }

    @Override
    public void start() {
        super.start();
        ((EntityWroughtnaut)this.entity).playSound((SoundEvent)MMSounds.ENTITY_WROUGHT_PRE_SWING_2.get(), 1.5f, 1.0f);
    }

    @Override
    public void tick() {
        ((EntityWroughtnaut)this.entity).setDeltaMovement(0.0, ((EntityWroughtnaut)this.entity).getDeltaMovement().y, 0.0);
        if (((EntityWroughtnaut)this.entity).getAnimationTick() < 21 && this.entityTarget != null) {
            ((EntityWroughtnaut)this.entity).lookAt((Entity)this.entityTarget, 30.0f, 30.0f);
        } else {
            ((EntityWroughtnaut)this.entity).setYRot(((EntityWroughtnaut)this.entity).yRotO);
        }
        if (((EntityWroughtnaut)this.entity).getAnimationTick() == 6) {
            ((EntityWroughtnaut)this.entity).playSound((SoundEvent)MMSounds.ENTITY_WROUGHT_CREAK.get(), 0.5f, 1.0f);
        } else if (((EntityWroughtnaut)this.entity).getAnimationTick() == 25) {
            ((EntityWroughtnaut)this.entity).playSound(this.attackSound, 1.2f, 1.0f);
        } else if (((EntityWroughtnaut)this.entity).getAnimationTick() == 27) {
            ((EntityWroughtnaut)this.entity).playSound((SoundEvent)MMSounds.ENTITY_WROUGHT_SWING_2.get(), 1.5f, 1.0f);
            List<LivingEntity> entitiesHit = ((EntityWroughtnaut)this.entity).getEntityLivingBaseNearby(this.range, 3.0, this.range, this.range);
            float damage = (float)((EntityWroughtnaut)this.entity).getAttribute(Attributes.ATTACK_DAMAGE).getValue();
            for (LivingEntity entityHit : entitiesHit) {
                float entityHitAngle = (float)((Math.atan2(entityHit.getZ() - ((EntityWroughtnaut)this.entity).getZ(), entityHit.getX() - ((EntityWroughtnaut)this.entity).getX()) * 57.29577951308232 - 90.0) % 360.0);
                float entityAttackingAngle = ((EntityWroughtnaut)this.entity).yBodyRot % 360.0f;
                if (entityHitAngle < 0.0f) {
                    entityHitAngle += 360.0f;
                }
                if (entityAttackingAngle < 0.0f) {
                    entityAttackingAngle += 360.0f;
                }
                float entityRelativeAngle = entityHitAngle - entityAttackingAngle;
                float entityHitDistance = (float)Math.sqrt((entityHit.getZ() - ((EntityWroughtnaut)this.entity).getZ()) * (entityHit.getZ() - ((EntityWroughtnaut)this.entity).getZ()) + (entityHit.getX() - ((EntityWroughtnaut)this.entity).getX()) * (entityHit.getX() - ((EntityWroughtnaut)this.entity).getX()));
                if (!(entityHitDistance <= this.range && entityRelativeAngle <= this.arc / 2.0f && entityRelativeAngle >= -this.arc / 2.0f || entityRelativeAngle >= 360.0f - this.arc / 2.0f) && !(entityRelativeAngle <= -360.0f + this.arc / 2.0f)) continue;
                entityHit.hurt(((EntityWroughtnaut)this.entity).damageSources().mobAttack((LivingEntity)this.entity), damage * 1.5f);
                if (entityHit.isBlocking()) {
                    entityHit.getUseItem().hurtAndBreak(400, entityHit, LivingEntity.getSlotForHand((InteractionHand)entityHit.getUsedItemHand()));
                }
                entityHit.setDeltaMovement(entityHit.getDeltaMovement().x * (double)this.applyKnockbackMultiplier, entityHit.getDeltaMovement().y, entityHit.getDeltaMovement().z * (double)this.applyKnockbackMultiplier);
            }
        } else if (((EntityWroughtnaut)this.entity).getAnimationTick() == 28) {
            ((EntityWroughtnaut)this.entity).playSound((SoundEvent)MMSounds.ENTITY_WROUGHT_AXE_LAND.get(), 1.0f, 0.5f);
            EntityCameraShake.cameraShake(((EntityWroughtnaut)this.entity).level(), ((EntityWroughtnaut)this.entity).position(), 20.0f, 0.3f, 0, 10);
        } else if (((EntityWroughtnaut)this.entity).getAnimationTick() == 44) {
            ((EntityWroughtnaut)this.entity).playSound((SoundEvent)MMSounds.ENTITY_WROUGHT_PULL_1.get(), 1.0f, 1.0f);
            ((EntityWroughtnaut)this.entity).playSound((SoundEvent)MMSounds.ENTITY_WROUGHT_CREAK.get(), 0.5f, 1.0f);
        } else if (((EntityWroughtnaut)this.entity).getAnimationTick() == 75) {
            ((EntityWroughtnaut)this.entity).playSound((SoundEvent)MMSounds.ENTITY_WROUGHT_PULL_5.get(), 1.0f, 1.0f);
        } else if (((EntityWroughtnaut)this.entity).getAnimationTick() == 83) {
            ((EntityWroughtnaut)this.entity).playSound((SoundEvent)MMSounds.ENTITY_WROUGHT_RELEASE_2.get(), 1.0f, 1.0f);
        }
        if (((EntityWroughtnaut)this.entity).getAnimationTick() > 26 && ((EntityWroughtnaut)this.entity).getAnimationTick() < 85) {
            ((EntityWroughtnaut)this.entity).vulnerable = true;
            ((EntityWroughtnaut)this.entity).setYRot(((EntityWroughtnaut)this.entity).yRotO);
            ((EntityWroughtnaut)this.entity).yBodyRot = ((EntityWroughtnaut)this.entity).yBodyRotO;
        } else {
            ((EntityWroughtnaut)this.entity).vulnerable = false;
        }
    }

    @Override
    public void stop() {
        super.stop();
        ((EntityWroughtnaut)this.entity).vulnerable = false;
    }
}

