/*
 * Decompiled with CFR 0.152.
 */
package com.bobmowzie.mowziesmobs.client.render.entity.player;

import com.bobmowzie.mowziesmobs.client.model.entity.ModelGeckoPlayerFirstPerson;
import com.bobmowzie.mowziesmobs.client.model.tools.geckolib.MowzieGeoBone;
import com.bobmowzie.mowziesmobs.client.render.MowzieRenderUtils;
import com.bobmowzie.mowziesmobs.client.render.entity.player.GeckoPlayer;
import com.bobmowzie.mowziesmobs.server.ability.Ability;
import com.bobmowzie.mowziesmobs.server.ability.AbilitySection;
import com.bobmowzie.mowziesmobs.server.ability.PlayerAbility;
import com.bobmowzie.mowziesmobs.server.capability.AbilityData;
import com.bobmowzie.mowziesmobs.server.capability.DataHandler;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.util.HashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.ItemInHandRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix3f;
import org.joml.Matrix3fc;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector4f;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.cache.object.GeoBone;
import software.bernie.geckolib.constant.DataTickets;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.renderer.GeoRenderer;
import software.bernie.geckolib.util.RenderUtil;

public class GeckoFirstPersonRenderer
extends ItemInHandRenderer
implements GeoRenderer<GeckoPlayer> {
    public MultiBufferSource rtb;
    public static GeckoPlayer.GeckoPlayerFirstPerson GECKO_PLAYER_FIRST_PERSON;
    private static HashMap<Class<? extends GeckoPlayer>, GeckoFirstPersonRenderer> modelsToLoad;
    private ModelGeckoPlayerFirstPerson geoModel;
    boolean mirror;
    public Vec3 particleEmitterRoot;

    public GeckoFirstPersonRenderer(Minecraft mcIn, ModelGeckoPlayerFirstPerson geoModel) {
        super(mcIn, mcIn.getEntityRenderDispatcher(), mcIn.getItemRenderer());
        this.geoModel = geoModel;
    }

    public HashMap<Class<? extends GeckoPlayer>, GeckoFirstPersonRenderer> getModelsToLoad() {
        return modelsToLoad;
    }

    public void renderItemInFirstPerson(AbstractClientPlayer player, float pitch, float partialTicks, InteractionHand handIn, float swingProgress, ItemStack stack, float equippedProgress, PoseStack matrixStackIn, MultiBufferSource bufferIn, int combinedLightIn, GeckoPlayer geckoPlayer) {
        this.rtb = bufferIn;
        boolean flag = handIn == InteractionHand.MAIN_HAND;
        HumanoidArm handside = flag ? player.getMainArm() : player.getMainArm().getOpposite();
        boolean bl = this.mirror = player.getMainArm() == HumanoidArm.LEFT;
        if (flag) {
            this.geoModel.setTextureFromPlayer(player);
            AnimationState animationState = new AnimationState((GeoAnimatable)geckoPlayer, 0.0f, 0.0f, partialTicks, false);
            long instanceId = this.getInstanceId((GeoAnimatable)geckoPlayer);
            AnimatableManager animatableManager = geckoPlayer.getAnimatableInstanceCache().getManagerForId(instanceId);
            animationState.setData(DataTickets.TICK, (Object)(geckoPlayer.getTick(geckoPlayer) + animatableManager.getFirstTickTime() + (double)partialTicks));
            AbstractClientPlayer entity = (AbstractClientPlayer)geckoPlayer.getPlayer();
            animationState.setData(DataTickets.ENTITY, (Object)entity);
            this.geoModel.addAdditionalStateData((GeoAnimatable)geckoPlayer, instanceId, (arg_0, arg_1) -> ((AnimationState)animationState).setData(arg_0, arg_1));
            this.geoModel.handleAnimations((GeoAnimatable)geckoPlayer, instanceId, animationState, partialTicks);
            RenderType rendertype = RenderType.itemEntityTranslucentCull((ResourceLocation)this.getTextureLocation(geckoPlayer));
            VertexConsumer ivertexbuilder = bufferIn.getBuffer(rendertype);
            matrixStackIn.translate(0.0f, -2.0f, -1.0f);
            this.actuallyRender(matrixStackIn, (GeoAnimatable)geckoPlayer, this.getGeoModel().getBakedModel(this.getGeoModel().getModelResource((GeoAnimatable)geckoPlayer)), rendertype, bufferIn, ivertexbuilder, false, partialTicks, combinedLightIn, OverlayTexture.NO_OVERLAY, -1);
        }
        PlayerAbility.HandDisplay handDisplay = PlayerAbility.HandDisplay.DEFAULT;
        float offHandEquipProgress = 0.0f;
        AbilityData data = DataHandler.getData((Entity)player, DataHandler.ABILITY_DATA);
        if (data.getActiveAbility() != null) {
            Ability<?> ability = data.getActiveAbility();
            if (ability instanceof PlayerAbility) {
                ItemStack stackOverride;
                PlayerAbility playerAbility = (PlayerAbility)ability;
                ItemStack itemStack = stackOverride = flag ? playerAbility.heldItemMainHandOverride() : playerAbility.heldItemOffHandOverride();
                if (stackOverride != null) {
                    stack = stackOverride;
                }
                PlayerAbility.HandDisplay handDisplay2 = handDisplay = flag ? playerAbility.getFirstPersonMainHandDisplay() : playerAbility.getFirstPersonOffHandDisplay();
            }
            if (ability.getCurrentSection().sectionType == AbilitySection.AbilitySectionType.STARTUP) {
                offHandEquipProgress = Mth.clamp((float)(1.0f - ((float)ability.getTicksInSection() + partialTicks) / 5.0f), (float)0.0f, (float)1.0f);
            } else if (ability.getCurrentSection().sectionType == AbilitySection.AbilitySectionType.RECOVERY && ability.getCurrentSection() instanceof AbilitySection.AbilitySectionDuration) {
                offHandEquipProgress = Mth.clamp((float)(((float)ability.getTicksInSection() + partialTicks - (float)((AbilitySection.AbilitySectionDuration)ability.getCurrentSection()).duration + 5.0f) / 5.0f), (float)0.0f, (float)1.0f);
            }
        }
        if (this.geoModel.isInitialized()) {
            if (handDisplay != PlayerAbility.HandDisplay.DONT_RENDER) {
                int sideMult;
                int n = sideMult = handside == HumanoidArm.RIGHT ? -1 : 1;
                if (this.mirror) {
                    handside = handside.getOpposite();
                }
                String sideName = handside == HumanoidArm.RIGHT ? "Right" : "Left";
                String boneName = sideName + "Arm";
                MowzieGeoBone bone = this.geoModel.getMowzieBone(boneName);
                PoseStack newMatrixStack = new PoseStack();
                float fixedPitchController = 1.0f - this.geoModel.getControllerValueInverted("FixedPitchController" + sideName);
                newMatrixStack.mulPose(new Quaternionf((Quaternionfc)Axis.XP.rotationDegrees(pitch * fixedPitchController)));
                newMatrixStack.last().normal().mul((Matrix3fc)bone.getWorldSpaceNormal());
                newMatrixStack.last().pose().mul((Matrix4fc)bone.getWorldSpaceMatrix());
                newMatrixStack.translate((double)sideMult * 0.547, 0.7655, 0.625);
                if (this.mirror) {
                    handside = handside.getOpposite();
                }
                if (stack.isEmpty() && !flag && handDisplay == PlayerAbility.HandDisplay.FORCE_RENDER && !player.isInvisible()) {
                    newMatrixStack.translate(0.0f, -1.0f * offHandEquipProgress, 0.0f);
                    super.renderPlayerArm(newMatrixStack, bufferIn, combinedLightIn, 0.0f, 0.0f, handside);
                } else {
                    super.renderArmWithItem(player, partialTicks, pitch, handIn, 0.0f, stack, 0.0f, newMatrixStack, bufferIn, combinedLightIn);
                }
            }
            PoseStack toWorldSpace = new PoseStack();
            toWorldSpace.translate(player.getX(), player.getY() + (double)player.getEyeHeight(), player.getZ());
            MowzieGeoBone particleEmitterRootBone = this.geoModel.getMowzieBone("ParticleEmitterRoot");
            Vector4f emitterRootPos = new Vector4f(0.0f, 0.0f, 0.0f, 1.0f);
            emitterRootPos.mul((Matrix4fc)particleEmitterRootBone.getWorldSpaceMatrix());
            emitterRootPos.mul((Matrix4fc)toWorldSpace.last().pose());
            this.particleEmitterRoot = new Vec3((double)emitterRootPos.x(), (double)emitterRootPos.y(), (double)emitterRootPos.z());
        }
    }

    public void setSmallArms() {
        this.geoModel.setUseSmallArms(true);
    }

    public ModelGeckoPlayerFirstPerson getAnimatedPlayerModel() {
        return this.geoModel;
    }

    public GeoModel<GeckoPlayer> getGeoModel() {
        return this.geoModel;
    }

    public GeckoPlayer getAnimatable() {
        return null;
    }

    public ResourceLocation getTextureLocation(GeckoPlayer geckoPlayer) {
        return ((AbstractClientPlayer)geckoPlayer.getPlayer()).getSkin().texture();
    }

    public void fireCompileRenderLayersEvent() {
    }

    public boolean firePreRenderEvent(PoseStack poseStack, BakedGeoModel model, MultiBufferSource bufferSource, float partialTick, int packedLight) {
        return false;
    }

    public void firePostRenderEvent(PoseStack poseStack, BakedGeoModel model, MultiBufferSource bufferSource, float partialTick, int packedLight) {
    }

    public void updateAnimatedTextureFrame(GeckoPlayer animatable) {
    }

    public void renderRecursively(PoseStack matrixStack, GeckoPlayer animatable, GeoBone bone, RenderType renderType, MultiBufferSource bufferIn, VertexConsumer buffer, boolean isReRender, float partialTick, int packedLightIn, int packedOverlayIn, int color) {
        MowzieGeoBone mowzieBone;
        matrixStack.pushPose();
        if (this.mirror) {
            MowzieRenderUtils.translateMirror(matrixStack, bone);
            MowzieRenderUtils.moveToPivotMirror(matrixStack, bone);
            MowzieRenderUtils.rotateMirror(matrixStack, bone);
            RenderUtil.scaleMatrixForBone((PoseStack)matrixStack, (GeoBone)bone);
        } else {
            RenderUtil.translateMatrixToBone((PoseStack)matrixStack, (GeoBone)bone);
            RenderUtil.translateToPivotPoint((PoseStack)matrixStack, (GeoBone)bone);
            RenderUtil.rotateMatrixAroundBone((PoseStack)matrixStack, (GeoBone)bone);
            RenderUtil.scaleMatrixForBone((PoseStack)matrixStack, (GeoBone)bone);
        }
        if (bone instanceof MowzieGeoBone && ((mowzieBone = (MowzieGeoBone)bone).getName().equals("LeftArm") || mowzieBone.getName().equals("RightArm") || mowzieBone.getName().equals("ParticleEmitterRoot"))) {
            matrixStack.pushPose();
            PoseStack.Pose entry = matrixStack.last();
            mowzieBone.setWorldSpaceNormal(new Matrix3f((Matrix3fc)entry.normal()));
            mowzieBone.setWorldSpaceMatrix(new Matrix4f((Matrix4fc)entry.pose()));
            matrixStack.popPose();
        }
        if (this.mirror) {
            MowzieRenderUtils.translateAwayFromPivotPointMirror(matrixStack, bone);
        } else {
            RenderUtil.translateAwayFromPivotPoint((PoseStack)matrixStack, (GeoBone)bone);
        }
        this.renderCubesOfBone(matrixStack, bone, buffer, packedLightIn, packedOverlayIn, color);
        if (!isReRender) {
            this.applyRenderLayersForBone(matrixStack, (GeoAnimatable)animatable, bone, renderType, bufferIn, buffer, partialTick, packedLightIn, packedOverlayIn);
        }
        this.renderChildBones(matrixStack, (GeoAnimatable)animatable, bone, renderType, bufferIn, buffer, isReRender, partialTick, packedLightIn, packedOverlayIn, color);
        matrixStack.popPose();
    }

    static {
        modelsToLoad = new HashMap();
    }
}

