/*
 * Decompiled with CFR 0.152.
 */
package com.bobmowzie.mowziesmobs.client.render.entity;

import com.bobmowzie.mowziesmobs.client.model.entity.ModelEarthSpike;
import com.bobmowzie.mowziesmobs.client.render.entity.RenderGeomancyBase;
import com.bobmowzie.mowziesmobs.client.render.entity.layer.GeckoBlockLayer;
import com.bobmowzie.mowziesmobs.server.entity.effects.geomancy.EntityEarthSpike;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import software.bernie.geckolib.cache.object.GeoCube;
import software.bernie.geckolib.renderer.GeoRenderer;
import software.bernie.geckolib.renderer.layer.GeoRenderLayer;

public class RenderEarthSpike
extends RenderGeomancyBase<EntityEarthSpike> {
    private static final ResourceLocation TEXTURE_DIRT = ResourceLocation.withDefaultNamespace((String)"textures/block/dirt.png");

    public RenderEarthSpike(EntityRendererProvider.Context mgr) {
        super(mgr, new ModelEarthSpike());
        this.addRenderLayer((GeoRenderLayer)new GeckoBlockLayer<EntityEarthSpike>((GeoRenderer<EntityEarthSpike>)this, (bone, animatable) -> {
            if (bone.getName().contains("block")) {
                return animatable.getBlock();
            }
            return null;
        }));
    }

    public ResourceLocation getTextureLocation(EntityEarthSpike entity) {
        return TEXTURE_DIRT;
    }

    public void render(EntityEarthSpike entity, float entityYaw, float partialTick, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight) {
        super.render((Entity)entity, entityYaw, partialTick, poseStack, bufferSource, packedLight);
    }

    protected void applyRotations(EntityEarthSpike animatable, PoseStack poseStack, float ageInTicks, float rotationYaw, float partialTick, float nativeScale) {
        float newRotationYaw = Mth.rotLerp((float)partialTick, (float)animatable.yRotO, (float)animatable.getYRot());
        super.applyRotations((Entity)animatable, poseStack, ageInTicks, newRotationYaw, partialTick, nativeScale);
    }

    public void renderCube(PoseStack poseStack, GeoCube cube, VertexConsumer buffer, int packedLight, int packedOverlay, int colour) {
    }
}

