/*
 * Decompiled with CFR 0.152.
 */
package com.bobmowzie.mowziesmobs.client.render.entity;

import com.bobmowzie.mowziesmobs.client.model.tools.dynamics.GeckoDynamicChain;
import com.bobmowzie.mowziesmobs.client.model.tools.geckolib.MowzieGeoBone;
import com.bobmowzie.mowziesmobs.client.model.tools.geckolib.MowzieGeoModel;
import com.bobmowzie.mowziesmobs.server.entity.MowzieGeckoEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix3f;
import org.joml.Matrix3fc;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector4f;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.cache.object.GeoBone;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.renderer.GeoEntityRenderer;
import software.bernie.geckolib.util.RenderUtil;

public abstract class MowzieGeoEntityRenderer<T extends MowzieGeckoEntity>
extends GeoEntityRenderer<T> {
    protected MowzieGeoEntityRenderer(EntityRendererProvider.Context renderManager, GeoModel<T> modelProvider) {
        super(renderManager, modelProvider);
    }

    public RenderType getRenderType(T animatable, ResourceLocation texture, @Nullable MultiBufferSource bufferSource, float partialTick) {
        return RenderType.entityCutoutNoCull((ResourceLocation)texture);
    }

    public MowzieGeoModel<T> getMowzieGeoModel() {
        return (MowzieGeoModel)super.getGeoModel();
    }

    protected float getDeathMaxRotation(T animatable) {
        return 0.0f;
    }

    public void actuallyRender(PoseStack poseStack, T animatable, BakedGeoModel model, RenderType renderType, MultiBufferSource bufferSource, VertexConsumer buffer, boolean isReRender, float partialTick, int packedLight, int packedOverlay, int color) {
        int i;
        if (((MowzieGeckoEntity)animatable).dynamicChains != null) {
            for (GeckoDynamicChain chain : ((MowzieGeckoEntity)animatable).dynamicChains) {
                if (chain.chainOrig == null) continue;
                for (i = 0; i < chain.chainOrig.length; ++i) {
                    chain.chainOrig[i].setHidden(true);
                }
            }
        }
        super.actuallyRender(poseStack, animatable, model, renderType, bufferSource, buffer, isReRender, partialTick, packedLight, packedOverlay, color);
        if (((MowzieGeckoEntity)animatable).dynamicChains != null) {
            for (GeckoDynamicChain chain : ((MowzieGeckoEntity)animatable).dynamicChains) {
                if (!isReRender) {
                    chain.setChain();
                    chain.updateChain(partialTick, 0.1f, 0.1f, 0.5f, 0.02f, 10, true);
                }
                poseStack.pushPose();
                if (chain.chainDynamic != null) {
                    for (MowzieGeoBone group : chain.chainDynamic) {
                        this.renderRecursively(poseStack, animatable, (GeoBone)group, renderType, bufferSource, buffer, isReRender, partialTick, packedLight, packedOverlay, color);
                    }
                }
                poseStack.popPose();
                for (i = 0; i < chain.chainOrig.length; ++i) {
                    chain.chainOrig[i].setHidden(false);
                }
            }
        }
    }

    public void renderRecursively(PoseStack poseStack, T animatable, GeoBone bone, RenderType renderType, MultiBufferSource bufferSource, VertexConsumer buffer, boolean isReRender, float partialTick, int packedLight, int packedOverlay, int color) {
        MowzieGeoBone mowzieGeoBone;
        if (bone == null) {
            return;
        }
        poseStack.pushPose();
        if (bone instanceof MowzieGeoBone && (mowzieGeoBone = (MowzieGeoBone)bone).isForceMatrixTransform()) {
            PoseStack.Pose last = poseStack.last();
            float lerpBodyRot = animatable == null ? 0.0f : Mth.rotLerp((float)partialTick, (float)((MowzieGeckoEntity)animatable).yBodyRotO, (float)((MowzieGeckoEntity)animatable).yBodyRot);
            double d0 = animatable.getX();
            double d1 = animatable.getY();
            double d2 = animatable.getZ();
            Matrix4f matrix4f = new Matrix4f();
            matrix4f = matrix4f.translate(0.0f, -0.01f, 0.0f);
            matrix4f = matrix4f.translate((float)(-d0), (float)(-d1), (float)(-d2));
            matrix4f = matrix4f.mul((Matrix4fc)bone.getWorldSpaceMatrix());
            matrix4f = matrix4f.rotate((Quaternionfc)Axis.YP.rotationDegrees(-180.0f - lerpBodyRot));
            last.pose().mul((Matrix4fc)matrix4f);
            last.normal().mul((Matrix3fc)bone.getWorldSpaceNormal());
            RenderUtil.translateAwayFromPivotPoint((PoseStack)poseStack, (GeoBone)bone);
        } else {
            MowzieGeoBone mowzieGeoBone2;
            boolean rotOverride = false;
            if (bone instanceof MowzieGeoBone) {
                mowzieGeoBone2 = (MowzieGeoBone)bone;
                rotOverride = mowzieGeoBone2.rotationOverride != null;
            }
            RenderUtil.translateMatrixToBone((PoseStack)poseStack, (GeoBone)bone);
            RenderUtil.translateToPivotPoint((PoseStack)poseStack, (GeoBone)bone);
            if (bone instanceof MowzieGeoBone) {
                mowzieGeoBone2 = (MowzieGeoBone)bone;
                if (!mowzieGeoBone2.inheritRotation && !mowzieGeoBone2.inheritTranslation) {
                    poseStack.last().pose().identity();
                    poseStack.last().pose().mul((Matrix4fc)this.entityRenderTranslations);
                } else if (!mowzieGeoBone2.inheritRotation) {
                    Vector4f t = new Vector4f().mul((Matrix4fc)poseStack.last().pose());
                    poseStack.last().pose().identity();
                    poseStack.translate(t.x, t.y, t.z);
                } else if (!mowzieGeoBone2.inheritTranslation) {
                    MowzieGeoBone.removeMatrixTranslation(poseStack.last().pose());
                    poseStack.last().pose().mul((Matrix4fc)this.entityRenderTranslations);
                }
            }
            if (rotOverride) {
                mowzieGeoBone2 = (MowzieGeoBone)bone;
                poseStack.last().pose().mul((Matrix4fc)mowzieGeoBone2.rotationOverride);
                poseStack.last().normal().mul((Matrix3fc)new Matrix3f((Matrix4fc)mowzieGeoBone2.rotationOverride));
            } else {
                RenderUtil.rotateMatrixAroundBone((PoseStack)poseStack, (GeoBone)bone);
            }
            RenderUtil.scaleMatrixForBone((PoseStack)poseStack, (GeoBone)bone);
            if (bone.isTrackingMatrices()) {
                Matrix4f poseState = new Matrix4f((Matrix4fc)poseStack.last().pose());
                Matrix4f localMatrix = RenderUtil.invertAndMultiplyMatrices((Matrix4f)poseState, (Matrix4f)this.entityRenderTranslations);
                if (bone instanceof MowzieGeoBone) {
                    MowzieGeoBone mowzieGeoBone3 = (MowzieGeoBone)bone;
                    mowzieGeoBone3.setPose(poseState);
                }
                bone.setModelSpaceMatrix(RenderUtil.invertAndMultiplyMatrices((Matrix4f)poseState, (Matrix4f)this.modelRenderTranslations));
                bone.setLocalSpaceMatrix(RenderUtil.translateMatrix((Matrix4f)localMatrix, (Vector3f)this.getRenderOffset((Entity)((MowzieGeckoEntity)this.animatable), 1.0f).toVector3f()));
                bone.setWorldSpaceMatrix(RenderUtil.translateMatrix((Matrix4f)new Matrix4f((Matrix4fc)localMatrix), (Vector3f)((MowzieGeckoEntity)this.animatable).position().toVector3f()));
            }
            RenderUtil.translateAwayFromPivotPoint((PoseStack)poseStack, (GeoBone)bone);
        }
        buffer = this.checkAndRefreshBuffer(isReRender, buffer, bufferSource, renderType);
        this.renderCubesOfBone(poseStack, bone, buffer, packedLight, packedOverlay, color);
        if (!isReRender) {
            this.applyRenderLayersForBone(poseStack, (GeoAnimatable)animatable, bone, renderType, bufferSource, buffer, partialTick, packedLight, packedOverlay);
        }
        this.renderChildBones(poseStack, animatable, bone, renderType, bufferSource, buffer, isReRender, partialTick, packedLight, packedOverlay, color);
        poseStack.popPose();
    }

    public void renderChildBones(PoseStack poseStack, T animatable, GeoBone bone, RenderType renderType, MultiBufferSource bufferSource, VertexConsumer buffer, boolean isReRender, float partialTick, int packedLight, int packedOverlay, int color) {
        for (GeoBone childBone : bone.getChildBones()) {
            MowzieGeoBone mowzieGeoBone;
            if (bone.isHidingChildren() && (!(childBone instanceof MowzieGeoBone) || !(mowzieGeoBone = (MowzieGeoBone)childBone).isDynamicJoint())) continue;
            this.renderRecursively(poseStack, animatable, childBone, renderType, bufferSource, buffer, isReRender, partialTick, packedLight, packedOverlay, color);
        }
    }
}

