/*
 * Decompiled with CFR 0.152.
 */
package com.bobmowzie.mowziesmobs.client.particle.util;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public abstract class ParticleRotation {
    public static final Codec<ParticleRotation> CODEC = Codec.either(FaceCamera.CODEC, (Codec)Codec.either(EulerAngles.CODEC, OrientVector.CODEC)).flatXmap(either -> (DataResult)either.map(DataResult::success, other -> (DataResult)other.map(DataResult::success, DataResult::success)), rotation -> {
        if (rotation instanceof FaceCamera) {
            FaceCamera faceCamera = (FaceCamera)rotation;
            return DataResult.success((Object)Either.left((Object)faceCamera));
        }
        if (rotation instanceof EulerAngles) {
            EulerAngles eulerAngles = (EulerAngles)rotation;
            return DataResult.success((Object)Either.right((Object)Either.left((Object)eulerAngles)));
        }
        if (rotation instanceof OrientVector) {
            OrientVector orientVector = (OrientVector)rotation;
            return DataResult.success((Object)Either.right((Object)Either.right((Object)orientVector)));
        }
        return DataResult.error(() -> "Invalid rotation type: [" + rotation.getClass().getName() + "]");
    });

    public abstract void setPrevValues();

    public abstract Type type();

    public static class FaceCamera
    extends ParticleRotation {
        public static final Codec<FaceCamera> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.FLOAT.fieldOf("angle").forGetter(value -> Float.valueOf(value.angle))).apply((Applicative)instance, FaceCamera::new));
        public static final Type TYPE = Type.FACE_CAMERA;
        public float angle;
        public float prevAngle;

        public FaceCamera(float angle) {
            this.angle = angle;
        }

        @Override
        public void setPrevValues() {
            this.prevAngle = this.angle;
        }

        @Override
        public Type type() {
            return TYPE;
        }
    }

    public static class EulerAngles
    extends ParticleRotation {
        public static final Codec<EulerAngles> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.FLOAT.fieldOf("yaw").forGetter(value -> Float.valueOf(value.yaw)), (App)Codec.FLOAT.fieldOf("pitch").forGetter(value -> Float.valueOf(value.pitch)), (App)Codec.FLOAT.fieldOf("roll").forGetter(value -> Float.valueOf(value.roll))).apply((Applicative)instance, EulerAngles::new));
        public static final Type TYPE = Type.EULER_ANGLES;
        public float yaw;
        public float pitch;
        public float roll;
        public float prevYaw;
        public float prevPitch;
        public float prevRoll;

        public EulerAngles(float yaw, float pitch, float roll) {
            this.yaw = this.prevYaw = yaw;
            this.pitch = this.prevPitch = pitch;
            this.roll = this.prevRoll = roll;
        }

        @Override
        public void setPrevValues() {
            this.prevYaw = this.yaw;
            this.prevPitch = this.pitch;
            this.prevRoll = this.roll;
        }

        @Override
        public Type type() {
            return TYPE;
        }
    }

    public static class OrientVector
    extends ParticleRotation {
        public static final Codec<OrientVector> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Vec3.CODEC.fieldOf("orientation").forGetter(value -> value.orientation)).apply((Applicative)instance, OrientVector::new));
        public static final Type TYPE = Type.ORIENT_VECTOR;
        public Vec3 orientation;
        public Vec3 prevOrientation;

        public OrientVector(Vec3 orientation) {
            this.orientation = this.prevOrientation = orientation;
        }

        @Override
        public void setPrevValues() {
            this.prevOrientation = this.orientation;
        }

        @Override
        public Type type() {
            return TYPE;
        }
    }

    public static enum Type implements StringRepresentable
    {
        FACE_CAMERA("face_camera"),
        EULER_ANGLES("euler_angles"),
        ORIENT_VECTOR("orient_vector");

        private final String id;

        private Type(String id) {
            this.id = id;
        }

        @NotNull
        public String getSerializedName() {
            return this.id;
        }
    }
}

