/*
 * Decompiled with CFR 0.152.
 */
package com.bobmowzie.mowziesmobs.client.model.entity;

import com.bobmowzie.mowziesmobs.server.entity.effects.geomancy.EntityRockSling;
import java.util.Map;
import java.util.TreeMap;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Blocks;
import software.bernie.geckolib.model.GeoModel;

public class ModelRockSling
extends GeoModel<EntityRockSling> {
    static Map<String, ResourceLocation> texMap;
    private static final ResourceLocation TEXTURE_DIRT;
    private static final ResourceLocation TEXTURE_STONE;
    private static final ResourceLocation TEXTURE_SANDSTONE;
    private static final ResourceLocation TEXTURE_CLAY;

    public ModelRockSling() {
        texMap = new TreeMap<String, ResourceLocation>();
        texMap.put(Blocks.STONE.getDescriptionId(), TEXTURE_STONE);
        texMap.put(Blocks.DIRT.getDescriptionId(), TEXTURE_DIRT);
        texMap.put(Blocks.CLAY.getDescriptionId(), TEXTURE_CLAY);
        texMap.put(Blocks.SANDSTONE.getDescriptionId(), TEXTURE_SANDSTONE);
    }

    public ResourceLocation getAnimationResource(EntityRockSling entity) {
        return ResourceLocation.fromNamespaceAndPath((String)"mowziesmobs", (String)"animations/rock_sling.animation.json");
    }

    public ResourceLocation getModelResource(EntityRockSling entity) {
        return ResourceLocation.fromNamespaceAndPath((String)"mowziesmobs", (String)"geo/rock_sling.geo.json");
    }

    public ResourceLocation getTextureResource(EntityRockSling entity) {
        ResourceLocation tex;
        if (entity.storedBlock != null && (tex = texMap.get(entity.storedBlock.getBlock().getDescriptionId())) != null) {
            return tex;
        }
        return TEXTURE_DIRT;
    }

    public RenderType getRenderType(EntityRockSling animatable, ResourceLocation texture) {
        return RenderType.entityCutout((ResourceLocation)texture);
    }

    static {
        TEXTURE_DIRT = ResourceLocation.withDefaultNamespace((String)"textures/block/dirt.png");
        TEXTURE_STONE = ResourceLocation.withDefaultNamespace((String)"textures/block/stone.png");
        TEXTURE_SANDSTONE = ResourceLocation.withDefaultNamespace((String)"textures/block/sandstone.png");
        TEXTURE_CLAY = ResourceLocation.withDefaultNamespace((String)"textures/block/clay.png");
    }
}

