/*
 * Decompiled with CFR 0.152.
 */
package fuzs.skeletonaifix;

import fuzs.puzzleslib.api.config.v3.ConfigHolder;
import fuzs.puzzleslib.api.core.v1.ModConstructor;
import fuzs.puzzleslib.api.core.v1.utility.ResourceLocationHelper;
import fuzs.puzzleslib.api.event.v1.entity.EntityTickEvents;
import fuzs.skeletonaifix.config.ServerConfig;
import fuzs.skeletonaifix.init.ModRegistry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Difficulty;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.RangedBowAttackGoal;
import net.minecraft.world.entity.monster.AbstractSkeleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SkeletonAIFix
implements ModConstructor {
    public static final String MOD_ID = "skeletonaifix";
    public static final String MOD_NAME = "Skeleton AI Fix";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"Skeleton AI Fix");
    public static final ConfigHolder CONFIG = ConfigHolder.builder((String)"skeletonaifix").server(ServerConfig.class);

    public void onConstructMod() {
        ModRegistry.bootstrap();
        SkeletonAIFix.registerEventHandlers();
    }

    private static void registerEventHandlers() {
        EntityTickEvents.END.register(SkeletonAIFix::onEndEntityTick);
    }

    private static void onEndEntityTick(Entity entity) {
        AbstractSkeleton abstractSkeleton;
        if (entity instanceof AbstractSkeleton && (abstractSkeleton = (AbstractSkeleton)entity).getType().is(ModRegistry.WELL_BEHAVED_SKELETONS_ENTITY_TYPE_TAG)) {
            RangedBowAttackGoal bowGoal = abstractSkeleton.bowGoal;
            bowGoal.strafingTime = Integer.MIN_VALUE;
            LivingEntity livingEntity = abstractSkeleton.getTarget();
            if (livingEntity != null) {
                double attackInterval = SkeletonAIFix.getAttackInterval(abstractSkeleton);
                double distanceToTargetSqr = abstractSkeleton.distanceToSqr((Entity)livingEntity);
                int minAttackInterval = SkeletonAIFix.getMinAttackInterval(attackInterval, distanceToTargetSqr, bowGoal.attackRadiusSqr);
                bowGoal.setMinAttackInterval(minAttackInterval);
            }
        }
    }

    private static double getAttackInterval(AbstractSkeleton abstractSkeleton) {
        double attackInterval = abstractSkeleton.level().getDifficulty() == Difficulty.HARD ? (double)abstractSkeleton.getHardAttackInterval() : (double)abstractSkeleton.getAttackInterval();
        return attackInterval *= ((ServerConfig)SkeletonAIFix.CONFIG.get(ServerConfig.class)).attackIntervalMultiplier;
    }

    private static int getMinAttackInterval(double attackInterval, double distanceToTargetSqr, double attackRadiusSqr) {
        double distanceScale = ((ServerConfig)SkeletonAIFix.CONFIG.get(ServerConfig.class)).attackIntervalDistanceScale;
        double baseAttackInterval = attackInterval * (1.0 - distanceScale);
        double attackRadiusScale = SkeletonAIFix.easeOutQuad(Math.min(distanceToTargetSqr / attackRadiusSqr, 1.0));
        double scaledAttackInterval = attackInterval * distanceScale * attackRadiusScale;
        return (int)(baseAttackInterval + scaledAttackInterval);
    }

    static double easeOutQuad(double x) {
        return 1.0 - (1.0 - x) * (1.0 - x);
    }

    public static ResourceLocation id(String path) {
        return ResourceLocationHelper.fromNamespaceAndPath((String)MOD_ID, (String)path);
    }
}

