/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.raided.entity.projectiles;

import com.mrbysco.raided.registry.RaidedRegistry;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.animal.Pig;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.monster.Witch;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.npc.WanderingTrader;
import net.minecraft.world.entity.projectile.AbstractHurtingProjectile;
import net.minecraft.world.entity.raid.Raider;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.event.EventHooks;

public class LightningProjectile
extends AbstractHurtingProjectile {
    @Nullable
    private UUID targetId;

    public LightningProjectile(EntityType<? extends AbstractHurtingProjectile> entityType, Level level) {
        super(entityType, level);
    }

    public LightningProjectile(Level level, LivingEntity shooter, Vec3 movement) {
        super(RaidedRegistry.LIGHTNING_PROJECTILE.get(), shooter, movement, level);
        this.moveTo(shooter.getX(), shooter.getY() + 2.0, shooter.getZ(), this.getYRot(), this.getXRot());
    }

    public LightningProjectile(Level level, double x, double y, double z, Vec3 movement) {
        super(RaidedRegistry.LIGHTNING_PROJECTILE.get(), x, y, z, movement, level);
    }

    protected ParticleOptions getTrailParticle() {
        return ParticleTypes.ELECTRIC_SPARK;
    }

    public void setTarget(@Nullable UUID targetId) {
        this.targetId = targetId;
    }

    public void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        if (this.targetId != null) {
            tag.putUUID("Target", this.targetId);
        }
    }

    public void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        if (tag.hasUUID("Target")) {
            this.targetId = tag.getUUID("Target");
        }
    }

    protected void onHit(HitResult result) {
        super.onHit(result);
        if (!this.level().isClientSide) {
            this.discard();
        }
    }

    protected void onHitEntity(EntityHitResult hitResult) {
        Entity entity = hitResult.getEntity();
        if (this.targetId != null && entity.getUUID().equals(this.targetId)) {
            this.convertEntity(entity);
        } else {
            entity.hurt(this.damageSources().lightningBolt(), 2.0f);
        }
    }

    private void convertEntity(Entity entity) {
        if (!this.level().isClientSide) {
            AbstractVillager abstractVillager;
            if (entity instanceof Creeper) {
                Creeper creeper = (Creeper)entity;
                if (creeper.isAlive() && !creeper.isPowered()) {
                    LightningBolt bolt = new LightningBolt(EntityType.LIGHTNING_BOLT, this.level());
                    bolt.setDamage(0.0f);
                    creeper.thunderHit((ServerLevel)this.level(), bolt);
                }
            } else if (entity instanceof Pig) {
                Pig pig = (Pig)entity;
                if (pig.isAlive()) {
                    LightningBolt bolt = new LightningBolt(EntityType.LIGHTNING_BOLT, this.level());
                    bolt.setDamage(0.0f);
                    pig.thunderHit((ServerLevel)this.level(), bolt);
                }
            } else if (entity instanceof AbstractVillager && !((abstractVillager = (AbstractVillager)entity) instanceof WanderingTrader) && abstractVillager.isAlive()) {
                ServerLevel level = (ServerLevel)this.level();
                if (this.level().getDifficulty() != Difficulty.PEACEFUL && EventHooks.canLivingConvert((LivingEntity)abstractVillager, (EntityType)EntityType.WITCH, timer -> {})) {
                    Witch witch = (Witch)EntityType.WITCH.create((Level)level);
                    witch.moveTo(abstractVillager.getX(), abstractVillager.getY(), abstractVillager.getZ(), abstractVillager.getYRot(), abstractVillager.getXRot());
                    EventHooks.finalizeMobSpawn((Mob)witch, (ServerLevelAccessor)level, (DifficultyInstance)level.getCurrentDifficultyAt(witch.blockPosition()), (MobSpawnType)MobSpawnType.CONVERSION, (SpawnGroupData)null);
                    witch.setNoAi(abstractVillager.isNoAi());
                    if (abstractVillager.hasCustomName()) {
                        witch.setCustomName(abstractVillager.getCustomName());
                        witch.setCustomNameVisible(abstractVillager.isCustomNameVisible());
                    }
                    witch.setPersistenceRequired();
                    EventHooks.onLivingConvert((LivingEntity)abstractVillager, (LivingEntity)witch);
                    level.addFreshEntityWithPassengers((Entity)witch);
                    if (abstractVillager instanceof Villager) {
                        Villager villager = (Villager)abstractVillager;
                        villager.releaseAllPois();
                    }
                    abstractVillager.discard();
                }
            }
        }
    }

    public boolean canCollideWith(Entity entity) {
        return !(entity instanceof Raider) && super.canCollideWith(entity);
    }
}

