/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.raided.entity.projectiles;

import com.mrbysco.raided.registry.RaidedRegistry;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.Fireball;
import net.minecraft.world.entity.projectile.SmallFireball;
import net.minecraft.world.entity.raid.Raider;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;

public class IncineratorFireball
extends SmallFireball {
    public IncineratorFireball(EntityType<? extends IncineratorFireball> entityType, Level level) {
        super(entityType, level);
    }

    public IncineratorFireball(Level level, LivingEntity shooter, Vec3 movement) {
        super(level, shooter, movement);
    }

    public EntityType<?> getType() {
        return RaidedRegistry.INCINERATOR_FIREBALL.get();
    }

    protected ParticleOptions getTrailParticle() {
        return ParticleTypes.SMOKE;
    }

    protected void onHitEntity(EntityHitResult entityHitResult) {
        Level level = this.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverlevel = (ServerLevel)level;
            Entity entity = entityHitResult.getEntity();
            if (!(entity instanceof Raider) && !entity.fireImmune()) {
                Entity owner = this.getOwner();
                int i = entity.getRemainingFireTicks();
                entity.igniteForTicks(4);
                DamageSource fireball = this.damageSources().fireball((Fireball)this, owner);
                boolean flag = entity.hurt(fireball, 5.0f);
                if (!flag) {
                    entity.igniteForTicks(i);
                } else if (owner instanceof LivingEntity) {
                    EnchantmentHelper.doPostAttackEffects((ServerLevel)serverlevel, (Entity)entity, (DamageSource)fireball);
                }
            }
        }
    }

    protected void onHitBlock(BlockHitResult blockHitResult) {
    }

    public boolean canBeCollidedWith() {
        return false;
    }

    public boolean hurt(DamageSource source, float amount) {
        return false;
    }
}

