/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.raided.entity;

import com.mrbysco.raided.entity.goal.WalkToRaiderGoal;
import com.mrbysco.raided.entity.projectiles.LightningProjectile;
import com.mrbysco.raided.registry.RaidedRegistry;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.animal.Pig;
import net.minecraft.world.entity.monster.AbstractIllager;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.SpellcasterIllager;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.npc.WanderingTrader;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.raid.Raider;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.event.EventHooks;
import org.jetbrains.annotations.Nullable;

public class Electromancer
extends SpellcasterIllager {
    @Nullable
    private AbstractVillager witchificationTarget;
    @Nullable
    private Creeper creeperConversionTarget;
    @Nullable
    private Pig pigConversionTarget;

    public Electromancer(EntityType<? extends SpellcasterIllager> entityType, Level level) {
        super(entityType, level);
    }

    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(1, (Goal)new CastingSpellGoal());
        this.goalSelector.addGoal(2, (Goal)new AvoidEntityGoal((PathfinderMob)this, Player.class, 8.0f, 0.6, 1.0));
        this.goalSelector.addGoal(2, (Goal)new AbstractIllager.RaiderOpenDoorGoal((AbstractIllager)this, (Raider)this));
        this.goalSelector.addGoal(3, (Goal)new Raider.HoldGroundAttackGoal((Raider)this, (AbstractIllager)this, 10.0f));
        this.goalSelector.addGoal(4, (Goal)new WalkToRaiderGoal((Mob)this, 1.0, 4.0f, 8.0f));
        this.goalSelector.addGoal(6, (Goal)new CreeperConversionGoal());
        this.goalSelector.addGoal(7, (Goal)new PigConversionGoal());
        this.goalSelector.addGoal(8, (Goal)new WitchificationSpellGoal());
        this.targetSelector.addGoal(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[]{Raider.class}).setAlertOthers(new Class[0]));
        this.goalSelector.addGoal(8, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.6));
        this.goalSelector.addGoal(9, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 3.0f, 1.0f));
        this.goalSelector.addGoal(10, (Goal)new LookAtPlayerGoal((Mob)this, Mob.class, 8.0f));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.createMonsterAttributes().add(Attributes.MOVEMENT_SPEED, 0.3125).add(Attributes.FOLLOW_RANGE, 12.0).add(Attributes.MAX_HEALTH, 22.0).add(Attributes.ATTACK_DAMAGE, 2.0);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
    }

    public void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
    }

    public void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
    }

    public AbstractIllager.IllagerArmPose getArmPose() {
        if (this.isCastingSpell()) {
            return AbstractIllager.IllagerArmPose.SPELLCASTING;
        }
        return this.isCelebrating() ? AbstractIllager.IllagerArmPose.CELEBRATING : AbstractIllager.IllagerArmPose.CROSSED;
    }

    void setPigConversionTarget(@Nullable Pig pig) {
        this.pigConversionTarget = pig;
    }

    @Nullable
    Pig getPigConversionTarget() {
        return this.pigConversionTarget;
    }

    void setCreeperConversionTarget(@Nullable Creeper creeper) {
        this.creeperConversionTarget = creeper;
    }

    @Nullable
    Creeper getCreeperConversionTarget() {
        return this.creeperConversionTarget;
    }

    void setWitchificationTarget(@Nullable AbstractVillager villager) {
        this.witchificationTarget = villager;
    }

    @Nullable
    AbstractVillager getWitchificationTarget() {
        return this.witchificationTarget;
    }

    public boolean isAlliedTo(Entity entity) {
        if (super.isAlliedTo(entity)) {
            return true;
        }
        if (entity instanceof LivingEntity && ((LivingEntity)entity).getType().is(EntityTypeTags.ILLAGER)) {
            return this.getTeam() == null && entity.getTeam() == null;
        }
        return false;
    }

    public void applyRaidBuffs(ServerLevel p_348605_, int p_37844_, boolean p_37845_) {
    }

    protected SoundEvent getAmbientSound() {
        return RaidedRegistry.ELECTROMANCER.getAmbient();
    }

    protected SoundEvent getDeathSound() {
        return RaidedRegistry.ELECTROMANCER.getDeath();
    }

    protected SoundEvent getHurtSound(DamageSource p_33306_) {
        return RaidedRegistry.ELECTROMANCER.getHurt();
    }

    protected SoundEvent getCastingSoundEvent() {
        return RaidedRegistry.ELECTROMANCER.getCasting();
    }

    public SoundEvent getCelebrateSound() {
        return RaidedRegistry.ELECTROMANCER.getCelebrate();
    }

    class CastingSpellGoal
    extends SpellcasterIllager.SpellcasterCastingSpellGoal {
        CastingSpellGoal() {
            super((SpellcasterIllager)Electromancer.this);
        }

        public void tick() {
            if (Electromancer.this.getTarget() != null) {
                Electromancer.this.getLookControl().setLookAt((Entity)Electromancer.this.getTarget(), (float)Electromancer.this.getMaxHeadYRot(), (float)Electromancer.this.getMaxHeadXRot());
            } else if (Electromancer.this.getWitchificationTarget() != null) {
                Electromancer.this.getLookControl().setLookAt((Entity)Electromancer.this.getWitchificationTarget(), (float)Electromancer.this.getMaxHeadYRot(), (float)Electromancer.this.getMaxHeadXRot());
            } else if (Electromancer.this.getCreeperConversionTarget() != null) {
                Electromancer.this.getLookControl().setLookAt((Entity)Electromancer.this.getCreeperConversionTarget(), (float)Electromancer.this.getMaxHeadYRot(), (float)Electromancer.this.getMaxHeadXRot());
            }
        }
    }

    public class CreeperConversionGoal
    extends BoltUseSpellGoal {
        private final TargetingConditions conversionTargeting;

        public CreeperConversionGoal() {
            this.conversionTargeting = TargetingConditions.forNonCombat().range(16.0).selector(livingEntity -> !((Creeper)livingEntity).isPowered());
        }

        @Override
        public boolean canUse() {
            if (Electromancer.this.getTarget() != null) {
                return false;
            }
            if (Electromancer.this.isCastingSpell()) {
                return false;
            }
            if (Electromancer.this.tickCount < this.nextAttackTickCount) {
                return false;
            }
            if (!EventHooks.canEntityGrief((Level)Electromancer.this.level(), (Entity)Electromancer.this)) {
                return false;
            }
            List list = Electromancer.this.level().getNearbyEntities(Creeper.class, this.conversionTargeting, (LivingEntity)Electromancer.this, Electromancer.this.getBoundingBox().inflate(16.0, 4.0, 16.0));
            if (list.isEmpty()) {
                return false;
            }
            Electromancer.this.setCreeperConversionTarget((Creeper)list.get(Electromancer.this.random.nextInt(list.size())));
            return true;
        }

        @Override
        public boolean canContinueToUse() {
            return Electromancer.this.getCreeperConversionTarget() != null && this.attackWarmupDelay > 0;
        }

        public void stop() {
            super.stop();
            Electromancer.this.setCreeperConversionTarget(null);
        }

        protected void performSpellCasting() {
            Creeper creeper = Electromancer.this.getCreeperConversionTarget();
            if (creeper != null && creeper.isAlive()) {
                this.createBoltEntity((LivingEntity)creeper);
            }
        }

        protected int getCastWarmupTime() {
            return 80;
        }

        protected int getCastingTime() {
            return 80;
        }

        protected int getCastingInterval() {
            return 240;
        }

        protected SoundEvent getSpellPrepareSound() {
            return (SoundEvent)RaidedRegistry.ELECROMANCER_PREPARE_CONVERSION.get();
        }

        protected SpellcasterIllager.IllagerSpell getSpell() {
            return SpellcasterIllager.IllagerSpell.WOLOLO;
        }
    }

    public class PigConversionGoal
    extends BoltUseSpellGoal {
        private final TargetingConditions conversionTargeting;

        public PigConversionGoal() {
            this.conversionTargeting = TargetingConditions.forNonCombat().range(16.0).selector(livingEntity -> ((Pig)livingEntity).isAlive());
        }

        @Override
        public boolean canUse() {
            if (Electromancer.this.getTarget() != null) {
                return false;
            }
            if (Electromancer.this.isCastingSpell()) {
                return false;
            }
            if (Electromancer.this.tickCount < this.nextAttackTickCount) {
                return false;
            }
            if (!EventHooks.canEntityGrief((Level)Electromancer.this.level(), (Entity)Electromancer.this)) {
                return false;
            }
            List list = Electromancer.this.level().getNearbyEntities(Pig.class, this.conversionTargeting, (LivingEntity)Electromancer.this, Electromancer.this.getBoundingBox().inflate(16.0, 4.0, 16.0));
            if (list.isEmpty()) {
                return false;
            }
            Electromancer.this.setPigConversionTarget((Pig)list.get(Electromancer.this.random.nextInt(list.size())));
            return true;
        }

        @Override
        public boolean canContinueToUse() {
            return Electromancer.this.getPigConversionTarget() != null && this.attackWarmupDelay > 0;
        }

        public void stop() {
            super.stop();
            Electromancer.this.setPigConversionTarget(null);
        }

        protected void performSpellCasting() {
            Pig pig = Electromancer.this.getPigConversionTarget();
            if (pig != null && pig.isAlive()) {
                this.createBoltEntity((LivingEntity)pig);
            }
        }

        protected int getCastWarmupTime() {
            return 120;
        }

        protected int getCastingTime() {
            return 120;
        }

        protected int getCastingInterval() {
            return 320;
        }

        protected SoundEvent getSpellPrepareSound() {
            return (SoundEvent)RaidedRegistry.ELECROMANCER_PREPARE_CONVERSION.get();
        }

        protected SpellcasterIllager.IllagerSpell getSpell() {
            return SpellcasterIllager.IllagerSpell.WOLOLO;
        }
    }

    public class WitchificationSpellGoal
    extends BoltUseSpellGoal {
        private final TargetingConditions conversionTargeting;

        public WitchificationSpellGoal() {
            this.conversionTargeting = TargetingConditions.forNonCombat().range(16.0).selector(livingEntity -> !(livingEntity instanceof WanderingTrader));
        }

        @Override
        public boolean canUse() {
            if (Electromancer.this.getTarget() != null) {
                return false;
            }
            if (Electromancer.this.isCastingSpell()) {
                return false;
            }
            if (Electromancer.this.tickCount < this.nextAttackTickCount) {
                return false;
            }
            if (!EventHooks.canEntityGrief((Level)Electromancer.this.level(), (Entity)Electromancer.this)) {
                return false;
            }
            List list = Electromancer.this.level().getNearbyEntities(AbstractVillager.class, this.conversionTargeting, (LivingEntity)Electromancer.this, Electromancer.this.getBoundingBox().inflate(16.0, 4.0, 16.0));
            if (list.isEmpty()) {
                return false;
            }
            Electromancer.this.setWitchificationTarget((AbstractVillager)list.get(Electromancer.this.random.nextInt(list.size())));
            return true;
        }

        @Override
        public boolean canContinueToUse() {
            return Electromancer.this.getWitchificationTarget() != null && this.attackWarmupDelay > 0;
        }

        public void stop() {
            super.stop();
            Electromancer.this.setWitchificationTarget(null);
        }

        protected void performSpellCasting() {
            AbstractVillager abstractVillager = Electromancer.this.getWitchificationTarget();
            if (!Electromancer.this.level().isClientSide && abstractVillager != null && abstractVillager.isAlive()) {
                this.createBoltEntity((LivingEntity)abstractVillager);
            }
        }

        protected int getCastWarmupTime() {
            return 240;
        }

        protected int getCastingTime() {
            return 240;
        }

        protected int getCastingInterval() {
            return 512;
        }

        protected SoundEvent getSpellPrepareSound() {
            return (SoundEvent)RaidedRegistry.ELECROMANCER_PREPARE_CONVERSION.get();
        }

        protected SpellcasterIllager.IllagerSpell getSpell() {
            return SpellcasterIllager.IllagerSpell.WOLOLO;
        }
    }

    public abstract class BoltUseSpellGoal
    extends SpellcasterIllager.SpellcasterUseSpellGoal {
        public BoltUseSpellGoal() {
            super((SpellcasterIllager)Electromancer.this);
        }

        protected void createBoltEntity(LivingEntity target) {
            LightningProjectile lightningProjectile = new LightningProjectile(Electromancer.this.level(), (LivingEntity)Electromancer.this, Vec3.ZERO);
            double d1 = target.getX() - Electromancer.this.getX();
            double d2 = target.getY(0.5) - (Electromancer.this.getY(0.5) + 2.0);
            double d3 = target.getZ() - Electromancer.this.getZ();
            double d4 = Math.sqrt(d1 * d1 + d3 * d3) * (double)0.2f;
            lightningProjectile.shoot(d1, d2 + d4, d3, 1.6f, 0.0f);
            lightningProjectile.setTarget(target.getUUID());
            Electromancer.this.level().addFreshEntity((Entity)lightningProjectile);
        }
    }
}

