/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.raided.datagen.client;

import com.mrbysco.raided.registry.RaidRegHelper;
import com.mrbysco.raided.registry.RaidedRegistry;
import java.util.function.Supplier;
import net.minecraft.data.PackOutput;
import net.minecraft.sounds.SoundEvent;
import net.neoforged.neoforge.common.data.LanguageProvider;
import org.jetbrains.annotations.Nullable;

public class RaidedLanguageProvider
extends LanguageProvider {
    public RaidedLanguageProvider(PackOutput packOutput) {
        super(packOutput, "raided", "en_us");
    }

    protected void addTranslations() {
        this.addHelper(RaidedRegistry.INQUISITOR, "Inquisitor");
        this.addHelper(RaidedRegistry.INCINERATOR, "Incinerator");
        this.addHelper(RaidedRegistry.SAVAGER, "Savager");
        this.addHelper(RaidedRegistry.NECROMANCER, "Necromancer");
        this.addHelper(RaidedRegistry.ELECTROMANCER, "Electromancer");
        this.addSubtitle((SoundEvent)RaidedRegistry.ELECROMANCER_PREPARE_CONVERSION.get(), "Electromancer prepares conversion");
        this.addConfig("General", "General", "General settings");
        this.addConfig("inquisitorSpawnsPerWave", "Inquisitor Spawns Per Wave", "The spawns per wave for the Inquisitor before bonus spawns are applied (Must always have 8 values!)");
        this.addConfig("incineratorSpawnsPerWave", "Incinerator Spawns Per Wave", "The spawns per wave for the Incinerator before bonus spawns are applied (Must always have 8 values!)");
        this.addConfig("savagerSpawnsPerWave", "Savager Spawns Per Wave", "The spawns per wave for the Savager before bonus spawns are applied (Must always have 8 values!)");
        this.addConfig("necromancerSpawnsPerWave", "Necromancer Spawns Per Wave", "The spawns per wave for the Necromancer before bonus spawns are applied (Must always have 8 values!)");
        this.addConfig("electromancerSpawnsPerWave", "Electromancer Spawns Per Wave", "The spawns per wave for the Electromancer before bonus spawns are applied (Must always have 8 values!)");
    }

    private void addHelper(RaidRegHelper<?> helper, String name) {
        this.add(helper.getEntityType(), name);
        this.addItem((Supplier)helper.getSpawnEgg(), name + " Spawn Egg");
        this.addSubtitle(helper.getAmbient(), name + " mutters");
        this.addSubtitle(helper.getDeath(), name + " dies");
        this.addSubtitle(helper.getHurt(), name + " hurts");
        this.addSubtitle(helper.getCelebrate(), name + " cheers");
        if (helper.getCasting() != null) {
            this.addSubtitle(helper.getCasting(), name + " casts spell");
        }
    }

    public void addSubtitle(SoundEvent sound, String text) {
        String path = "raided.subtitle." + sound.getLocation().getPath();
        this.add(path, text);
    }

    private void addConfig(String path, String name, @Nullable String description) {
        this.add("raided.configuration." + path, name);
        if (description != null && !description.isEmpty()) {
            this.add("raided.configuration." + path + ".tooltip", description);
        }
    }
}

