/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.raided.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mrbysco.raided.entity.Incinerator;
import java.util.Arrays;
import net.minecraft.client.model.ArmedModel;
import net.minecraft.client.model.HeadedModel;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.item.ItemStack;

public class IncineratorModel<T extends Incinerator>
extends HierarchicalModel<T>
implements ArmedModel,
HeadedModel {
    private static final int STICK_COUNT = 4;
    private final ModelPart root;
    private final ModelPart head;
    private final ModelPart hat;
    private final ModelPart body;
    private final ModelPart leftArm;
    private final ModelPart leftArmLower;
    private final ModelPart rightArm;
    private final ModelPart leftLeg;
    private final ModelPart rightLeg;
    private final ModelPart blazeHead;
    private final ModelPart tankRope1;
    private final ModelPart tankRope2;
    private final ModelPart[] blazeSticks;

    public IncineratorModel(ModelPart modelPart) {
        this.root = modelPart.getChild("root");
        this.head = this.root.getChild("head");
        this.hat = this.head.getChild("hat");
        this.body = this.root.getChild("body");
        this.leftArm = this.root.getChild("left_arm");
        this.leftArmLower = this.leftArm.getChild("left_arm_lower");
        this.rightArm = this.root.getChild("right_arm");
        this.leftLeg = this.root.getChild("left_leg");
        this.rightLeg = this.root.getChild("right_leg");
        ModelPart tank = this.root.getChild("tank");
        this.blazeHead = tank.getChild("blaze_head");
        this.tankRope1 = this.root.getChild("tank_rope1");
        this.tankRope2 = this.tankRope1.getChild("tank_rope2");
        this.blazeSticks = new ModelPart[4];
        Arrays.setAll(this.blazeSticks, index -> tank.getChild(IncineratorModel.getStickName(index)));
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition root = partdefinition.addOrReplaceChild("root", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition head = root.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 0).addBox(-4.0f, -10.0f, -4.0f, 8.0f, 10.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-27.0f, (float)0.0f));
        head.addOrReplaceChild("hat", CubeListBuilder.create().texOffs(32, 0).addBox(-4.0f, -10.0f, -4.0f, 8.0f, 10.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        head.addOrReplaceChild("nose", CubeListBuilder.create().texOffs(24, 0).addBox(-1.0f, -1.0f, -2.0f, 2.0f, 4.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-2.0f, (float)-4.0f));
        head.addOrReplaceChild("cigar", CubeListBuilder.create().texOffs(56, 0).addBox(-0.5f, -0.5f, -4.0f, 1.0f, 1.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-1.0f, (float)-1.0f, (float)-4.0f, (float)0.0f, (float)0.7854f, (float)0.0f));
        PartDefinition body = root.addOrReplaceChild("body", CubeListBuilder.create().texOffs(28, 18).addBox(-7.0f, -27.0f, -3.5f, 14.0f, 17.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        body.addOrReplaceChild("layer", CubeListBuilder.create().texOffs(0, 42).addBox(-7.5f, -0.5f, -4.0f, 15.0f, 20.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-27.0f, (float)0.0f));
        body.addOrReplaceChild("gauge", CubeListBuilder.create().texOffs(46, 42).addBox(-2.5f, -2.5f, -1.0f, 5.0f, 5.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offset((float)4.5f, (float)-21.5f, (float)-3.5f));
        PartDefinition leftArm = root.addOrReplaceChild("left_arm", CubeListBuilder.create().texOffs(70, 27).addBox(0.0f, -2.0f, -3.5f, 5.0f, 8.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offset((float)7.0f, (float)-25.0f, (float)0.0f));
        leftArm.addOrReplaceChild("left_arm_lower", CubeListBuilder.create().texOffs(70, 54).addBox(-2.51f, 0.0f, -7.0f, 5.0f, 9.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offset((float)2.5f, (float)6.0f, (float)3.5f));
        leftArm.addOrReplaceChild("flamethrower1", CubeListBuilder.create().texOffs(114, 32).addBox(-2.51f, 2.0f, 0.0f, 5.0f, 10.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offset((float)2.5f, (float)6.0f, (float)3.5f));
        leftArm.addOrReplaceChild("flamethrower2", CubeListBuilder.create().texOffs(114, 47).addBox(-1.5f, 5.0f, 1.0f, 3.0f, 10.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offset((float)2.5f, (float)6.0f, (float)3.5f));
        leftArm.addOrReplaceChild("flamethrower3", CubeListBuilder.create().texOffs(114, 60).addBox(-1.0f, 8.0f, -4.0f, 2.0f, 2.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)2.5f, (float)6.0f, (float)3.5f));
        leftArm.addOrReplaceChild("flamethrower4", CubeListBuilder.create().texOffs(114, 66).addBox(2.49f, 3.0f, 1.0f, 1.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offset((float)2.5f, (float)6.0f, (float)3.5f));
        PartDefinition rightArm = root.addOrReplaceChild("right_arm", CubeListBuilder.create(), PartPose.offset((float)-7.0f, (float)-25.0f, (float)0.0f));
        rightArm.addOrReplaceChild("right_arm_r1", CubeListBuilder.create().texOffs(70, 27).addBox(-5.0f, -3.0f, -3.5f, 5.0f, 8.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)1.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        rightArm.addOrReplaceChild("right_arm_lower", CubeListBuilder.create().texOffs(70, 54).addBox(-2.49f, 0.0f, -7.0f, 5.0f, 9.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-2.5f, (float)6.0f, (float)3.5f));
        root.addOrReplaceChild("left_leg", CubeListBuilder.create().texOffs(0, 25).addBox(-3.5f, 0.0f, -3.5f, 7.0f, 10.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offset((float)3.5f, (float)-10.0f, (float)0.0f));
        root.addOrReplaceChild("right_leg", CubeListBuilder.create().texOffs(0, 25).addBox(-3.5f, 0.0f, -3.5f, 7.0f, 10.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-3.5f, (float)-10.0f, (float)0.0f));
        PartDefinition tank = root.addOrReplaceChild("tank", CubeListBuilder.create().texOffs(94, 0).addBox(-8.0f, -8.0f, 0.0f, 16.0f, 16.0f, 16.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-16.0f, (float)4.5f));
        tank.addOrReplaceChild("tank2", CubeListBuilder.create().texOffs(94, 32).addBox(0.0f, -4.0f, -4.0f, 2.0f, 8.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offset((float)8.0f, (float)0.0f, (float)8.0f));
        tank.addOrReplaceChild("tank3", CubeListBuilder.create().texOffs(94, 48).addBox(-2.0f, -4.0f, -4.0f, 2.0f, 8.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-8.0f, (float)0.0f, (float)8.0f));
        tank.addOrReplaceChild("tank4", CubeListBuilder.create().texOffs(94, 64).addBox(-1.0f, -4.0f, -3.0f, 2.0f, 4.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-9.0f, (float)-3.0f, (float)8.0f, (float)0.0f, (float)0.0f, (float)-0.7854f));
        tank.addOrReplaceChild("blaze_head", CubeListBuilder.create().texOffs(158, 0).addBox(-4.0f, -8.0f, -4.0f, 8.0f, 8.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)4.0f, (float)8.0f));
        PartDefinition tankRope1 = root.addOrReplaceChild("tank_rope1", CubeListBuilder.create().texOffs(114, 72).addBox(0.0f, -1.0f, -1.0f, 8.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)11.0f, (float)-16.0f, (float)12.5f));
        tankRope1.addOrReplaceChild("tank_rope2", CubeListBuilder.create().texOffs(114, 72).addBox(0.0f, -1.0f, -2.0f, 8.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)8.0f, (float)0.0f, (float)1.0f));
        CubeListBuilder stickCube = CubeListBuilder.create().texOffs(158, 16).addBox(-1.0f, -4.0f, 6.0f, 2.0f, 8.0f, 2.0f);
        for (int i = 0; i < 4; ++i) {
            tank.addOrReplaceChild(IncineratorModel.getStickName(i), stickCube, PartPose.offset((float)0.0f, (float)0.0f, (float)8.0f));
        }
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)256, (int)128);
    }

    private static String getStickName(int index) {
        return "stick" + index;
    }

    public void setupAnim(T entityIn, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        ItemStack itemstack = entityIn.getItemBySlot(EquipmentSlot.HEAD);
        this.head.yRot = netHeadYaw / 57.295776f;
        this.head.xRot = headPitch / 57.295776f;
        if (itemstack.isEmpty()) {
            this.leftArm.xRot = 0.0f;
            this.rightArm.xRot = Mth.cos((float)(limbSwing * 0.6662f)) * 0.8f * limbSwingAmount * 0.5f;
            this.leftArm.zRot = 0.0f;
            this.rightArm.zRot = 0.0f;
            if (this.attackTime > -9990.0f) {
                this.holdingMelee();
            }
            this.rightArm.zRot -= Mth.cos((float)(ageInTicks * 0.09f)) * 0.025f + 0.025f;
            this.rightArm.xRot -= Mth.sin((float)(ageInTicks * 0.067f)) * 0.025f;
            this.leftArm.xRot -= this.degToRad(15.0f);
            this.leftArm.xRot = -this.degToRad(30.0f);
            this.leftArm.yRot = 0.0f;
            this.tankRope1.yRot = this.degToRad(45.0f);
            this.tankRope1.zRot = this.degToRad(90.0f);
            this.tankRope2.yRot = this.degToRad(90.0f);
        }
        if (((Incinerator)((Object)entityIn)).isThrowing()) {
            this.animationThrow();
        }
        this.leftLeg.xRot = Mth.cos((float)(limbSwing * 0.6662f)) * 0.8f * limbSwingAmount;
        this.rightLeg.xRot = Mth.cos((float)(limbSwing * 0.6662f + (float)Math.PI)) * 0.8f * limbSwingAmount;
        this.leftLeg.yRot = 0.0f;
        this.rightLeg.yRot = 0.0f;
        this.leftLeg.zRot = 0.0f;
        this.rightLeg.zRot = 0.0f;
        float f = ageInTicks * (float)Math.PI * -0.1f;
        for (int i = 0; i < 4; ++i) {
            this.blazeSticks[i].y = 2.0f + Mth.cos((float)(((float)(i * 2) + ageInTicks) * 0.25f));
            this.blazeSticks[i].x = Mth.cos((float)f) * 6.0f;
            this.blazeSticks[i].z = Mth.sin((float)f) * 6.0f;
            f += 1.0f;
        }
        this.blazeHead.yRot = netHeadYaw * ((float)Math.PI / 180);
        this.blazeHead.xRot = headPitch * ((float)Math.PI / 180);
        if (entityIn.isPassenger()) {
            this.rightLeg.xRot += -0.62831855f;
            this.leftLeg.xRot = -1.4137167f;
            this.leftLeg.yRot = 0.31415927f;
            this.leftLeg.zRot = 0.07853982f;
            this.rightLeg.xRot = -1.4137167f;
            this.rightLeg.yRot = -0.31415927f;
            this.rightLeg.zRot = -0.07853982f;
        }
    }

    public void holdingMelee() {
        float f6 = 1.0f - this.attackTime;
        f6 *= f6;
        f6 *= f6;
        f6 = 1.0f - f6;
        float f7 = Mth.sin((float)(f6 * (float)Math.PI));
        float f8 = Mth.sin((float)(this.attackTime * (float)Math.PI)) * -(this.head.xRot - 0.7f) * 0.75f;
        this.leftArm.xRot = (float)((double)this.leftArm.xRot - ((double)f7 * 1.2 + (double)f8));
        this.leftArm.xRot += this.body.yRot * 2.0f;
        this.leftArm.zRot = Mth.sin((float)(this.attackTime * (float)Math.PI)) * -0.4f;
    }

    private void animationThrow() {
        this.leftArm.yRot = -this.degToRad(30.0f);
        this.leftArmLower.xRot = -this.degToRad(60.0f);
        this.tankRope1.yRot = -this.degToRad(60.0f);
        this.tankRope1.zRot = -this.degToRad(90.0f);
        this.tankRope2.yRot = -this.degToRad(60.0f);
    }

    protected float degToRad(float degrees) {
        return degrees * (float)Math.PI / 180.0f;
    }

    public ModelPart root() {
        return this.root;
    }

    private ModelPart getArm(HumanoidArm arm) {
        return arm == HumanoidArm.LEFT ? this.leftArm : this.rightArm;
    }

    public ModelPart getHead() {
        return this.head;
    }

    public void translateToHand(HumanoidArm arm, PoseStack poseStack) {
        this.getArm(arm).translateAndRotate(poseStack);
    }
}

