#version 150

uniform sampler2D Sampler0;

uniform vec4 ColorModulator;

in vec4 vertexColor;
in vec2 texCoord0;

out vec4 fragColor;

float f_spread = .35;
float f_desaturate = 3.0;
float contrast = 35.0;

float truncate(float val) {
    if (val > 255.0) {
        return 255.0;
    }
    if (val < 0.0) {
        return 0.0;
    }
    return val;
}

vec3 spread(vec3 color, float factor)
{
    float mul = 1.0 + ((color.r + color.g + color.b) * 1.0 - 1.0) * factor;
    return color * mul;
}

vec3 desaturate(vec3 color, float factor) {
    vec3 luma = vec3(0.299, 0.587, 0.114);
    vec3 gray = vec3(dot(luma, color));
    return vec3(mix(color, gray, factor));
}

void main() {
    vec4 color = texture(Sampler0, texCoord0);
    color.rgb = desaturate(spread(color.rgb, f_spread), f_desaturate);
    if (color.a < 0.1) {
        discard;
    }

    float rr = .5;
    float rg = .6;
    float rb = .4;
    float ra = 0.0;

    float gr = .5;
    float gg = .35;
    float gb = .3;
    float ga = 0.0;

    float br = .4;
    float bg = .25;
    float bb = .15;
    float ba = 0.0;

    // sepia calculation
    float s_red = (rr * color.r) + (rb * color.b) + (rg * color.g) + (ra * color.a);
    float s_green = (gr * color.r) + (gb * color.b) + (gg * color.g) + (ga * color.a);
    float s_blue = (br * color.r) + (bb * color.b) + (bg * color.g) + (ba * color.a);

    // increase contrast
    float factor = (259.0 * (contrast + 255.0)) / (255.0 * (259.0 - contrast));
    float c_red = truncate(factor * ((s_red - contrast) + contrast));
    float c_green = truncate(factor * ((s_green - contrast) + contrast));
    float c_blue = truncate(factor * ((s_blue - contrast) + contrast));

    //        color = vec4(truncate(s_red), truncate(s_green), trunc(s_blue), 1.0);
    color = vec4(c_red, c_green, c_blue, 1.0);

    //            color = vec4(color.r, color.g, color.b, 1.0);
    fragColor = color;
}

