/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.data;

import codechicken.lib.data.DataUtils;
import codechicken.lib.vec.Cuboid6;
import codechicken.lib.vec.Vector3;
import io.netty.buffer.ByteBuf;
import io.netty.handler.codec.EncoderException;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtIo;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamEncoder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.fluids.FluidStack;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;

public interface MCDataOutput {
    public MCDataOutput writeByte(int var1);

    public MCDataOutput writeChar(int var1);

    public MCDataOutput writeShort(int var1);

    public MCDataOutput writeInt(int var1);

    public MCDataOutput writeLong(long var1);

    public MCDataOutput writeFloat(float var1);

    public MCDataOutput writeDouble(double var1);

    public MCDataOutput writeBoolean(boolean var1);

    default public MCDataOutput writeBytes(byte[] b) {
        return this.writeBytes(b, 0, b.length);
    }

    default public MCDataOutput writeBytes(byte[] b, int off, int len) {
        Objects.requireNonNull(b);
        DataUtils.checkLen(b.length, off, len);
        this.writeVarInt(len);
        for (int i = 0; i < len; ++i) {
            this.writeByte(b[off + i]);
        }
        return this;
    }

    default public MCDataOutput writeChars(char[] c) {
        return this.writeChars(c, 0, c.length);
    }

    default public MCDataOutput writeChars(char[] c, int off, int len) {
        Objects.requireNonNull(c);
        DataUtils.checkLen(c.length, off, len);
        this.writeVarInt(len);
        for (int i = 0; i < len; ++i) {
            this.writeChar(c[off + i]);
        }
        return this;
    }

    default public MCDataOutput writeShorts(short[] s) {
        return this.writeShorts(s, 0, s.length);
    }

    default public MCDataOutput writeShorts(short[] s, int off, int len) {
        Objects.requireNonNull(s);
        DataUtils.checkLen(s.length, off, len);
        this.writeVarInt(len);
        for (int i = 0; i < len; ++i) {
            this.writeShort(s[off + i]);
        }
        return this;
    }

    default public MCDataOutput writeInts(int[] i) {
        return this.writeInts(i, 0, i.length);
    }

    default public MCDataOutput writeInts(int[] i, int off, int len) {
        Objects.requireNonNull(i);
        DataUtils.checkLen(i.length, off, len);
        this.writeVarInt(len);
        for (int i2 = 0; i2 < len; ++i2) {
            this.writeInt(i[off + i2]);
        }
        return this;
    }

    default public MCDataOutput writeLongs(long[] l) {
        return this.writeLongs(l, 0, l.length);
    }

    default public MCDataOutput writeLongs(long[] l, int off, int len) {
        Objects.requireNonNull(l);
        DataUtils.checkLen(l.length, off, len);
        this.writeVarInt(len);
        for (int i2 = 0; i2 < len; ++i2) {
            this.writeLong(l[off + i2]);
        }
        return this;
    }

    default public MCDataOutput writeFloats(float[] f) {
        return this.writeFloats(f, 0, f.length);
    }

    default public MCDataOutput writeFloats(float[] f, int off, int len) {
        Objects.requireNonNull(f);
        DataUtils.checkLen(f.length, off, len);
        this.writeVarInt(len);
        for (int i2 = 0; i2 < len; ++i2) {
            this.writeFloat(f[off + i2]);
        }
        return this;
    }

    default public MCDataOutput writeDoubles(double[] d) {
        return this.writeDoubles(d, 0, d.length);
    }

    default public MCDataOutput writeDoubles(double[] d, int off, int len) {
        Objects.requireNonNull(d);
        DataUtils.checkLen(d.length, off, len);
        this.writeVarInt(len);
        for (int i2 = 0; i2 < len; ++i2) {
            this.writeDouble(d[off + i2]);
        }
        return this;
    }

    default public MCDataOutput writeBooleans(boolean[] b) {
        return this.writeBooleans(b, 0, b.length);
    }

    default public MCDataOutput writeBooleans(boolean[] b, int off, int len) {
        Objects.requireNonNull(b);
        DataUtils.checkLen(b.length, off, len);
        this.writeVarInt(len);
        for (int i2 = 0; i2 < len; ++i2) {
            this.writeBoolean(b[off + i2]);
        }
        return this;
    }

    default public MCDataOutput append(byte[] bytes) {
        for (byte b : bytes) {
            this.writeByte(b);
        }
        return this;
    }

    default public MCDataOutput writeVarInt(int i) {
        while ((i & 0xFFFFFF80) != 0) {
            this.writeByte(i & 0x7F | 0x80);
            i >>>= 7;
        }
        this.writeByte(i);
        return this;
    }

    default public MCDataOutput writeVarLong(long l) {
        while ((l & 0xFFFFFFFFFFFFFF80L) != 0L) {
            this.writeByte((int)(l & 0x7FL) | 0x80);
            l >>>= 7;
        }
        this.writeByte((int)l);
        return this;
    }

    default public MCDataOutput writeSignedVarInt(int i) {
        return this.writeVarInt(i >= 0 ? 2 * i : -2 * (i + 1) + 1);
    }

    default public MCDataOutput writeSignedVarLong(long i) {
        return this.writeVarLong(i >= 0L ? 2L * i : -2L * (i + 1L) + 1L);
    }

    default public MCDataOutput writeVarInts(int[] i) {
        return this.writeVarInts(i, 0, i.length);
    }

    default public MCDataOutput writeVarInts(int[] i, int off, int len) {
        Objects.requireNonNull(i);
        DataUtils.checkLen(i.length, off, len);
        this.writeVarInt(len);
        for (int i2 = 0; i2 < len; ++i2) {
            this.writeVarInt(i[off + i2]);
        }
        return this;
    }

    default public MCDataOutput writeVarLongs(long[] l) {
        return this.writeVarLongs(l, 0, l.length);
    }

    default public MCDataOutput writeVarLongs(long[] l, int off, int len) {
        Objects.requireNonNull(l);
        DataUtils.checkLen(l.length, off, len);
        this.writeVarInt(len);
        for (int i2 = 0; i2 < len; ++i2) {
            this.writeVarLong(l[off + i2]);
        }
        return this;
    }

    default public MCDataOutput writeSignedVarInts(int[] i) {
        return this.writeSignedVarInts(i, 0, i.length);
    }

    default public MCDataOutput writeSignedVarInts(int[] i, int off, int len) {
        Objects.requireNonNull(i);
        DataUtils.checkLen(i.length, off, len);
        this.writeVarInt(len);
        for (int i2 = 0; i2 < len; ++i2) {
            this.writeSignedVarInt(i[off + i2]);
        }
        return this;
    }

    default public MCDataOutput writeSignedVarLongs(long[] l) {
        return this.writeSignedVarLongs(l, 0, l.length);
    }

    default public MCDataOutput writeSignedVarLongs(long[] l, int off, int len) {
        Objects.requireNonNull(l);
        DataUtils.checkLen(l.length, off, len);
        this.writeVarInt(len);
        for (int i2 = 0; i2 < len; ++i2) {
            this.writeSignedVarLong(l[off + i2]);
        }
        return this;
    }

    default public MCDataOutput writeString(String s) {
        return this.writeString(s, Short.MAX_VALUE);
    }

    default public MCDataOutput writeString(String s, int maxLen) {
        byte[] bytes = s.getBytes(StandardCharsets.UTF_8);
        if (bytes.length > maxLen) {
            throw new EncoderException("String too big. Encoded: " + bytes.length + " Max: " + maxLen);
        }
        this.writeBytes(bytes);
        return this;
    }

    default public MCDataOutput writeUUID(UUID uuid) {
        this.writeLong(uuid.getMostSignificantBits());
        this.writeLong(uuid.getLeastSignificantBits());
        return this;
    }

    default public MCDataOutput writeEnum(Enum<?> value) {
        this.writeVarInt(value.ordinal());
        return this;
    }

    default public MCDataOutput writeByteBuffer(ByteBuffer buffer) {
        int len = buffer.remaining();
        this.writeVarInt(len);
        for (int i = 0; i < len; ++i) {
            this.writeByte(buffer.get());
        }
        return this;
    }

    default public MCDataOutput writeCharBuffer(CharBuffer buffer) {
        int len = buffer.remaining();
        this.writeVarInt(len);
        for (int i = 0; i < len; ++i) {
            this.writeChar(buffer.get());
        }
        return this;
    }

    default public MCDataOutput writeShortBuffer(ShortBuffer buffer) {
        int len = buffer.remaining();
        this.writeVarInt(len);
        for (int i = 0; i < len; ++i) {
            this.writeShort(buffer.get());
        }
        return this;
    }

    default public MCDataOutput writeIntBuffer(IntBuffer buffer) {
        int len = buffer.remaining();
        this.writeVarInt(len);
        for (int i = 0; i < len; ++i) {
            this.writeInt(buffer.get());
        }
        return this;
    }

    default public MCDataOutput writeLongBuffer(LongBuffer buffer) {
        int len = buffer.remaining();
        this.writeVarInt(len);
        for (int i = 0; i < len; ++i) {
            this.writeLong(buffer.get());
        }
        return this;
    }

    default public MCDataOutput writeFloatBuffer(FloatBuffer buffer) {
        int len = buffer.remaining();
        this.writeVarInt(len);
        for (int i = 0; i < len; ++i) {
            this.writeFloat(buffer.get());
        }
        return this;
    }

    default public MCDataOutput writeDoubleBuffer(DoubleBuffer buffer) {
        int len = buffer.remaining();
        this.writeVarInt(len);
        for (int i = 0; i < len; ++i) {
            this.writeDouble(buffer.get());
        }
        return this;
    }

    default public MCDataOutput writeVector(Vector3 vec) {
        this.writeDouble(vec.x);
        this.writeDouble(vec.y);
        this.writeDouble(vec.z);
        return this;
    }

    default public MCDataOutput writeCuboid(Cuboid6 cuboid) {
        this.writeVector(cuboid.min);
        this.writeVector(cuboid.max);
        return this;
    }

    default public MCDataOutput writeResourceLocation(ResourceLocation loc) {
        return this.writeString(loc.toString());
    }

    default public MCDataOutput writeDirection(Direction dir) {
        return this.writeEnum((Enum<?>)dir);
    }

    default public MCDataOutput writePos(BlockPos pos) {
        return this.writeVec3i((Vec3i)pos);
    }

    default public MCDataOutput writeVec3i(Vec3i vec) {
        this.writeSignedVarInt(vec.getX());
        this.writeSignedVarInt(vec.getY());
        this.writeSignedVarInt(vec.getZ());
        return this;
    }

    default public MCDataOutput writeVec3f(Vector3f vec) {
        this.writeFloat(vec.x());
        this.writeFloat(vec.y());
        this.writeFloat(vec.z());
        return this;
    }

    default public MCDataOutput writeVec3d(Vec3 vec) {
        this.writeDouble(vec.x);
        this.writeDouble(vec.y);
        this.writeDouble(vec.z);
        return this;
    }

    default public MCDataOutput writeCompoundNBT(CompoundTag tag) {
        try {
            NbtIo.write((CompoundTag)tag, (DataOutput)this.toDataOutput());
        }
        catch (IOException e) {
            throw new EncoderException("Failed to write CompoundNBT to stream.", (Throwable)e);
        }
        return this;
    }

    default public MCDataOutput writeNullableCompoundNBT(@Nullable CompoundTag tag) {
        if (tag == null) {
            this.writeBoolean(false);
        } else {
            this.writeBoolean(true);
            this.writeCompoundNBT(tag);
        }
        return this;
    }

    default public MCDataOutput writeItemStack(ItemStack stack) {
        return this.writeWithRegistryCodec((StreamEncoder)ItemStack.OPTIONAL_STREAM_CODEC, (Object)stack);
    }

    default public MCDataOutput writeFluidStack(FluidStack stack) {
        return this.writeWithRegistryCodec((StreamEncoder)FluidStack.OPTIONAL_STREAM_CODEC, (Object)stack);
    }

    default public MCDataOutput writeTextComponent(Component component) {
        return this.writeString(Component.Serializer.toJson((Component)component, (HolderLookup.Provider)RegistryAccess.EMPTY), 262144);
    }

    default public <T> MCDataOutput writeRegistryIdDirect(Registry<T> registry, T entry) {
        this.writeVarInt(registry.getId(entry));
        return this;
    }

    default public <T> MCDataOutput writeRegistryIdDirect(Registry<T> registry, ResourceLocation entry) {
        this.writeVarInt(registry.getId(entry));
        return this;
    }

    default public <T> MCDataOutput writeRegistryId(Registry<T> registry, T entry) {
        ResourceLocation rName = registry.key().location();
        if (!registry.containsValue(entry)) {
            throw new IllegalArgumentException(String.format("Registry '%s' does not contain entry '%s'", rName, entry));
        }
        this.writeResourceLocation(rName);
        this.writeRegistryIdDirect(registry, entry);
        return this;
    }

    default public <T> MCDataOutput writeRegistryId(Registry<T> registry, ResourceLocation entry) {
        ResourceLocation rName = registry.key().location();
        if (!registry.containsKey(entry)) {
            throw new IllegalArgumentException(String.format("Registry '%s' does not contain entry '%s'", rName, entry));
        }
        this.writeResourceLocation(rName);
        this.writeRegistryIdDirect(registry, entry);
        return this;
    }

    default public <T> MCDataOutput writeWithCodec(StreamEncoder<? super FriendlyByteBuf, T> codec, T thing) {
        throw new RuntimeException("Only able to use StreamCodec's with PacketCustom instances.");
    }

    default public <T> MCDataOutput writeWithRegistryCodec(StreamEncoder<? super RegistryFriendlyByteBuf, T> codec, T thing) {
        throw new RuntimeException("Only able to use StreamCodec's with PacketCustom instances.");
    }

    default public MCDataOutput writeByteBuf(ByteBuf buf) {
        byte[] arr = new byte[buf.readableBytes()];
        buf.readBytes(arr);
        return this.writeBytes(arr);
    }

    default public MCDataOutput append(ByteBuf buf) {
        byte[] arr = new byte[buf.readableBytes()];
        buf.readBytes(arr);
        return this.append(arr);
    }

    default public DataOutput toDataOutput() {
        return new DataOutputStream(this.toOutputStream());
    }

    default public OutputStream toOutputStream() {
        return new OutputStreamWrapper(this);
    }

    public static final class OutputStreamWrapper
    extends OutputStream {
        private final MCDataOutput out;

        public OutputStreamWrapper(MCDataOutput out) {
            this.out = out;
        }

        @Override
        public void write(int b) {
            this.out.writeByte(b);
        }
    }
}

