/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.waypoint;

import java.util.TreeSet;
import journeymap.client.texture.IgnSkin;
import journeymap.client.waypoint.ClientWaypointImpl;
import journeymap.common.helper.DimensionHelper;
import journeymap.common.waypoint.WaypointIcon;
import journeymap.common.waypoint.WaypointPos;
import journeymap.common.waypoint.WaypointSettings;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;

public class PlayerPoint
extends ClientWaypointImpl {
    private final Player player;

    public PlayerPoint(Player player) {
        super(player.getDisplayName().getString(), new WaypointPos(player.blockPosition(), DimensionHelper.getDimKeyName((ResourceKey<Level>)player.level().dimension())), -1, new WaypointSettings(), "player", new TreeSet<String>(), new WaypointIcon(), "player_icon_display");
        this.player = player;
    }

    @Override
    public Integer getIconColor() {
        return -1;
    }

    @Override
    public String getDisplayName() {
        return this.player.getDisplayName().getString();
    }

    @Override
    public int getX() {
        return this.player.blockPosition().getX();
    }

    @Override
    public int getZ() {
        return this.player.blockPosition().getZ();
    }

    @Override
    public int getY() {
        return this.player.blockPosition().getY();
    }

    @Override
    public boolean isInPlayerDimension() {
        return super.isInPlayerDimension();
    }

    @Override
    public boolean hasCustomTexture() {
        return super.hasCustomTexture();
    }

    @Override
    public boolean hasCustomIconColor() {
        return super.hasCustomIconColor();
    }

    @Override
    public DynamicTexture getTexture() {
        return IgnSkin.getFace(this.player.getGameProfile());
    }
}

