/*
 * Decompiled with CFR 0.152.
 */
package moonfather.cookyourfood.client;

import moonfather.cookyourfood.FoodResolver;
import moonfather.cookyourfood.OptionsHolder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Items;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.entity.player.ItemTooltipEvent;

@EventBusSubscriber(modid="cookyourfood", bus=EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public class EventForTooltips {
    private static final Component messageSevere = Component.translatable((String)"message.shared").withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)13123632)));
    private static final Component messageNormal = Component.translatable((String)"message.shared").withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)16099611)));
    private static final Component messageLight = Component.translatable((String)"message.shared").withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)14542860)));

    public static void OnItemTooltip(ItemTooltipEvent event) {
        if (event.getItemStack().isEmpty() || event.getItemStack().getFoodProperties((LivingEntity)event.getEntity()) == null || event.getEntity() == null) {
            return;
        }
        FoodResolver.RawFoodRank rank = FoodResolver.Resolve(event.getItemStack(), event.getEntity().level(), (LivingEntity)event.getEntity());
        if (rank.equals((Object)FoodResolver.RawFoodRank.Severe) || event.getItemStack().getItem().equals(Items.PUFFERFISH)) {
            event.getToolTip().add(messageSevere);
        } else if (rank.equals((Object)FoodResolver.RawFoodRank.Light)) {
            event.getToolTip().add(messageLight);
        } else if (rank.equals((Object)FoodResolver.RawFoodRank.Normal)) {
            event.getToolTip().add(messageNormal);
        }
    }

    @SubscribeEvent
    public static void Initialize(FMLClientSetupEvent event) {
        if (((Boolean)OptionsHolder.CLIENT.ShowWarningsInTooltip.get()).booleanValue()) {
            NeoForge.EVENT_BUS.addListener(EventForTooltips::OnItemTooltip);
        }
    }
}

